/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.JobSummary;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link JobSummary} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class JobSummaryMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobId").isBinary(false).build();

    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobName").isBinary(false).build();

    private static final MarshallingInfo<Long> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();

    private static final MarshallingInfo<String> STATUSREASON_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusReason").isBinary(false).build();

    private static final MarshallingInfo<Long> STARTEDAT_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startedAt").isBinary(false).build();

    private static final MarshallingInfo<Long> STOPPEDAT_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stoppedAt").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CONTAINER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("container").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ARRAYPROPERTIES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("arrayProperties").isBinary(false).build();

    private static final JobSummaryMarshaller INSTANCE = new JobSummaryMarshaller();

    private JobSummaryMarshaller() {
    }

    public static JobSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(JobSummary jobSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(jobSummary, "jobSummary");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(jobSummary.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall(jobSummary.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall(jobSummary.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(jobSummary.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(jobSummary.statusReason(), STATUSREASON_BINDING);
            protocolMarshaller.marshall(jobSummary.startedAt(), STARTEDAT_BINDING);
            protocolMarshaller.marshall(jobSummary.stoppedAt(), STOPPEDAT_BINDING);
            protocolMarshaller.marshall(jobSummary.container(), CONTAINER_BINDING);
            protocolMarshaller.marshall(jobSummary.arrayProperties(), ARRAYPROPERTIES_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
