/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.batch.model.KeyValuePair;
import software.amazon.awssdk.services.batch.model.MountPoint;
import software.amazon.awssdk.services.batch.model.MountPointsCopier;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.services.batch.model.Ulimit;
import software.amazon.awssdk.services.batch.model.UlimitsCopier;
import software.amazon.awssdk.services.batch.model.Volume;
import software.amazon.awssdk.services.batch.model.VolumesCopier;
import software.amazon.awssdk.services.batch.transform.ContainerPropertiesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerProperties
implements StructuredPojo,
ToCopyableBuilder<Builder, ContainerProperties> {
    private final String image;
    private final Integer vcpus;
    private final Integer memory;
    private final List<String> command;
    private final String jobRoleArn;
    private final List<Volume> volumes;
    private final List<KeyValuePair> environment;
    private final List<MountPoint> mountPoints;
    private final Boolean readonlyRootFilesystem;
    private final Boolean privileged;
    private final List<Ulimit> ulimits;
    private final String user;

    private ContainerProperties(BuilderImpl builder) {
        this.image = builder.image;
        this.vcpus = builder.vcpus;
        this.memory = builder.memory;
        this.command = builder.command;
        this.jobRoleArn = builder.jobRoleArn;
        this.volumes = builder.volumes;
        this.environment = builder.environment;
        this.mountPoints = builder.mountPoints;
        this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
        this.privileged = builder.privileged;
        this.ulimits = builder.ulimits;
        this.user = builder.user;
    }

    public String image() {
        return this.image;
    }

    public Integer vcpus() {
        return this.vcpus;
    }

    public Integer memory() {
        return this.memory;
    }

    public List<String> command() {
        return this.command;
    }

    public String jobRoleArn() {
        return this.jobRoleArn;
    }

    public List<Volume> volumes() {
        return this.volumes;
    }

    public List<KeyValuePair> environment() {
        return this.environment;
    }

    public List<MountPoint> mountPoints() {
        return this.mountPoints;
    }

    public Boolean readonlyRootFilesystem() {
        return this.readonlyRootFilesystem;
    }

    public Boolean privileged() {
        return this.privileged;
    }

    public List<Ulimit> ulimits() {
        return this.ulimits;
    }

    public String user() {
        return this.user;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.vcpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumes());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountPoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.readonlyRootFilesystem());
        hashCode = 31 * hashCode + Objects.hashCode(this.privileged());
        hashCode = 31 * hashCode + Objects.hashCode(this.ulimits());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerProperties)) {
            return false;
        }
        ContainerProperties other = (ContainerProperties)obj;
        return Objects.equals(this.image(), other.image()) && Objects.equals(this.vcpus(), other.vcpus()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.command(), other.command()) && Objects.equals(this.jobRoleArn(), other.jobRoleArn()) && Objects.equals(this.volumes(), other.volumes()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.mountPoints(), other.mountPoints()) && Objects.equals(this.readonlyRootFilesystem(), other.readonlyRootFilesystem()) && Objects.equals(this.privileged(), other.privileged()) && Objects.equals(this.ulimits(), other.ulimits()) && Objects.equals(this.user(), other.user());
    }

    public String toString() {
        return ToString.builder((String)"ContainerProperties").add("Image", (Object)this.image()).add("Vcpus", (Object)this.vcpus()).add("Memory", (Object)this.memory()).add("Command", this.command()).add("JobRoleArn", (Object)this.jobRoleArn()).add("Volumes", this.volumes()).add("Environment", this.environment()).add("MountPoints", this.mountPoints()).add("ReadonlyRootFilesystem", (Object)this.readonlyRootFilesystem()).add("Privileged", (Object)this.privileged()).add("Ulimits", this.ulimits()).add("User", (Object)this.user()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "vcpus": {
                return Optional.ofNullable(clazz.cast(this.vcpus()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "jobRoleArn": {
                return Optional.ofNullable(clazz.cast(this.jobRoleArn()));
            }
            case "volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "mountPoints": {
                return Optional.ofNullable(clazz.cast(this.mountPoints()));
            }
            case "readonlyRootFilesystem": {
                return Optional.ofNullable(clazz.cast(this.readonlyRootFilesystem()));
            }
            case "privileged": {
                return Optional.ofNullable(clazz.cast(this.privileged()));
            }
            case "ulimits": {
                return Optional.ofNullable(clazz.cast(this.ulimits()));
            }
            case "user": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String image;
        private Integer vcpus;
        private Integer memory;
        private List<String> command = DefaultSdkAutoConstructList.getInstance();
        private String jobRoleArn;
        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();
        private List<KeyValuePair> environment = DefaultSdkAutoConstructList.getInstance();
        private List<MountPoint> mountPoints = DefaultSdkAutoConstructList.getInstance();
        private Boolean readonlyRootFilesystem;
        private Boolean privileged;
        private List<Ulimit> ulimits = DefaultSdkAutoConstructList.getInstance();
        private String user;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerProperties model) {
            this.image(model.image);
            this.vcpus(model.vcpus);
            this.memory(model.memory);
            this.command(model.command);
            this.jobRoleArn(model.jobRoleArn);
            this.volumes(model.volumes);
            this.environment(model.environment);
            this.mountPoints(model.mountPoints);
            this.readonlyRootFilesystem(model.readonlyRootFilesystem);
            this.privileged(model.privileged);
            this.ulimits(model.ulimits);
            this.user(model.user);
        }

        public final String getImage() {
            return this.image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final Integer getVcpus() {
            return this.vcpus;
        }

        @Override
        public final Builder vcpus(Integer vcpus) {
            this.vcpus = vcpus;
            return this;
        }

        public final void setVcpus(Integer vcpus) {
            this.vcpus = vcpus;
        }

        public final Integer getMemory() {
            return this.memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        public final Collection<String> getCommand() {
            return this.command;
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        public final String getJobRoleArn() {
            return this.jobRoleArn;
        }

        @Override
        public final Builder jobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
            return this;
        }

        public final void setJobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
        }

        public final Collection<Volume.Builder> getVolumes() {
            return this.volumes != null ? (Collection)this.volumes.stream().map(Volume::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (Volume)((Volume.Builder)Volume.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumesCopier.copyFromBuilder(volumes);
        }

        public final Collection<KeyValuePair.Builder> getEnvironment() {
            return this.environment != null ? (Collection)this.environment.stream().map(KeyValuePair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environment(Collection<KeyValuePair> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(KeyValuePair ... environment) {
            this.environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<KeyValuePair.Builder> ... environment) {
            this.environment(Stream.of(environment).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnvironment(Collection<KeyValuePair.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        public final Collection<MountPoint.Builder> getMountPoints() {
            return this.mountPoints != null ? (Collection)this.mountPoints.stream().map(MountPoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mountPoints(Collection<MountPoint> mountPoints) {
            this.mountPoints = MountPointsCopier.copy(mountPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(MountPoint ... mountPoints) {
            this.mountPoints(Arrays.asList(mountPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(Consumer<MountPoint.Builder> ... mountPoints) {
            this.mountPoints(Stream.of(mountPoints).map(c -> (MountPoint)((MountPoint.Builder)MountPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMountPoints(Collection<MountPoint.BuilderImpl> mountPoints) {
            this.mountPoints = MountPointsCopier.copyFromBuilder(mountPoints);
        }

        public final Boolean getReadonlyRootFilesystem() {
            return this.readonlyRootFilesystem;
        }

        @Override
        public final Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        public final void setReadonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
        }

        public final Boolean getPrivileged() {
            return this.privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        public final Collection<Ulimit.Builder> getUlimits() {
            return this.ulimits != null ? (Collection)this.ulimits.stream().map(Ulimit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ulimits(Collection<Ulimit> ulimits) {
            this.ulimits = UlimitsCopier.copy(ulimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ulimits(Ulimit ... ulimits) {
            this.ulimits(Arrays.asList(ulimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ulimits(Consumer<Ulimit.Builder> ... ulimits) {
            this.ulimits(Stream.of(ulimits).map(c -> (Ulimit)((Ulimit.Builder)Ulimit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUlimits(Collection<Ulimit.BuilderImpl> ulimits) {
            this.ulimits = UlimitsCopier.copyFromBuilder(ulimits);
        }

        public final String getUser() {
            return this.user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        public ContainerProperties build() {
            return new ContainerProperties(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ContainerProperties> {
        public Builder image(String var1);

        public Builder vcpus(Integer var1);

        public Builder memory(Integer var1);

        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);

        public Builder jobRoleArn(String var1);

        public Builder volumes(Collection<Volume> var1);

        public Builder volumes(Volume ... var1);

        public Builder volumes(Consumer<Volume.Builder> ... var1);

        public Builder environment(Collection<KeyValuePair> var1);

        public Builder environment(KeyValuePair ... var1);

        public Builder environment(Consumer<KeyValuePair.Builder> ... var1);

        public Builder mountPoints(Collection<MountPoint> var1);

        public Builder mountPoints(MountPoint ... var1);

        public Builder mountPoints(Consumer<MountPoint.Builder> ... var1);

        public Builder readonlyRootFilesystem(Boolean var1);

        public Builder privileged(Boolean var1);

        public Builder ulimits(Collection<Ulimit> var1);

        public Builder ulimits(Ulimit ... var1);

        public Builder ulimits(Consumer<Ulimit.Builder> ... var1);

        public Builder user(String var1);
    }
}

