/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.ContainerOverrides;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ContainerOverridesMarshaller {
    private static final MarshallingInfo<Integer> VCPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vcpus").isBinary(false).build();
    private static final MarshallingInfo<Integer> MEMORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memory").isBinary(false).build();
    private static final MarshallingInfo<List> COMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("command").isBinary(false).build();
    private static final MarshallingInfo<List> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environment").isBinary(false).build();
    private static final ContainerOverridesMarshaller INSTANCE = new ContainerOverridesMarshaller();

    private ContainerOverridesMarshaller() {
    }

    public static ContainerOverridesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ContainerOverrides containerOverrides, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)containerOverrides, (String)"containerOverrides");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)containerOverrides.vcpus(), VCPUS_BINDING);
            protocolMarshaller.marshall((Object)containerOverrides.memory(), MEMORY_BINDING);
            protocolMarshaller.marshall(containerOverrides.command(), COMMAND_BINDING);
            protocolMarshaller.marshall(containerOverrides.environment(), ENVIRONMENT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

