/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.ContainerSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ContainerSummaryMarshaller {
    private static final MarshallingInfo<Integer> EXITCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exitCode").isBinary(false).build();
    private static final MarshallingInfo<String> REASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reason").isBinary(false).build();
    private static final ContainerSummaryMarshaller INSTANCE = new ContainerSummaryMarshaller();

    private ContainerSummaryMarshaller() {
    }

    public static ContainerSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ContainerSummary containerSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)containerSummary, (String)"containerSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)containerSummary.exitCode(), EXITCODE_BINDING);
            protocolMarshaller.marshall((Object)containerSummary.reason(), REASON_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

