/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.DescribeJobQueuesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeJobQueuesRequestModelMarshaller {
    private static final MarshallingInfo<List> JOBQUEUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobQueues").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxResults").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextToken").isBinary(false).build();
    private static final DescribeJobQueuesRequestModelMarshaller INSTANCE = new DescribeJobQueuesRequestModelMarshaller();

    private DescribeJobQueuesRequestModelMarshaller() {
    }

    public static DescribeJobQueuesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeJobQueuesRequest describeJobQueuesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeJobQueuesRequest), (String)"describeJobQueuesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(describeJobQueuesRequest.jobQueues(), JOBQUEUES_BINDING);
            protocolMarshaller.marshall((Object)describeJobQueuesRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)describeJobQueuesRequest.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

