/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the details of a container that is part of a job attempt.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttemptContainerDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<AttemptContainerDetail.Builder, AttemptContainerDetail> {
    private static final SdkField<String> CONTAINER_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttemptContainerDetail::containerInstanceArn)).setter(setter(Builder::containerInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstanceArn").build())
            .build();

    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttemptContainerDetail::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()).build();

    private static final SdkField<Integer> EXIT_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AttemptContainerDetail::exitCode)).setter(setter(Builder::exitCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exitCode").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttemptContainerDetail::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttemptContainerDetail::logStreamName)).setter(setter(Builder::logStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_INSTANCE_ARN_FIELD,
            TASK_ARN_FIELD, EXIT_CODE_FIELD, REASON_FIELD, LOG_STREAM_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String containerInstanceArn;

    private final String taskArn;

    private final Integer exitCode;

    private final String reason;

    private final String logStreamName;

    private AttemptContainerDetail(BuilderImpl builder) {
        this.containerInstanceArn = builder.containerInstanceArn;
        this.taskArn = builder.taskArn;
        this.exitCode = builder.exitCode;
        this.reason = builder.reason;
        this.logStreamName = builder.logStreamName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon ECS container instance that hosts the job attempt.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon ECS container instance that hosts the job attempt.
     */
    public String containerInstanceArn() {
        return containerInstanceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon ECS task that is associated with the job attempt. Each container
     * attempt receives a task ARN when they reach the <code>STARTING</code> status.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon ECS task that is associated with the job attempt. Each
     *         container attempt receives a task ARN when they reach the <code>STARTING</code> status.
     */
    public String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The exit code for the job attempt. A non-zero exit code is considered a failure.
     * </p>
     * 
     * @return The exit code for the job attempt. A non-zero exit code is considered a failure.
     */
    public Integer exitCode() {
        return exitCode;
    }

    /**
     * <p>
     * A short (255 max characters) human-readable string to provide additional details about a running or stopped
     * container.
     * </p>
     * 
     * @return A short (255 max characters) human-readable string to provide additional details about a running or
     *         stopped container.
     */
    public String reason() {
        return reason;
    }

    /**
     * <p>
     * The name of the CloudWatch Logs log stream associated with the container. The log group for AWS Batch jobs is
     * <code>/aws/batch/job</code>. Each container attempt receives a log stream name when they reach the
     * <code>RUNNING</code> status.
     * </p>
     * 
     * @return The name of the CloudWatch Logs log stream associated with the container. The log group for AWS Batch
     *         jobs is <code>/aws/batch/job</code>. Each container attempt receives a log stream name when they reach
     *         the <code>RUNNING</code> status.
     */
    public String logStreamName() {
        return logStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(logStreamName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttemptContainerDetail)) {
            return false;
        }
        AttemptContainerDetail other = (AttemptContainerDetail) obj;
        return Objects.equals(containerInstanceArn(), other.containerInstanceArn()) && Objects.equals(taskArn(), other.taskArn())
                && Objects.equals(exitCode(), other.exitCode()) && Objects.equals(reason(), other.reason())
                && Objects.equals(logStreamName(), other.logStreamName());
    }

    @Override
    public String toString() {
        return ToString.builder("AttemptContainerDetail").add("ContainerInstanceArn", containerInstanceArn())
                .add("TaskArn", taskArn()).add("ExitCode", exitCode()).add("Reason", reason())
                .add("LogStreamName", logStreamName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerInstanceArn":
            return Optional.ofNullable(clazz.cast(containerInstanceArn()));
        case "taskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "exitCode":
            return Optional.ofNullable(clazz.cast(exitCode()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "logStreamName":
            return Optional.ofNullable(clazz.cast(logStreamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttemptContainerDetail, T> g) {
        return obj -> g.apply((AttemptContainerDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttemptContainerDetail> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon ECS container instance that hosts the job attempt.
         * </p>
         * 
         * @param containerInstanceArn
         *        The Amazon Resource Name (ARN) of the Amazon ECS container instance that hosts the job attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstanceArn(String containerInstanceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon ECS task that is associated with the job attempt. Each container
         * attempt receives a task ARN when they reach the <code>STARTING</code> status.
         * </p>
         * 
         * @param taskArn
         *        The Amazon Resource Name (ARN) of the Amazon ECS task that is associated with the job attempt. Each
         *        container attempt receives a task ARN when they reach the <code>STARTING</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The exit code for the job attempt. A non-zero exit code is considered a failure.
         * </p>
         * 
         * @param exitCode
         *        The exit code for the job attempt. A non-zero exit code is considered a failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exitCode(Integer exitCode);

        /**
         * <p>
         * A short (255 max characters) human-readable string to provide additional details about a running or stopped
         * container.
         * </p>
         * 
         * @param reason
         *        A short (255 max characters) human-readable string to provide additional details about a running or
         *        stopped container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The name of the CloudWatch Logs log stream associated with the container. The log group for AWS Batch jobs is
         * <code>/aws/batch/job</code>. Each container attempt receives a log stream name when they reach the
         * <code>RUNNING</code> status.
         * </p>
         * 
         * @param logStreamName
         *        The name of the CloudWatch Logs log stream associated with the container. The log group for AWS Batch
         *        jobs is <code>/aws/batch/job</code>. Each container attempt receives a log stream name when they reach
         *        the <code>RUNNING</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamName(String logStreamName);
    }

    static final class BuilderImpl implements Builder {
        private String containerInstanceArn;

        private String taskArn;

        private Integer exitCode;

        private String reason;

        private String logStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(AttemptContainerDetail model) {
            containerInstanceArn(model.containerInstanceArn);
            taskArn(model.taskArn);
            exitCode(model.exitCode);
            reason(model.reason);
            logStreamName(model.logStreamName);
        }

        public final String getContainerInstanceArn() {
            return containerInstanceArn;
        }

        @Override
        public final Builder containerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
            return this;
        }

        public final void setContainerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
        }

        public final String getTaskArn() {
            return taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final Integer getExitCode() {
            return exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getLogStreamName() {
            return logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        @Override
        public AttemptContainerDetail build() {
            return new AttemptContainerDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
