/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.AttemptContainerDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the details of a container that is part of a job attempt.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AttemptContainerDetail implements StructuredPojo,
        ToCopyableBuilder<AttemptContainerDetail.Builder, AttemptContainerDetail> {
    private final String containerInstanceArn;

    private final String taskArn;

    private final Integer exitCode;

    private final String reason;

    private AttemptContainerDetail(BuilderImpl builder) {
        this.containerInstanceArn = builder.containerInstanceArn;
        this.taskArn = builder.taskArn;
        this.exitCode = builder.exitCode;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon ECS container instance that hosts the job attempt.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon ECS container instance that hosts the job attempt.
     */
    public String containerInstanceArn() {
        return containerInstanceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon ECS task that is associated with the job attempt.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon ECS task that is associated with the job attempt.
     */
    public String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The exit code for the job attempt. A non-zero exit code is considered a failure.
     * </p>
     * 
     * @return The exit code for the job attempt. A non-zero exit code is considered a failure.
     */
    public Integer exitCode() {
        return exitCode;
    }

    /**
     * <p>
     * A short (255 max characters) human-readable string to provide additional details about a running or stopped
     * container.
     * </p>
     * 
     * @return A short (255 max characters) human-readable string to provide additional details about a running or
     *         stopped container.
     */
    public String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((containerInstanceArn() == null) ? 0 : containerInstanceArn().hashCode());
        hashCode = 31 * hashCode + ((taskArn() == null) ? 0 : taskArn().hashCode());
        hashCode = 31 * hashCode + ((exitCode() == null) ? 0 : exitCode().hashCode());
        hashCode = 31 * hashCode + ((reason() == null) ? 0 : reason().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttemptContainerDetail)) {
            return false;
        }
        AttemptContainerDetail other = (AttemptContainerDetail) obj;
        if (other.containerInstanceArn() == null ^ this.containerInstanceArn() == null) {
            return false;
        }
        if (other.containerInstanceArn() != null && !other.containerInstanceArn().equals(this.containerInstanceArn())) {
            return false;
        }
        if (other.taskArn() == null ^ this.taskArn() == null) {
            return false;
        }
        if (other.taskArn() != null && !other.taskArn().equals(this.taskArn())) {
            return false;
        }
        if (other.exitCode() == null ^ this.exitCode() == null) {
            return false;
        }
        if (other.exitCode() != null && !other.exitCode().equals(this.exitCode())) {
            return false;
        }
        if (other.reason() == null ^ this.reason() == null) {
            return false;
        }
        if (other.reason() != null && !other.reason().equals(this.reason())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (containerInstanceArn() != null) {
            sb.append("ContainerInstanceArn: ").append(containerInstanceArn()).append(",");
        }
        if (taskArn() != null) {
            sb.append("TaskArn: ").append(taskArn()).append(",");
        }
        if (exitCode() != null) {
            sb.append("ExitCode: ").append(exitCode()).append(",");
        }
        if (reason() != null) {
            sb.append("Reason: ").append(reason()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttemptContainerDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AttemptContainerDetail> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon ECS container instance that hosts the job attempt.
         * </p>
         * 
         * @param containerInstanceArn
         *        The Amazon Resource Name (ARN) of the Amazon ECS container instance that hosts the job attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstanceArn(String containerInstanceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon ECS task that is associated with the job attempt.
         * </p>
         * 
         * @param taskArn
         *        The Amazon Resource Name (ARN) of the Amazon ECS task that is associated with the job attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The exit code for the job attempt. A non-zero exit code is considered a failure.
         * </p>
         * 
         * @param exitCode
         *        The exit code for the job attempt. A non-zero exit code is considered a failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exitCode(Integer exitCode);

        /**
         * <p>
         * A short (255 max characters) human-readable string to provide additional details about a running or stopped
         * container.
         * </p>
         * 
         * @param reason
         *        A short (255 max characters) human-readable string to provide additional details about a running or
         *        stopped container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    private static final class BuilderImpl implements Builder {
        private String containerInstanceArn;

        private String taskArn;

        private Integer exitCode;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(AttemptContainerDetail model) {
            setContainerInstanceArn(model.containerInstanceArn);
            setTaskArn(model.taskArn);
            setExitCode(model.exitCode);
            setReason(model.reason);
        }

        public final String getContainerInstanceArn() {
            return containerInstanceArn;
        }

        @Override
        public final Builder containerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
            return this;
        }

        public final void setContainerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
        }

        public final String getTaskArn() {
            return taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final Integer getExitCode() {
            return exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public AttemptContainerDetail build() {
            return new AttemptContainerDetail(this);
        }
    }
}
