/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.AttemptDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a job attempt.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AttemptDetail implements StructuredPojo, ToCopyableBuilder<AttemptDetail.Builder, AttemptDetail> {
    private final AttemptContainerDetail container;

    private final Long startedAt;

    private final Long stoppedAt;

    private final String statusReason;

    private AttemptDetail(BuilderImpl builder) {
        this.container = builder.container;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * Details about the container in this job attempt.
     * </p>
     * 
     * @return Details about the container in this job attempt.
     */
    public AttemptContainerDetail container() {
        return container;
    }

    /**
     * <p>
     * The Unix timestamp for when the attempt was started (when the task transitioned from the <code>PENDING</code>
     * state to the <code>RUNNING</code> state).
     * </p>
     * 
     * @return The Unix timestamp for when the attempt was started (when the task transitioned from the
     *         <code>PENDING</code> state to the <code>RUNNING</code> state).
     */
    public Long startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The Unix timestamp for when the attempt was stopped (when the task transitioned from the <code>RUNNING</code>
     * state to the <code>STOPPED</code> state).
     * </p>
     * 
     * @return The Unix timestamp for when the attempt was stopped (when the task transitioned from the
     *         <code>RUNNING</code> state to the <code>STOPPED</code> state).
     */
    public Long stoppedAt() {
        return stoppedAt;
    }

    /**
     * <p>
     * A short, human-readable string to provide additional details about the current status of the job attempt.
     * </p>
     * 
     * @return A short, human-readable string to provide additional details about the current status of the job attempt.
     */
    public String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((container() == null) ? 0 : container().hashCode());
        hashCode = 31 * hashCode + ((startedAt() == null) ? 0 : startedAt().hashCode());
        hashCode = 31 * hashCode + ((stoppedAt() == null) ? 0 : stoppedAt().hashCode());
        hashCode = 31 * hashCode + ((statusReason() == null) ? 0 : statusReason().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttemptDetail)) {
            return false;
        }
        AttemptDetail other = (AttemptDetail) obj;
        if (other.container() == null ^ this.container() == null) {
            return false;
        }
        if (other.container() != null && !other.container().equals(this.container())) {
            return false;
        }
        if (other.startedAt() == null ^ this.startedAt() == null) {
            return false;
        }
        if (other.startedAt() != null && !other.startedAt().equals(this.startedAt())) {
            return false;
        }
        if (other.stoppedAt() == null ^ this.stoppedAt() == null) {
            return false;
        }
        if (other.stoppedAt() != null && !other.stoppedAt().equals(this.stoppedAt())) {
            return false;
        }
        if (other.statusReason() == null ^ this.statusReason() == null) {
            return false;
        }
        if (other.statusReason() != null && !other.statusReason().equals(this.statusReason())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (container() != null) {
            sb.append("Container: ").append(container()).append(",");
        }
        if (startedAt() != null) {
            sb.append("StartedAt: ").append(startedAt()).append(",");
        }
        if (stoppedAt() != null) {
            sb.append("StoppedAt: ").append(stoppedAt()).append(",");
        }
        if (statusReason() != null) {
            sb.append("StatusReason: ").append(statusReason()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttemptDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AttemptDetail> {
        /**
         * <p>
         * Details about the container in this job attempt.
         * </p>
         * 
         * @param container
         *        Details about the container in this job attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(AttemptContainerDetail container);

        /**
         * <p>
         * The Unix timestamp for when the attempt was started (when the task transitioned from the <code>PENDING</code>
         * state to the <code>RUNNING</code> state).
         * </p>
         * 
         * @param startedAt
         *        The Unix timestamp for when the attempt was started (when the task transitioned from the
         *        <code>PENDING</code> state to the <code>RUNNING</code> state).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Long startedAt);

        /**
         * <p>
         * The Unix timestamp for when the attempt was stopped (when the task transitioned from the <code>RUNNING</code>
         * state to the <code>STOPPED</code> state).
         * </p>
         * 
         * @param stoppedAt
         *        The Unix timestamp for when the attempt was stopped (when the task transitioned from the
         *        <code>RUNNING</code> state to the <code>STOPPED</code> state).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedAt(Long stoppedAt);

        /**
         * <p>
         * A short, human-readable string to provide additional details about the current status of the job attempt.
         * </p>
         * 
         * @param statusReason
         *        A short, human-readable string to provide additional details about the current status of the job
         *        attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    private static final class BuilderImpl implements Builder {
        private AttemptContainerDetail container;

        private Long startedAt;

        private Long stoppedAt;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AttemptDetail model) {
            setContainer(model.container);
            setStartedAt(model.startedAt);
            setStoppedAt(model.stoppedAt);
            setStatusReason(model.statusReason);
        }

        public final AttemptContainerDetail getContainer() {
            return container;
        }

        @Override
        public final Builder container(AttemptContainerDetail container) {
            this.container = container;
            return this;
        }

        public final void setContainer(AttemptContainerDetail container) {
            this.container = container;
        }

        public final Long getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        public final Long getStoppedAt() {
            return stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public AttemptDetail build() {
            return new AttemptDetail(this);
        }
    }
}
