/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.ContainerDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the details of a container that is part of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ContainerDetail implements StructuredPojo, ToCopyableBuilder<ContainerDetail.Builder, ContainerDetail> {
    private final String image;

    private final Integer vcpus;

    private final Integer memory;

    private final List<String> command;

    private final String jobRoleArn;

    private final List<Volume> volumes;

    private final List<KeyValuePair> environment;

    private final List<MountPoint> mountPoints;

    private final Boolean readonlyRootFilesystem;

    private final List<Ulimit> ulimits;

    private final Boolean privileged;

    private final String user;

    private final Integer exitCode;

    private final String reason;

    private final String containerInstanceArn;

    private final String taskArn;

    private ContainerDetail(BuilderImpl builder) {
        this.image = builder.image;
        this.vcpus = builder.vcpus;
        this.memory = builder.memory;
        this.command = builder.command;
        this.jobRoleArn = builder.jobRoleArn;
        this.volumes = builder.volumes;
        this.environment = builder.environment;
        this.mountPoints = builder.mountPoints;
        this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
        this.ulimits = builder.ulimits;
        this.privileged = builder.privileged;
        this.user = builder.user;
        this.exitCode = builder.exitCode;
        this.reason = builder.reason;
        this.containerInstanceArn = builder.containerInstanceArn;
        this.taskArn = builder.taskArn;
    }

    /**
     * <p>
     * The image used to start the container.
     * </p>
     * 
     * @return The image used to start the container.
     */
    public String image() {
        return image;
    }

    /**
     * <p>
     * The number of VCPUs allocated for the job.
     * </p>
     * 
     * @return The number of VCPUs allocated for the job.
     */
    public Integer vcpus() {
        return vcpus;
    }

    /**
     * <p>
     * The number of MiB of memory reserved for the job.
     * </p>
     * 
     * @return The number of MiB of memory reserved for the job.
     */
    public Integer memory() {
        return memory;
    }

    /**
     * <p>
     * The command that is passed to the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The command that is passed to the container.
     */
    public List<String> command() {
        return command;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the job upon execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with the job upon execution.
     */
    public String jobRoleArn() {
        return jobRoleArn;
    }

    /**
     * <p>
     * A list of volumes associated with the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of volumes associated with the job.
     */
    public List<Volume> volumes() {
        return volumes;
    }

    /**
     * <p>
     * The environment variables to pass to a container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The environment variables to pass to a container.
     */
    public List<KeyValuePair> environment() {
        return environment;
    }

    /**
     * <p>
     * The mount points for data volumes in your container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The mount points for data volumes in your container.
     */
    public List<MountPoint> mountPoints() {
        return mountPoints;
    }

    /**
     * <p>
     * When this parameter is true, the container is given read-only access to its root file system.
     * </p>
     * 
     * @return When this parameter is true, the container is given read-only access to its root file system.
     */
    public Boolean readonlyRootFilesystem() {
        return readonlyRootFilesystem;
    }

    /**
     * <p>
     * A list of <code>ulimit</code> values to set in the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>ulimit</code> values to set in the container.
     */
    public List<Ulimit> ulimits() {
        return ulimits;
    }

    /**
     * <p>
     * When this parameter is true, the container is given elevated privileges on the host container instance (similar
     * to the <code>root</code> user).
     * </p>
     * 
     * @return When this parameter is true, the container is given elevated privileges on the host container instance
     *         (similar to the <code>root</code> user).
     */
    public Boolean privileged() {
        return privileged;
    }

    /**
     * <p>
     * The user name to use inside the container.
     * </p>
     * 
     * @return The user name to use inside the container.
     */
    public String user() {
        return user;
    }

    /**
     * <p>
     * The exit code to return upon completion.
     * </p>
     * 
     * @return The exit code to return upon completion.
     */
    public Integer exitCode() {
        return exitCode;
    }

    /**
     * <p>
     * A short (255 max characters) human-readable string to provide additional details about a running or stopped
     * container.
     * </p>
     * 
     * @return A short (255 max characters) human-readable string to provide additional details about a running or
     *         stopped container.
     */
    public String reason() {
        return reason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the container instance on which the container is running.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the container instance on which the container is running.
     */
    public String containerInstanceArn() {
        return containerInstanceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon ECS task that is associated with the container job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon ECS task that is associated with the container job.
     */
    public String taskArn() {
        return taskArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((image() == null) ? 0 : image().hashCode());
        hashCode = 31 * hashCode + ((vcpus() == null) ? 0 : vcpus().hashCode());
        hashCode = 31 * hashCode + ((memory() == null) ? 0 : memory().hashCode());
        hashCode = 31 * hashCode + ((command() == null) ? 0 : command().hashCode());
        hashCode = 31 * hashCode + ((jobRoleArn() == null) ? 0 : jobRoleArn().hashCode());
        hashCode = 31 * hashCode + ((volumes() == null) ? 0 : volumes().hashCode());
        hashCode = 31 * hashCode + ((environment() == null) ? 0 : environment().hashCode());
        hashCode = 31 * hashCode + ((mountPoints() == null) ? 0 : mountPoints().hashCode());
        hashCode = 31 * hashCode + ((readonlyRootFilesystem() == null) ? 0 : readonlyRootFilesystem().hashCode());
        hashCode = 31 * hashCode + ((ulimits() == null) ? 0 : ulimits().hashCode());
        hashCode = 31 * hashCode + ((privileged() == null) ? 0 : privileged().hashCode());
        hashCode = 31 * hashCode + ((user() == null) ? 0 : user().hashCode());
        hashCode = 31 * hashCode + ((exitCode() == null) ? 0 : exitCode().hashCode());
        hashCode = 31 * hashCode + ((reason() == null) ? 0 : reason().hashCode());
        hashCode = 31 * hashCode + ((containerInstanceArn() == null) ? 0 : containerInstanceArn().hashCode());
        hashCode = 31 * hashCode + ((taskArn() == null) ? 0 : taskArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDetail)) {
            return false;
        }
        ContainerDetail other = (ContainerDetail) obj;
        if (other.image() == null ^ this.image() == null) {
            return false;
        }
        if (other.image() != null && !other.image().equals(this.image())) {
            return false;
        }
        if (other.vcpus() == null ^ this.vcpus() == null) {
            return false;
        }
        if (other.vcpus() != null && !other.vcpus().equals(this.vcpus())) {
            return false;
        }
        if (other.memory() == null ^ this.memory() == null) {
            return false;
        }
        if (other.memory() != null && !other.memory().equals(this.memory())) {
            return false;
        }
        if (other.command() == null ^ this.command() == null) {
            return false;
        }
        if (other.command() != null && !other.command().equals(this.command())) {
            return false;
        }
        if (other.jobRoleArn() == null ^ this.jobRoleArn() == null) {
            return false;
        }
        if (other.jobRoleArn() != null && !other.jobRoleArn().equals(this.jobRoleArn())) {
            return false;
        }
        if (other.volumes() == null ^ this.volumes() == null) {
            return false;
        }
        if (other.volumes() != null && !other.volumes().equals(this.volumes())) {
            return false;
        }
        if (other.environment() == null ^ this.environment() == null) {
            return false;
        }
        if (other.environment() != null && !other.environment().equals(this.environment())) {
            return false;
        }
        if (other.mountPoints() == null ^ this.mountPoints() == null) {
            return false;
        }
        if (other.mountPoints() != null && !other.mountPoints().equals(this.mountPoints())) {
            return false;
        }
        if (other.readonlyRootFilesystem() == null ^ this.readonlyRootFilesystem() == null) {
            return false;
        }
        if (other.readonlyRootFilesystem() != null && !other.readonlyRootFilesystem().equals(this.readonlyRootFilesystem())) {
            return false;
        }
        if (other.ulimits() == null ^ this.ulimits() == null) {
            return false;
        }
        if (other.ulimits() != null && !other.ulimits().equals(this.ulimits())) {
            return false;
        }
        if (other.privileged() == null ^ this.privileged() == null) {
            return false;
        }
        if (other.privileged() != null && !other.privileged().equals(this.privileged())) {
            return false;
        }
        if (other.user() == null ^ this.user() == null) {
            return false;
        }
        if (other.user() != null && !other.user().equals(this.user())) {
            return false;
        }
        if (other.exitCode() == null ^ this.exitCode() == null) {
            return false;
        }
        if (other.exitCode() != null && !other.exitCode().equals(this.exitCode())) {
            return false;
        }
        if (other.reason() == null ^ this.reason() == null) {
            return false;
        }
        if (other.reason() != null && !other.reason().equals(this.reason())) {
            return false;
        }
        if (other.containerInstanceArn() == null ^ this.containerInstanceArn() == null) {
            return false;
        }
        if (other.containerInstanceArn() != null && !other.containerInstanceArn().equals(this.containerInstanceArn())) {
            return false;
        }
        if (other.taskArn() == null ^ this.taskArn() == null) {
            return false;
        }
        if (other.taskArn() != null && !other.taskArn().equals(this.taskArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (image() != null) {
            sb.append("Image: ").append(image()).append(",");
        }
        if (vcpus() != null) {
            sb.append("Vcpus: ").append(vcpus()).append(",");
        }
        if (memory() != null) {
            sb.append("Memory: ").append(memory()).append(",");
        }
        if (command() != null) {
            sb.append("Command: ").append(command()).append(",");
        }
        if (jobRoleArn() != null) {
            sb.append("JobRoleArn: ").append(jobRoleArn()).append(",");
        }
        if (volumes() != null) {
            sb.append("Volumes: ").append(volumes()).append(",");
        }
        if (environment() != null) {
            sb.append("Environment: ").append(environment()).append(",");
        }
        if (mountPoints() != null) {
            sb.append("MountPoints: ").append(mountPoints()).append(",");
        }
        if (readonlyRootFilesystem() != null) {
            sb.append("ReadonlyRootFilesystem: ").append(readonlyRootFilesystem()).append(",");
        }
        if (ulimits() != null) {
            sb.append("Ulimits: ").append(ulimits()).append(",");
        }
        if (privileged() != null) {
            sb.append("Privileged: ").append(privileged()).append(",");
        }
        if (user() != null) {
            sb.append("User: ").append(user()).append(",");
        }
        if (exitCode() != null) {
            sb.append("ExitCode: ").append(exitCode()).append(",");
        }
        if (reason() != null) {
            sb.append("Reason: ").append(reason()).append(",");
        }
        if (containerInstanceArn() != null) {
            sb.append("ContainerInstanceArn: ").append(containerInstanceArn()).append(",");
        }
        if (taskArn() != null) {
            sb.append("TaskArn: ").append(taskArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ContainerDetail> {
        /**
         * <p>
         * The image used to start the container.
         * </p>
         * 
         * @param image
         *        The image used to start the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * The number of VCPUs allocated for the job.
         * </p>
         * 
         * @param vcpus
         *        The number of VCPUs allocated for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vcpus(Integer vcpus);

        /**
         * <p>
         * The number of MiB of memory reserved for the job.
         * </p>
         * 
         * @param memory
         *        The number of MiB of memory reserved for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(Integer memory);

        /**
         * <p>
         * The command that is passed to the container.
         * </p>
         * 
         * @param command
         *        The command that is passed to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(Collection<String> command);

        /**
         * <p>
         * The command that is passed to the container.
         * </p>
         * 
         * @param command
         *        The command that is passed to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String... command);

        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with the job upon execution.
         * </p>
         * 
         * @param jobRoleArn
         *        The Amazon Resource Name (ARN) associated with the job upon execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRoleArn(String jobRoleArn);

        /**
         * <p>
         * A list of volumes associated with the job.
         * </p>
         * 
         * @param volumes
         *        A list of volumes associated with the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Collection<Volume> volumes);

        /**
         * <p>
         * A list of volumes associated with the job.
         * </p>
         * 
         * @param volumes
         *        A list of volumes associated with the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Volume... volumes);

        /**
         * <p>
         * The environment variables to pass to a container.
         * </p>
         * 
         * @param environment
         *        The environment variables to pass to a container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Collection<KeyValuePair> environment);

        /**
         * <p>
         * The environment variables to pass to a container.
         * </p>
         * 
         * @param environment
         *        The environment variables to pass to a container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(KeyValuePair... environment);

        /**
         * <p>
         * The mount points for data volumes in your container.
         * </p>
         * 
         * @param mountPoints
         *        The mount points for data volumes in your container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoints(Collection<MountPoint> mountPoints);

        /**
         * <p>
         * The mount points for data volumes in your container.
         * </p>
         * 
         * @param mountPoints
         *        The mount points for data volumes in your container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoints(MountPoint... mountPoints);

        /**
         * <p>
         * When this parameter is true, the container is given read-only access to its root file system.
         * </p>
         * 
         * @param readonlyRootFilesystem
         *        When this parameter is true, the container is given read-only access to its root file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem);

        /**
         * <p>
         * A list of <code>ulimit</code> values to set in the container.
         * </p>
         * 
         * @param ulimits
         *        A list of <code>ulimit</code> values to set in the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ulimits(Collection<Ulimit> ulimits);

        /**
         * <p>
         * A list of <code>ulimit</code> values to set in the container.
         * </p>
         * 
         * @param ulimits
         *        A list of <code>ulimit</code> values to set in the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ulimits(Ulimit... ulimits);

        /**
         * <p>
         * When this parameter is true, the container is given elevated privileges on the host container instance
         * (similar to the <code>root</code> user).
         * </p>
         * 
         * @param privileged
         *        When this parameter is true, the container is given elevated privileges on the host container instance
         *        (similar to the <code>root</code> user).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privileged(Boolean privileged);

        /**
         * <p>
         * The user name to use inside the container.
         * </p>
         * 
         * @param user
         *        The user name to use inside the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(String user);

        /**
         * <p>
         * The exit code to return upon completion.
         * </p>
         * 
         * @param exitCode
         *        The exit code to return upon completion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exitCode(Integer exitCode);

        /**
         * <p>
         * A short (255 max characters) human-readable string to provide additional details about a running or stopped
         * container.
         * </p>
         * 
         * @param reason
         *        A short (255 max characters) human-readable string to provide additional details about a running or
         *        stopped container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the container instance on which the container is running.
         * </p>
         * 
         * @param containerInstanceArn
         *        The Amazon Resource Name (ARN) of the container instance on which the container is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstanceArn(String containerInstanceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon ECS task that is associated with the container job.
         * </p>
         * 
         * @param taskArn
         *        The Amazon Resource Name (ARN) of the Amazon ECS task that is associated with the container job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);
    }

    private static final class BuilderImpl implements Builder {
        private String image;

        private Integer vcpus;

        private Integer memory;

        private List<String> command;

        private String jobRoleArn;

        private List<Volume> volumes;

        private List<KeyValuePair> environment;

        private List<MountPoint> mountPoints;

        private Boolean readonlyRootFilesystem;

        private List<Ulimit> ulimits;

        private Boolean privileged;

        private String user;

        private Integer exitCode;

        private String reason;

        private String containerInstanceArn;

        private String taskArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDetail model) {
            setImage(model.image);
            setVcpus(model.vcpus);
            setMemory(model.memory);
            setCommand(model.command);
            setJobRoleArn(model.jobRoleArn);
            setVolumes(model.volumes);
            setEnvironment(model.environment);
            setMountPoints(model.mountPoints);
            setReadonlyRootFilesystem(model.readonlyRootFilesystem);
            setUlimits(model.ulimits);
            setPrivileged(model.privileged);
            setUser(model.user);
            setExitCode(model.exitCode);
            setReason(model.reason);
            setContainerInstanceArn(model.containerInstanceArn);
            setTaskArn(model.taskArn);
        }

        public final String getImage() {
            return image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final Integer getVcpus() {
            return vcpus;
        }

        @Override
        public final Builder vcpus(Integer vcpus) {
            this.vcpus = vcpus;
            return this;
        }

        public final void setVcpus(Integer vcpus) {
            this.vcpus = vcpus;
        }

        public final Integer getMemory() {
            return memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        public final Collection<String> getCommand() {
            return command;
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String... command) {
            command(Arrays.asList(command));
            return this;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        @SafeVarargs
        public final void setCommand(String... command) {
            command(Arrays.asList(command));
        }

        public final String getJobRoleArn() {
            return jobRoleArn;
        }

        @Override
        public final Builder jobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
            return this;
        }

        public final void setJobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
        }

        public final Collection<Volume> getVolumes() {
            return volumes;
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume... volumes) {
            volumes(Arrays.asList(volumes));
            return this;
        }

        public final void setVolumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
        }

        @SafeVarargs
        public final void setVolumes(Volume... volumes) {
            volumes(Arrays.asList(volumes));
        }

        public final Collection<KeyValuePair> getEnvironment() {
            return environment;
        }

        @Override
        public final Builder environment(Collection<KeyValuePair> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(KeyValuePair... environment) {
            environment(Arrays.asList(environment));
            return this;
        }

        public final void setEnvironment(Collection<KeyValuePair> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
        }

        @SafeVarargs
        public final void setEnvironment(KeyValuePair... environment) {
            environment(Arrays.asList(environment));
        }

        public final Collection<MountPoint> getMountPoints() {
            return mountPoints;
        }

        @Override
        public final Builder mountPoints(Collection<MountPoint> mountPoints) {
            this.mountPoints = MountPointsCopier.copy(mountPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(MountPoint... mountPoints) {
            mountPoints(Arrays.asList(mountPoints));
            return this;
        }

        public final void setMountPoints(Collection<MountPoint> mountPoints) {
            this.mountPoints = MountPointsCopier.copy(mountPoints);
        }

        @SafeVarargs
        public final void setMountPoints(MountPoint... mountPoints) {
            mountPoints(Arrays.asList(mountPoints));
        }

        public final Boolean getReadonlyRootFilesystem() {
            return readonlyRootFilesystem;
        }

        @Override
        public final Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        public final void setReadonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
        }

        public final Collection<Ulimit> getUlimits() {
            return ulimits;
        }

        @Override
        public final Builder ulimits(Collection<Ulimit> ulimits) {
            this.ulimits = UlimitsCopier.copy(ulimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ulimits(Ulimit... ulimits) {
            ulimits(Arrays.asList(ulimits));
            return this;
        }

        public final void setUlimits(Collection<Ulimit> ulimits) {
            this.ulimits = UlimitsCopier.copy(ulimits);
        }

        @SafeVarargs
        public final void setUlimits(Ulimit... ulimits) {
            ulimits(Arrays.asList(ulimits));
        }

        public final Boolean getPrivileged() {
            return privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        public final String getUser() {
            return user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        public final Integer getExitCode() {
            return exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getContainerInstanceArn() {
            return containerInstanceArn;
        }

        @Override
        public final Builder containerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
            return this;
        }

        public final void setContainerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
        }

        public final String getTaskArn() {
            return taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public ContainerDetail build() {
            return new ContainerDetail(this);
        }
    }
}
