/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SubmitJobRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SubmitJobRequest.Builder, SubmitJobRequest> {
    private final String jobName;

    private final String jobQueue;

    private final List<JobDependency> dependsOn;

    private final String jobDefinition;

    private final Map<String, String> parameters;

    private final ContainerOverrides containerOverrides;

    private final RetryStrategy retryStrategy;

    private SubmitJobRequest(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobQueue = builder.jobQueue;
        this.dependsOn = builder.dependsOn;
        this.jobDefinition = builder.jobDefinition;
        this.parameters = builder.parameters;
        this.containerOverrides = builder.containerOverrides;
        this.retryStrategy = builder.retryStrategy;
    }

    /**
     * <p>
     * The name of the job. A name must be 1 to 128 characters in length.
     * </p>
     * <p>
     * Pattern: ^[a-zA-Z0-9_]+$
     * </p>
     * 
     * @return The name of the job. A name must be 1 to 128 characters in length.</p>
     *         <p>
     *         Pattern: ^[a-zA-Z0-9_]+$
     */
    public String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The job queue into which the job will be submitted. You can specify either the name or the Amazon Resource Name
     * (ARN) of the queue.
     * </p>
     * 
     * @return The job queue into which the job will be submitted. You can specify either the name or the Amazon
     *         Resource Name (ARN) of the queue.
     */
    public String jobQueue() {
        return jobQueue;
    }

    /**
     * <p>
     * A list of job IDs on which this job depends. A job can depend upon a maximum of 100 jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of job IDs on which this job depends. A job can depend upon a maximum of 100 jobs.
     */
    public List<JobDependency> dependsOn() {
        return dependsOn;
    }

    /**
     * <p>
     * The job definition used by this job. This value can be either a <code>name:revision</code> or the Amazon Resource
     * Name (ARN) for the job definition.
     * </p>
     * 
     * @return The job definition used by this job. This value can be either a <code>name:revision</code> or the Amazon
     *         Resource Name (ARN) for the job definition.
     */
    public String jobDefinition() {
        return jobDefinition;
    }

    /**
     * <p>
     * Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job
     * definition. Parameters are specified as a key and value pair mapping. Parameters in a <code>SubmitJob</code>
     * request override any corresponding parameter defaults from the job definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Additional parameters passed to the job that replace parameter substitution placeholders that are set in
     *         the job definition. Parameters are specified as a key and value pair mapping. Parameters in a
     *         <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * A list of container overrides in JSON format that specify the name of a container in the specified job definition
     * and the overrides it should receive. You can override the default command for a container (that is specified in
     * the job definition or the Docker image) with a <code>command</code> override. You can also override existing
     * environment variables (that are specified in the job definition or Docker image) on a container or add new
     * environment variables to it with an <code>environment</code> override.
     * </p>
     * 
     * @return A list of container overrides in JSON format that specify the name of a container in the specified job
     *         definition and the overrides it should receive. You can override the default command for a container
     *         (that is specified in the job definition or the Docker image) with a <code>command</code> override. You
     *         can also override existing environment variables (that are specified in the job definition or Docker
     *         image) on a container or add new environment variables to it with an <code>environment</code> override.
     */
    public ContainerOverrides containerOverrides() {
        return containerOverrides;
    }

    /**
     * <p>
     * The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is
     * specified here, it overrides the retry strategy defined in the job definition.
     * </p>
     * 
     * @return The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is
     *         specified here, it overrides the retry strategy defined in the job definition.
     */
    public RetryStrategy retryStrategy() {
        return retryStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobName() == null) ? 0 : jobName().hashCode());
        hashCode = 31 * hashCode + ((jobQueue() == null) ? 0 : jobQueue().hashCode());
        hashCode = 31 * hashCode + ((dependsOn() == null) ? 0 : dependsOn().hashCode());
        hashCode = 31 * hashCode + ((jobDefinition() == null) ? 0 : jobDefinition().hashCode());
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((containerOverrides() == null) ? 0 : containerOverrides().hashCode());
        hashCode = 31 * hashCode + ((retryStrategy() == null) ? 0 : retryStrategy().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitJobRequest)) {
            return false;
        }
        SubmitJobRequest other = (SubmitJobRequest) obj;
        if (other.jobName() == null ^ this.jobName() == null) {
            return false;
        }
        if (other.jobName() != null && !other.jobName().equals(this.jobName())) {
            return false;
        }
        if (other.jobQueue() == null ^ this.jobQueue() == null) {
            return false;
        }
        if (other.jobQueue() != null && !other.jobQueue().equals(this.jobQueue())) {
            return false;
        }
        if (other.dependsOn() == null ^ this.dependsOn() == null) {
            return false;
        }
        if (other.dependsOn() != null && !other.dependsOn().equals(this.dependsOn())) {
            return false;
        }
        if (other.jobDefinition() == null ^ this.jobDefinition() == null) {
            return false;
        }
        if (other.jobDefinition() != null && !other.jobDefinition().equals(this.jobDefinition())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.containerOverrides() == null ^ this.containerOverrides() == null) {
            return false;
        }
        if (other.containerOverrides() != null && !other.containerOverrides().equals(this.containerOverrides())) {
            return false;
        }
        if (other.retryStrategy() == null ^ this.retryStrategy() == null) {
            return false;
        }
        if (other.retryStrategy() != null && !other.retryStrategy().equals(this.retryStrategy())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jobName() != null) {
            sb.append("JobName: ").append(jobName()).append(",");
        }
        if (jobQueue() != null) {
            sb.append("JobQueue: ").append(jobQueue()).append(",");
        }
        if (dependsOn() != null) {
            sb.append("DependsOn: ").append(dependsOn()).append(",");
        }
        if (jobDefinition() != null) {
            sb.append("JobDefinition: ").append(jobDefinition()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (containerOverrides() != null) {
            sb.append("ContainerOverrides: ").append(containerOverrides()).append(",");
        }
        if (retryStrategy() != null) {
            sb.append("RetryStrategy: ").append(retryStrategy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SubmitJobRequest> {
        /**
         * <p>
         * The name of the job. A name must be 1 to 128 characters in length.
         * </p>
         * <p>
         * Pattern: ^[a-zA-Z0-9_]+$
         * </p>
         * 
         * @param jobName
         *        The name of the job. A name must be 1 to 128 characters in length.</p>
         *        <p>
         *        Pattern: ^[a-zA-Z0-9_]+$
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The job queue into which the job will be submitted. You can specify either the name or the Amazon Resource
         * Name (ARN) of the queue.
         * </p>
         * 
         * @param jobQueue
         *        The job queue into which the job will be submitted. You can specify either the name or the Amazon
         *        Resource Name (ARN) of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        /**
         * <p>
         * A list of job IDs on which this job depends. A job can depend upon a maximum of 100 jobs.
         * </p>
         * 
         * @param dependsOn
         *        A list of job IDs on which this job depends. A job can depend upon a maximum of 100 jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(Collection<JobDependency> dependsOn);

        /**
         * <p>
         * A list of job IDs on which this job depends. A job can depend upon a maximum of 100 jobs.
         * </p>
         * 
         * @param dependsOn
         *        A list of job IDs on which this job depends. A job can depend upon a maximum of 100 jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(JobDependency... dependsOn);

        /**
         * <p>
         * The job definition used by this job. This value can be either a <code>name:revision</code> or the Amazon
         * Resource Name (ARN) for the job definition.
         * </p>
         * 
         * @param jobDefinition
         *        The job definition used by this job. This value can be either a <code>name:revision</code> or the
         *        Amazon Resource Name (ARN) for the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinition(String jobDefinition);

        /**
         * <p>
         * Additional parameters passed to the job that replace parameter substitution placeholders that are set in the
         * job definition. Parameters are specified as a key and value pair mapping. Parameters in a
         * <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.
         * </p>
         * 
         * @param parameters
         *        Additional parameters passed to the job that replace parameter substitution placeholders that are set
         *        in the job definition. Parameters are specified as a key and value pair mapping. Parameters in a
         *        <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * A list of container overrides in JSON format that specify the name of a container in the specified job
         * definition and the overrides it should receive. You can override the default command for a container (that is
         * specified in the job definition or the Docker image) with a <code>command</code> override. You can also
         * override existing environment variables (that are specified in the job definition or Docker image) on a
         * container or add new environment variables to it with an <code>environment</code> override.
         * </p>
         * 
         * @param containerOverrides
         *        A list of container overrides in JSON format that specify the name of a container in the specified job
         *        definition and the overrides it should receive. You can override the default command for a container
         *        (that is specified in the job definition or the Docker image) with a <code>command</code> override.
         *        You can also override existing environment variables (that are specified in the job definition or
         *        Docker image) on a container or add new environment variables to it with an <code>environment</code>
         *        override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerOverrides(ContainerOverrides containerOverrides);

        /**
         * <p>
         * The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is
         * specified here, it overrides the retry strategy defined in the job definition.
         * </p>
         * 
         * @param retryStrategy
         *        The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy
         *        is specified here, it overrides the retry strategy defined in the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryStrategy(RetryStrategy retryStrategy);
    }

    private static final class BuilderImpl implements Builder {
        private String jobName;

        private String jobQueue;

        private List<JobDependency> dependsOn;

        private String jobDefinition;

        private Map<String, String> parameters;

        private ContainerOverrides containerOverrides;

        private RetryStrategy retryStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitJobRequest model) {
            setJobName(model.jobName);
            setJobQueue(model.jobQueue);
            setDependsOn(model.dependsOn);
            setJobDefinition(model.jobDefinition);
            setParameters(model.parameters);
            setContainerOverrides(model.containerOverrides);
            setRetryStrategy(model.retryStrategy);
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final Collection<JobDependency> getDependsOn() {
            return dependsOn;
        }

        @Override
        public final Builder dependsOn(Collection<JobDependency> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(JobDependency... dependsOn) {
            dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        public final void setDependsOn(Collection<JobDependency> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copy(dependsOn);
        }

        @SafeVarargs
        public final void setDependsOn(JobDependency... dependsOn) {
            dependsOn(Arrays.asList(dependsOn));
        }

        public final String getJobDefinition() {
            return jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final ContainerOverrides getContainerOverrides() {
            return containerOverrides;
        }

        @Override
        public final Builder containerOverrides(ContainerOverrides containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public final void setContainerOverrides(ContainerOverrides containerOverrides) {
            this.containerOverrides = containerOverrides;
        }

        public final RetryStrategy getRetryStrategy() {
            return retryStrategy;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
        }

        @Override
        public SubmitJobRequest build() {
            return new SubmitJobRequest(this);
        }
    }
}
