/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateComputeEnvironmentResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<UpdateComputeEnvironmentResponse.Builder, UpdateComputeEnvironmentResponse> {
    private final String computeEnvironmentName;

    private final String computeEnvironmentArn;

    private UpdateComputeEnvironmentResponse(BuilderImpl builder) {
        this.computeEnvironmentName = builder.computeEnvironmentName;
        this.computeEnvironmentArn = builder.computeEnvironmentArn;
    }

    /**
     * <p>
     * The name of compute environment.
     * </p>
     * 
     * @return The name of compute environment.
     */
    public String computeEnvironmentName() {
        return computeEnvironmentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the compute environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the compute environment.
     */
    public String computeEnvironmentArn() {
        return computeEnvironmentArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((computeEnvironmentName() == null) ? 0 : computeEnvironmentName().hashCode());
        hashCode = 31 * hashCode + ((computeEnvironmentArn() == null) ? 0 : computeEnvironmentArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputeEnvironmentResponse)) {
            return false;
        }
        UpdateComputeEnvironmentResponse other = (UpdateComputeEnvironmentResponse) obj;
        if (other.computeEnvironmentName() == null ^ this.computeEnvironmentName() == null) {
            return false;
        }
        if (other.computeEnvironmentName() != null && !other.computeEnvironmentName().equals(this.computeEnvironmentName())) {
            return false;
        }
        if (other.computeEnvironmentArn() == null ^ this.computeEnvironmentArn() == null) {
            return false;
        }
        if (other.computeEnvironmentArn() != null && !other.computeEnvironmentArn().equals(this.computeEnvironmentArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (computeEnvironmentName() != null) {
            sb.append("ComputeEnvironmentName: ").append(computeEnvironmentName()).append(",");
        }
        if (computeEnvironmentArn() != null) {
            sb.append("ComputeEnvironmentArn: ").append(computeEnvironmentArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateComputeEnvironmentResponse> {
        /**
         * <p>
         * The name of compute environment.
         * </p>
         * 
         * @param computeEnvironmentName
         *        The name of compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentName(String computeEnvironmentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the compute environment.
         * </p>
         * 
         * @param computeEnvironmentArn
         *        The Amazon Resource Name (ARN) of the compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentArn(String computeEnvironmentArn);
    }

    private static final class BuilderImpl implements Builder {
        private String computeEnvironmentName;

        private String computeEnvironmentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputeEnvironmentResponse model) {
            setComputeEnvironmentName(model.computeEnvironmentName);
            setComputeEnvironmentArn(model.computeEnvironmentArn);
        }

        public final String getComputeEnvironmentName() {
            return computeEnvironmentName;
        }

        @Override
        public final Builder computeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        public final void setComputeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
        }

        public final String getComputeEnvironmentArn() {
            return computeEnvironmentArn;
        }

        @Override
        public final Builder computeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
            return this;
        }

        public final void setComputeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
        }

        @Override
        public UpdateComputeEnvironmentResponse build() {
            return new UpdateComputeEnvironmentResponse(this);
        }
    }
}
