/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateJobQueueRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateJobQueueRequest.Builder, UpdateJobQueueRequest> {
    private final String jobQueue;

    private final String state;

    private final Integer priority;

    private final List<ComputeEnvironmentOrder> computeEnvironmentOrder;

    private UpdateJobQueueRequest(BuilderImpl builder) {
        this.jobQueue = builder.jobQueue;
        this.state = builder.state;
        this.priority = builder.priority;
        this.computeEnvironmentOrder = builder.computeEnvironmentOrder;
    }

    /**
     * <p>
     * The name or the Amazon Resource Name (ARN) of the job queue.
     * </p>
     * 
     * @return The name or the Amazon Resource Name (ARN) of the job queue.
     */
    public String jobQueue() {
        return jobQueue;
    }

    /**
     * <p>
     * Describes the queue's ability to accept new jobs.
     * </p>
     * 
     * @return Describes the queue's ability to accept new jobs.
     * @see JQState
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The priority of the job queue. Job queues with a higher priority (or a lower integer value for the
     * <code>priority</code> parameter) are evaluated first when associated with same compute environment. Priority is
     * determined in ascending order, for example, a job queue with a priority value of <code>1</code> is given
     * scheduling preference over a job queue with a priority value of <code>10</code>.
     * </p>
     * 
     * @return The priority of the job queue. Job queues with a higher priority (or a lower integer value for the
     *         <code>priority</code> parameter) are evaluated first when associated with same compute environment.
     *         Priority is determined in ascending order, for example, a job queue with a priority value of
     *         <code>1</code> is given scheduling preference over a job queue with a priority value of <code>10</code>.
     */
    public Integer priority() {
        return priority;
    }

    /**
     * <p>
     * Details the set of compute environments mapped to a job queue and their order relative to each other. This is one
     * of the parameters used by the job scheduler to determine which compute environment should execute a given job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Details the set of compute environments mapped to a job queue and their order relative to each other.
     *         This is one of the parameters used by the job scheduler to determine which compute environment should
     *         execute a given job.
     */
    public List<ComputeEnvironmentOrder> computeEnvironmentOrder() {
        return computeEnvironmentOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobQueue() == null) ? 0 : jobQueue().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((priority() == null) ? 0 : priority().hashCode());
        hashCode = 31 * hashCode + ((computeEnvironmentOrder() == null) ? 0 : computeEnvironmentOrder().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobQueueRequest)) {
            return false;
        }
        UpdateJobQueueRequest other = (UpdateJobQueueRequest) obj;
        if (other.jobQueue() == null ^ this.jobQueue() == null) {
            return false;
        }
        if (other.jobQueue() != null && !other.jobQueue().equals(this.jobQueue())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.priority() == null ^ this.priority() == null) {
            return false;
        }
        if (other.priority() != null && !other.priority().equals(this.priority())) {
            return false;
        }
        if (other.computeEnvironmentOrder() == null ^ this.computeEnvironmentOrder() == null) {
            return false;
        }
        if (other.computeEnvironmentOrder() != null && !other.computeEnvironmentOrder().equals(this.computeEnvironmentOrder())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jobQueue() != null) {
            sb.append("JobQueue: ").append(jobQueue()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (priority() != null) {
            sb.append("Priority: ").append(priority()).append(",");
        }
        if (computeEnvironmentOrder() != null) {
            sb.append("ComputeEnvironmentOrder: ").append(computeEnvironmentOrder()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateJobQueueRequest> {
        /**
         * <p>
         * The name or the Amazon Resource Name (ARN) of the job queue.
         * </p>
         * 
         * @param jobQueue
         *        The name or the Amazon Resource Name (ARN) of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        /**
         * <p>
         * Describes the queue's ability to accept new jobs.
         * </p>
         * 
         * @param state
         *        Describes the queue's ability to accept new jobs.
         * @see JQState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQState
         */
        Builder state(String state);

        /**
         * <p>
         * Describes the queue's ability to accept new jobs.
         * </p>
         * 
         * @param state
         *        Describes the queue's ability to accept new jobs.
         * @see JQState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQState
         */
        Builder state(JQState state);

        /**
         * <p>
         * The priority of the job queue. Job queues with a higher priority (or a lower integer value for the
         * <code>priority</code> parameter) are evaluated first when associated with same compute environment. Priority
         * is determined in ascending order, for example, a job queue with a priority value of <code>1</code> is given
         * scheduling preference over a job queue with a priority value of <code>10</code>.
         * </p>
         * 
         * @param priority
         *        The priority of the job queue. Job queues with a higher priority (or a lower integer value for the
         *        <code>priority</code> parameter) are evaluated first when associated with same compute environment.
         *        Priority is determined in ascending order, for example, a job queue with a priority value of
         *        <code>1</code> is given scheduling preference over a job queue with a priority value of
         *        <code>10</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * Details the set of compute environments mapped to a job queue and their order relative to each other. This is
         * one of the parameters used by the job scheduler to determine which compute environment should execute a given
         * job.
         * </p>
         * 
         * @param computeEnvironmentOrder
         *        Details the set of compute environments mapped to a job queue and their order relative to each other.
         *        This is one of the parameters used by the job scheduler to determine which compute environment should
         *        execute a given job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder);

        /**
         * <p>
         * Details the set of compute environments mapped to a job queue and their order relative to each other. This is
         * one of the parameters used by the job scheduler to determine which compute environment should execute a given
         * job.
         * </p>
         * 
         * @param computeEnvironmentOrder
         *        Details the set of compute environments mapped to a job queue and their order relative to each other.
         *        This is one of the parameters used by the job scheduler to determine which compute environment should
         *        execute a given job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentOrder(ComputeEnvironmentOrder... computeEnvironmentOrder);
    }

    private static final class BuilderImpl implements Builder {
        private String jobQueue;

        private String state;

        private Integer priority;

        private List<ComputeEnvironmentOrder> computeEnvironmentOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobQueueRequest model) {
            setJobQueue(model.jobQueue);
            setState(model.state);
            setPriority(model.priority);
            setComputeEnvironmentOrder(model.computeEnvironmentOrder);
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JQState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(JQState state) {
            this.state(state.toString());
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<ComputeEnvironmentOrder> getComputeEnvironmentOrder() {
            return computeEnvironmentOrder;
        }

        @Override
        public final Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironmentOrder(ComputeEnvironmentOrder... computeEnvironmentOrder) {
            computeEnvironmentOrder(Arrays.asList(computeEnvironmentOrder));
            return this;
        }

        public final void setComputeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
        }

        @SafeVarargs
        public final void setComputeEnvironmentOrder(ComputeEnvironmentOrder... computeEnvironmentOrder) {
            computeEnvironmentOrder(Arrays.asList(computeEnvironmentOrder));
        }

        @Override
        public UpdateJobQueueRequest build() {
            return new UpdateJobQueueRequest(this);
        }
    }
}
