/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.batch.model.JobStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListJobsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListJobsRequest> {
    private final String jobQueue;
    private final String jobStatus;
    private final Integer maxResults;
    private final String nextToken;

    private ListJobsRequest(BuilderImpl builder) {
        this.jobQueue = builder.jobQueue;
        this.jobStatus = builder.jobStatus;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public String jobQueue() {
        return this.jobQueue;
    }

    public String jobStatus() {
        return this.jobStatus;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobQueue() == null ? 0 : this.jobQueue().hashCode());
        hashCode = 31 * hashCode + (this.jobStatus() == null ? 0 : this.jobStatus().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsRequest)) {
            return false;
        }
        ListJobsRequest other = (ListJobsRequest)((Object)obj);
        if (other.jobQueue() == null ^ this.jobQueue() == null) {
            return false;
        }
        if (other.jobQueue() != null && !other.jobQueue().equals(this.jobQueue())) {
            return false;
        }
        if (other.jobStatus() == null ^ this.jobStatus() == null) {
            return false;
        }
        if (other.jobStatus() != null && !other.jobStatus().equals(this.jobStatus())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobQueue() != null) {
            sb.append("JobQueue: ").append(this.jobQueue()).append(",");
        }
        if (this.jobStatus() != null) {
            sb.append("JobStatus: ").append(this.jobStatus()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String jobQueue;
        private String jobStatus;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsRequest model) {
            this.setJobQueue(model.jobQueue);
            this.setJobStatus(model.jobStatus);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
        }

        public final String getJobQueue() {
            return this.jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final void setJobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus.toString());
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListJobsRequest build() {
            return new ListJobsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListJobsRequest> {
        public Builder jobQueue(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

