/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.batch.model.KeyValuePair;

public class KeyValuePairUnmarshaller
implements Unmarshaller<KeyValuePair, JsonUnmarshallerContext> {
    private static KeyValuePairUnmarshaller INSTANCE;

    public KeyValuePair unmarshall(JsonUnmarshallerContext context) throws Exception {
        KeyValuePair.Builder keyValuePairBuilder = KeyValuePair.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    keyValuePairBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("value", targetDepth)) {
                    context.nextToken();
                    keyValuePairBuilder.value((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (KeyValuePair)keyValuePairBuilder.build();
    }

    public static KeyValuePairUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new KeyValuePairUnmarshaller();
        }
        return INSTANCE;
    }
}

