/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeJobDefinitionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeJobDefinitionsResponse.Builder, DescribeJobDefinitionsResponse> {
    private final List<JobDefinition> jobDefinitions;

    private final String nextToken;

    private DescribeJobDefinitionsResponse(BuilderImpl builder) {
        this.jobDefinitions = builder.jobDefinitions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of job definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of job definitions.
     */
    public List<JobDefinition> jobDefinitions() {
        return jobDefinitions;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeJobDefinitions</code> request. When the
     * results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value can be used
     * to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribeJobDefinitions</code> request. When
     *         the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value
     *         can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobDefinitions() == null) ? 0 : jobDefinitions().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobDefinitionsResponse)) {
            return false;
        }
        DescribeJobDefinitionsResponse other = (DescribeJobDefinitionsResponse) obj;
        if (other.jobDefinitions() == null ^ this.jobDefinitions() == null) {
            return false;
        }
        if (other.jobDefinitions() != null && !other.jobDefinitions().equals(this.jobDefinitions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jobDefinitions() != null) {
            sb.append("JobDefinitions: ").append(jobDefinitions()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeJobDefinitionsResponse> {
        /**
         * <p>
         * The list of job definitions.
         * </p>
         * 
         * @param jobDefinitions
         *        The list of job definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitions(Collection<JobDefinition> jobDefinitions);

        /**
         * <p>
         * The list of job definitions.
         * </p>
         * 
         * @param jobDefinitions
         *        The list of job definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitions(JobDefinition... jobDefinitions);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>DescribeJobDefinitions</code> request. When the
         * results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value can be
         * used to retrieve the next page of results. This value is <code>null</code> when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>DescribeJobDefinitions</code> request.
         *        When the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this
         *        value can be used to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<JobDefinition> jobDefinitions;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobDefinitionsResponse model) {
            setJobDefinitions(model.jobDefinitions);
            setNextToken(model.nextToken);
        }

        public final Collection<JobDefinition> getJobDefinitions() {
            return jobDefinitions;
        }

        @Override
        public final Builder jobDefinitions(Collection<JobDefinition> jobDefinitions) {
            this.jobDefinitions = JobDefinitionListCopier.copy(jobDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobDefinitions(JobDefinition... jobDefinitions) {
            jobDefinitions(Arrays.asList(jobDefinitions));
            return this;
        }

        public final void setJobDefinitions(Collection<JobDefinition> jobDefinitions) {
            this.jobDefinitions = JobDefinitionListCopier.copy(jobDefinitions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeJobDefinitionsResponse build() {
            return new DescribeJobDefinitionsResponse(this);
        }
    }
}
