/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeJobsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeJobsResponse.Builder, DescribeJobsResponse> {
    private final List<JobDetail> jobs;

    private DescribeJobsResponse(BuilderImpl builder) {
        this.jobs = builder.jobs;
    }

    /**
     * <p>
     * The list of jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of jobs.
     */
    public List<JobDetail> jobs() {
        return jobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobs() == null) ? 0 : jobs().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobsResponse)) {
            return false;
        }
        DescribeJobsResponse other = (DescribeJobsResponse) obj;
        if (other.jobs() == null ^ this.jobs() == null) {
            return false;
        }
        if (other.jobs() != null && !other.jobs().equals(this.jobs())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jobs() != null) {
            sb.append("Jobs: ").append(jobs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeJobsResponse> {
        /**
         * <p>
         * The list of jobs.
         * </p>
         * 
         * @param jobs
         *        The list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Collection<JobDetail> jobs);

        /**
         * <p>
         * The list of jobs.
         * </p>
         * 
         * @param jobs
         *        The list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(JobDetail... jobs);
    }

    private static final class BuilderImpl implements Builder {
        private List<JobDetail> jobs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobsResponse model) {
            setJobs(model.jobs);
        }

        public final Collection<JobDetail> getJobs() {
            return jobs;
        }

        @Override
        public final Builder jobs(Collection<JobDetail> jobs) {
            this.jobs = JobDetailListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(JobDetail... jobs) {
            jobs(Arrays.asList(jobs));
            return this;
        }

        public final void setJobs(Collection<JobDetail> jobs) {
            this.jobs = JobDetailListCopier.copy(jobs);
        }

        @Override
        public DescribeJobsResponse build() {
            return new DescribeJobsResponse(this);
        }
    }
}
