/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterJobDefinitionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<RegisterJobDefinitionResponse.Builder, RegisterJobDefinitionResponse> {
    private final String jobDefinitionName;

    private final String jobDefinitionArn;

    private final Integer revision;

    private RegisterJobDefinitionResponse(BuilderImpl builder) {
        this.jobDefinitionName = builder.jobDefinitionName;
        this.jobDefinitionArn = builder.jobDefinitionArn;
        this.revision = builder.revision;
    }

    /**
     * <p>
     * The name of the job definition.
     * </p>
     * 
     * @return The name of the job definition.
     */
    public String jobDefinitionName() {
        return jobDefinitionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job definition.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job definition.
     */
    public String jobDefinitionArn() {
        return jobDefinitionArn;
    }

    /**
     * <p>
     * The revision of the job definition.
     * </p>
     * 
     * @return The revision of the job definition.
     */
    public Integer revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobDefinitionName() == null) ? 0 : jobDefinitionName().hashCode());
        hashCode = 31 * hashCode + ((jobDefinitionArn() == null) ? 0 : jobDefinitionArn().hashCode());
        hashCode = 31 * hashCode + ((revision() == null) ? 0 : revision().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterJobDefinitionResponse)) {
            return false;
        }
        RegisterJobDefinitionResponse other = (RegisterJobDefinitionResponse) obj;
        if (other.jobDefinitionName() == null ^ this.jobDefinitionName() == null) {
            return false;
        }
        if (other.jobDefinitionName() != null && !other.jobDefinitionName().equals(this.jobDefinitionName())) {
            return false;
        }
        if (other.jobDefinitionArn() == null ^ this.jobDefinitionArn() == null) {
            return false;
        }
        if (other.jobDefinitionArn() != null && !other.jobDefinitionArn().equals(this.jobDefinitionArn())) {
            return false;
        }
        if (other.revision() == null ^ this.revision() == null) {
            return false;
        }
        if (other.revision() != null && !other.revision().equals(this.revision())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jobDefinitionName() != null) {
            sb.append("JobDefinitionName: ").append(jobDefinitionName()).append(",");
        }
        if (jobDefinitionArn() != null) {
            sb.append("JobDefinitionArn: ").append(jobDefinitionArn()).append(",");
        }
        if (revision() != null) {
            sb.append("Revision: ").append(revision()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RegisterJobDefinitionResponse> {
        /**
         * <p>
         * The name of the job definition.
         * </p>
         * 
         * @param jobDefinitionName
         *        The name of the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionName(String jobDefinitionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job definition.
         * </p>
         * 
         * @param jobDefinitionArn
         *        The Amazon Resource Name (ARN) of the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionArn(String jobDefinitionArn);

        /**
         * <p>
         * The revision of the job definition.
         * </p>
         * 
         * @param revision
         *        The revision of the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(Integer revision);
    }

    private static final class BuilderImpl implements Builder {
        private String jobDefinitionName;

        private String jobDefinitionArn;

        private Integer revision;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterJobDefinitionResponse model) {
            setJobDefinitionName(model.jobDefinitionName);
            setJobDefinitionArn(model.jobDefinitionArn);
            setRevision(model.revision);
        }

        public final String getJobDefinitionName() {
            return jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final String getJobDefinitionArn() {
            return jobDefinitionArn;
        }

        @Override
        public final Builder jobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        public final void setJobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
        }

        public final Integer getRevision() {
            return revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        @Override
        public RegisterJobDefinitionResponse build() {
            return new RegisterJobDefinitionResponse(this);
        }
    }
}
