/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateJobQueueResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateJobQueueResponse.Builder, CreateJobQueueResponse> {
    private final String jobQueueName;

    private final String jobQueueArn;

    private CreateJobQueueResponse(BuilderImpl builder) {
        this.jobQueueName = builder.jobQueueName;
        this.jobQueueArn = builder.jobQueueArn;
    }

    /**
     * <p>
     * The name of the job queue.
     * </p>
     * 
     * @return The name of the job queue.
     */
    public String jobQueueName() {
        return jobQueueName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job queue.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job queue.
     */
    public String jobQueueArn() {
        return jobQueueArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobQueueName() == null) ? 0 : jobQueueName().hashCode());
        hashCode = 31 * hashCode + ((jobQueueArn() == null) ? 0 : jobQueueArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobQueueResponse)) {
            return false;
        }
        CreateJobQueueResponse other = (CreateJobQueueResponse) obj;
        if (other.jobQueueName() == null ^ this.jobQueueName() == null) {
            return false;
        }
        if (other.jobQueueName() != null && !other.jobQueueName().equals(this.jobQueueName())) {
            return false;
        }
        if (other.jobQueueArn() == null ^ this.jobQueueArn() == null) {
            return false;
        }
        if (other.jobQueueArn() != null && !other.jobQueueArn().equals(this.jobQueueArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jobQueueName() != null) {
            sb.append("JobQueueName: ").append(jobQueueName()).append(",");
        }
        if (jobQueueArn() != null) {
            sb.append("JobQueueArn: ").append(jobQueueArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateJobQueueResponse> {
        /**
         * <p>
         * The name of the job queue.
         * </p>
         * 
         * @param jobQueueName
         *        The name of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueueName(String jobQueueName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job queue.
         * </p>
         * 
         * @param jobQueueArn
         *        The Amazon Resource Name (ARN) of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueueArn(String jobQueueArn);
    }

    private static final class BuilderImpl implements Builder {
        private String jobQueueName;

        private String jobQueueArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobQueueResponse model) {
            setJobQueueName(model.jobQueueName);
            setJobQueueArn(model.jobQueueArn);
        }

        public final String getJobQueueName() {
            return jobQueueName;
        }

        @Override
        public final Builder jobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
            return this;
        }

        public final void setJobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
        }

        public final String getJobQueueArn() {
            return jobQueueArn;
        }

        @Override
        public final Builder jobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
            return this;
        }

        public final void setJobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
        }

        @Override
        public CreateJobQueueResponse build() {
            return new CreateJobQueueResponse(this);
        }
    }
}
