/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteComputeEnvironmentRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteComputeEnvironmentRequest.Builder, DeleteComputeEnvironmentRequest> {
    private final String computeEnvironment;

    private DeleteComputeEnvironmentRequest(BuilderImpl builder) {
        this.computeEnvironment = builder.computeEnvironment;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the compute environment to delete.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the compute environment to delete.
     */
    public String computeEnvironment() {
        return computeEnvironment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((computeEnvironment() == null) ? 0 : computeEnvironment().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteComputeEnvironmentRequest)) {
            return false;
        }
        DeleteComputeEnvironmentRequest other = (DeleteComputeEnvironmentRequest) obj;
        if (other.computeEnvironment() == null ^ this.computeEnvironment() == null) {
            return false;
        }
        if (other.computeEnvironment() != null && !other.computeEnvironment().equals(this.computeEnvironment())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (computeEnvironment() != null) {
            sb.append("ComputeEnvironment: ").append(computeEnvironment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteComputeEnvironmentRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the compute environment to delete.
         * </p>
         * 
         * @param computeEnvironment
         *        The name or Amazon Resource Name (ARN) of the compute environment to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironment(String computeEnvironment);
    }

    private static final class BuilderImpl implements Builder {
        private String computeEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteComputeEnvironmentRequest model) {
            setComputeEnvironment(model.computeEnvironment);
        }

        public final String getComputeEnvironment() {
            return computeEnvironment;
        }

        @Override
        public final Builder computeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
            return this;
        }

        public final void setComputeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
        }

        @Override
        public DeleteComputeEnvironmentRequest build() {
            return new DeleteComputeEnvironmentRequest(this);
        }
    }
}
