/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeComputeEnvironmentsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeComputeEnvironmentsResponse.Builder, DescribeComputeEnvironmentsResponse> {
    private final List<ComputeEnvironmentDetail> computeEnvironments;

    private final String nextToken;

    private DescribeComputeEnvironmentsResponse(BuilderImpl builder) {
        this.computeEnvironments = builder.computeEnvironments;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of compute environments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of compute environments.
     */
    public List<ComputeEnvironmentDetail> computeEnvironments() {
        return computeEnvironments;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeComputeEnvironments</code> request. When
     * the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value can be
     * used to retrieve the next page of results. This value is <code>null</code> when there are no more results to
     * return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribeComputeEnvironments</code> request.
     *         When the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this
     *         value can be used to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((computeEnvironments() == null) ? 0 : computeEnvironments().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputeEnvironmentsResponse)) {
            return false;
        }
        DescribeComputeEnvironmentsResponse other = (DescribeComputeEnvironmentsResponse) obj;
        if (other.computeEnvironments() == null ^ this.computeEnvironments() == null) {
            return false;
        }
        if (other.computeEnvironments() != null && !other.computeEnvironments().equals(this.computeEnvironments())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (computeEnvironments() != null) {
            sb.append("ComputeEnvironments: ").append(computeEnvironments()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeComputeEnvironmentsResponse> {
        /**
         * <p>
         * The list of compute environments.
         * </p>
         * 
         * @param computeEnvironments
         *        The list of compute environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironments(Collection<ComputeEnvironmentDetail> computeEnvironments);

        /**
         * <p>
         * The list of compute environments.
         * </p>
         * 
         * @param computeEnvironments
         *        The list of compute environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironments(ComputeEnvironmentDetail... computeEnvironments);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>DescribeComputeEnvironments</code> request.
         * When the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value
         * can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>DescribeComputeEnvironments</code>
         *        request. When the results of a <code>DescribeJobDefinitions</code> request exceed
         *        <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is
         *        <code>null</code> when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<ComputeEnvironmentDetail> computeEnvironments;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputeEnvironmentsResponse model) {
            setComputeEnvironments(model.computeEnvironments);
            setNextToken(model.nextToken);
        }

        public final Collection<ComputeEnvironmentDetail> getComputeEnvironments() {
            return computeEnvironments;
        }

        @Override
        public final Builder computeEnvironments(Collection<ComputeEnvironmentDetail> computeEnvironments) {
            this.computeEnvironments = ComputeEnvironmentDetailListCopier.copy(computeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironments(ComputeEnvironmentDetail... computeEnvironments) {
            computeEnvironments(Arrays.asList(computeEnvironments));
            return this;
        }

        public final void setComputeEnvironments(Collection<ComputeEnvironmentDetail> computeEnvironments) {
            this.computeEnvironments = ComputeEnvironmentDetailListCopier.copy(computeEnvironments);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeComputeEnvironmentsResponse build() {
            return new DescribeComputeEnvironmentsResponse(this);
        }
    }
}
