/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.JobQueueDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the details of an AWS Batch job queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class JobQueueDetail implements StructuredPojo, ToCopyableBuilder<JobQueueDetail.Builder, JobQueueDetail> {
    private final String jobQueueName;

    private final String jobQueueArn;

    private final String state;

    private final String status;

    private final String statusReason;

    private final Integer priority;

    private final List<ComputeEnvironmentOrder> computeEnvironmentOrder;

    private JobQueueDetail(BuilderImpl builder) {
        this.jobQueueName = builder.jobQueueName;
        this.jobQueueArn = builder.jobQueueArn;
        this.state = builder.state;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.priority = builder.priority;
        this.computeEnvironmentOrder = builder.computeEnvironmentOrder;
    }

    /**
     * <p>
     * The name of the job queue.
     * </p>
     * 
     * @return The name of the job queue.
     */
    public String jobQueueName() {
        return jobQueueName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job queue.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job queue.
     */
    public String jobQueueArn() {
        return jobQueueArn;
    }

    /**
     * <p>
     * Describes the ability of the queue to accept new jobs.
     * </p>
     * 
     * @return Describes the ability of the queue to accept new jobs.
     * @see JQState
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
     * </p>
     * 
     * @return The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
     * @see JQStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * A short, human-readable string to provide additional details about the current status of the job queue.
     * </p>
     * 
     * @return A short, human-readable string to provide additional details about the current status of the job queue.
     */
    public String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The priority of the job queue.
     * </p>
     * 
     * @return The priority of the job queue.
     */
    public Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The compute environments that are attached to the job queue and the order in which job placement is preferred.
     * Compute environments are selected for job placement in ascending order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The compute environments that are attached to the job queue and the order in which job placement is
     *         preferred. Compute environments are selected for job placement in ascending order.
     */
    public List<ComputeEnvironmentOrder> computeEnvironmentOrder() {
        return computeEnvironmentOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobQueueName() == null) ? 0 : jobQueueName().hashCode());
        hashCode = 31 * hashCode + ((jobQueueArn() == null) ? 0 : jobQueueArn().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((statusReason() == null) ? 0 : statusReason().hashCode());
        hashCode = 31 * hashCode + ((priority() == null) ? 0 : priority().hashCode());
        hashCode = 31 * hashCode + ((computeEnvironmentOrder() == null) ? 0 : computeEnvironmentOrder().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobQueueDetail)) {
            return false;
        }
        JobQueueDetail other = (JobQueueDetail) obj;
        if (other.jobQueueName() == null ^ this.jobQueueName() == null) {
            return false;
        }
        if (other.jobQueueName() != null && !other.jobQueueName().equals(this.jobQueueName())) {
            return false;
        }
        if (other.jobQueueArn() == null ^ this.jobQueueArn() == null) {
            return false;
        }
        if (other.jobQueueArn() != null && !other.jobQueueArn().equals(this.jobQueueArn())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusReason() == null ^ this.statusReason() == null) {
            return false;
        }
        if (other.statusReason() != null && !other.statusReason().equals(this.statusReason())) {
            return false;
        }
        if (other.priority() == null ^ this.priority() == null) {
            return false;
        }
        if (other.priority() != null && !other.priority().equals(this.priority())) {
            return false;
        }
        if (other.computeEnvironmentOrder() == null ^ this.computeEnvironmentOrder() == null) {
            return false;
        }
        if (other.computeEnvironmentOrder() != null && !other.computeEnvironmentOrder().equals(this.computeEnvironmentOrder())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jobQueueName() != null) {
            sb.append("JobQueueName: ").append(jobQueueName()).append(",");
        }
        if (jobQueueArn() != null) {
            sb.append("JobQueueArn: ").append(jobQueueArn()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (statusReason() != null) {
            sb.append("StatusReason: ").append(statusReason()).append(",");
        }
        if (priority() != null) {
            sb.append("Priority: ").append(priority()).append(",");
        }
        if (computeEnvironmentOrder() != null) {
            sb.append("ComputeEnvironmentOrder: ").append(computeEnvironmentOrder()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobQueueDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, JobQueueDetail> {
        /**
         * <p>
         * The name of the job queue.
         * </p>
         * 
         * @param jobQueueName
         *        The name of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueueName(String jobQueueName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job queue.
         * </p>
         * 
         * @param jobQueueArn
         *        The Amazon Resource Name (ARN) of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueueArn(String jobQueueArn);

        /**
         * <p>
         * Describes the ability of the queue to accept new jobs.
         * </p>
         * 
         * @param state
         *        Describes the ability of the queue to accept new jobs.
         * @see JQState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQState
         */
        Builder state(String state);

        /**
         * <p>
         * Describes the ability of the queue to accept new jobs.
         * </p>
         * 
         * @param state
         *        Describes the ability of the queue to accept new jobs.
         * @see JQState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQState
         */
        Builder state(JQState state);

        /**
         * <p>
         * The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
         * </p>
         * 
         * @param status
         *        The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
         * @see JQStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
         * </p>
         * 
         * @param status
         *        The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
         * @see JQStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQStatus
         */
        Builder status(JQStatus status);

        /**
         * <p>
         * A short, human-readable string to provide additional details about the current status of the job queue.
         * </p>
         * 
         * @param statusReason
         *        A short, human-readable string to provide additional details about the current status of the job
         *        queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The priority of the job queue.
         * </p>
         * 
         * @param priority
         *        The priority of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The compute environments that are attached to the job queue and the order in which job placement is
         * preferred. Compute environments are selected for job placement in ascending order.
         * </p>
         * 
         * @param computeEnvironmentOrder
         *        The compute environments that are attached to the job queue and the order in which job placement is
         *        preferred. Compute environments are selected for job placement in ascending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder);

        /**
         * <p>
         * The compute environments that are attached to the job queue and the order in which job placement is
         * preferred. Compute environments are selected for job placement in ascending order.
         * </p>
         * 
         * @param computeEnvironmentOrder
         *        The compute environments that are attached to the job queue and the order in which job placement is
         *        preferred. Compute environments are selected for job placement in ascending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentOrder(ComputeEnvironmentOrder... computeEnvironmentOrder);
    }

    private static final class BuilderImpl implements Builder {
        private String jobQueueName;

        private String jobQueueArn;

        private String state;

        private String status;

        private String statusReason;

        private Integer priority;

        private List<ComputeEnvironmentOrder> computeEnvironmentOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(JobQueueDetail model) {
            setJobQueueName(model.jobQueueName);
            setJobQueueArn(model.jobQueueArn);
            setState(model.state);
            setStatus(model.status);
            setStatusReason(model.statusReason);
            setPriority(model.priority);
            setComputeEnvironmentOrder(model.computeEnvironmentOrder);
        }

        public final String getJobQueueName() {
            return jobQueueName;
        }

        @Override
        public final Builder jobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
            return this;
        }

        public final void setJobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
        }

        public final String getJobQueueArn() {
            return jobQueueArn;
        }

        @Override
        public final Builder jobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
            return this;
        }

        public final void setJobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JQState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JQStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<ComputeEnvironmentOrder> getComputeEnvironmentOrder() {
            return computeEnvironmentOrder;
        }

        @Override
        public final Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironmentOrder(ComputeEnvironmentOrder... computeEnvironmentOrder) {
            computeEnvironmentOrder(Arrays.asList(computeEnvironmentOrder));
            return this;
        }

        public final void setComputeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
        }

        @Override
        public JobQueueDetail build() {
            return new JobQueueDetail(this);
        }
    }
}
