/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelJobRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CancelJobRequest.Builder, CancelJobRequest> {
    private final String jobId;

    private final String reason;

    private CancelJobRequest(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * A list of up to 100 job IDs to cancel.
     * </p>
     * 
     * @return A list of up to 100 job IDs to cancel.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * A message to attach to the job that explains the reason for cancelling it. This message is returned by future
     * <a>DescribeJobs</a> operations on the job. This message is also recorded in the AWS Batch activity logs.
     * </p>
     * 
     * @return A message to attach to the job that explains the reason for cancelling it. This message is returned by
     *         future <a>DescribeJobs</a> operations on the job. This message is also recorded in the AWS Batch activity
     *         logs.
     */
    public String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobId() == null) ? 0 : jobId().hashCode());
        hashCode = 31 * hashCode + ((reason() == null) ? 0 : reason().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelJobRequest)) {
            return false;
        }
        CancelJobRequest other = (CancelJobRequest) obj;
        if (other.jobId() == null ^ this.jobId() == null) {
            return false;
        }
        if (other.jobId() != null && !other.jobId().equals(this.jobId())) {
            return false;
        }
        if (other.reason() == null ^ this.reason() == null) {
            return false;
        }
        if (other.reason() != null && !other.reason().equals(this.reason())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jobId() != null) {
            sb.append("JobId: ").append(jobId()).append(",");
        }
        if (reason() != null) {
            sb.append("Reason: ").append(reason()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.of(clazz.cast(jobId()));
        case "reason":
            return Optional.of(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CancelJobRequest> {
        /**
         * <p>
         * A list of up to 100 job IDs to cancel.
         * </p>
         * 
         * @param jobId
         *        A list of up to 100 job IDs to cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * A message to attach to the job that explains the reason for cancelling it. This message is returned by future
         * <a>DescribeJobs</a> operations on the job. This message is also recorded in the AWS Batch activity logs.
         * </p>
         * 
         * @param reason
         *        A message to attach to the job that explains the reason for cancelling it. This message is returned by
         *        future <a>DescribeJobs</a> operations on the job. This message is also recorded in the AWS Batch
         *        activity logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelJobRequest model) {
            jobId(model.jobId);
            reason(model.reason);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public CancelJobRequest build() {
            return new CancelJobRequest(this);
        }
    }
}
