/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.ComputeEnvironmentDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an AWS Batch compute environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ComputeEnvironmentDetail implements StructuredPojo,
        ToCopyableBuilder<ComputeEnvironmentDetail.Builder, ComputeEnvironmentDetail> {
    private final String computeEnvironmentName;

    private final String computeEnvironmentArn;

    private final String ecsClusterArn;

    private final String type;

    private final String state;

    private final String status;

    private final String statusReason;

    private final ComputeResource computeResources;

    private final String serviceRole;

    private ComputeEnvironmentDetail(BuilderImpl builder) {
        this.computeEnvironmentName = builder.computeEnvironmentName;
        this.computeEnvironmentArn = builder.computeEnvironmentArn;
        this.ecsClusterArn = builder.ecsClusterArn;
        this.type = builder.type;
        this.state = builder.state;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.computeResources = builder.computeResources;
        this.serviceRole = builder.serviceRole;
    }

    /**
     * <p>
     * The name of the compute environment.
     * </p>
     * 
     * @return The name of the compute environment.
     */
    public String computeEnvironmentName() {
        return computeEnvironmentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the compute environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the compute environment.
     */
    public String computeEnvironmentArn() {
        return computeEnvironmentArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used by the compute environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used by the compute environment.
     */
    public String ecsClusterArn() {
        return ecsClusterArn;
    }

    /**
     * <p>
     * The type of the compute environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of the compute environment.
     * @see CEType
     */
    public CEType type() {
        return CEType.fromValue(type);
    }

    /**
     * <p>
     * The type of the compute environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of the compute environment.
     * @see CEType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The state of the compute environment. The valid values are <code>ENABLED</code> or <code>DISABLED</code>. An
     * <code>ENABLED</code> state indicates that you can register instances with the compute environment and that the
     * associated instances can accept jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CEState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the compute environment. The valid values are <code>ENABLED</code> or <code>DISABLED</code>.
     *         An <code>ENABLED</code> state indicates that you can register instances with the compute environment and
     *         that the associated instances can accept jobs.
     * @see CEState
     */
    public CEState state() {
        return CEState.fromValue(state);
    }

    /**
     * <p>
     * The state of the compute environment. The valid values are <code>ENABLED</code> or <code>DISABLED</code>. An
     * <code>ENABLED</code> state indicates that you can register instances with the compute environment and that the
     * associated instances can accept jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CEState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the compute environment. The valid values are <code>ENABLED</code> or <code>DISABLED</code>.
     *         An <code>ENABLED</code> state indicates that you can register instances with the compute environment and
     *         that the associated instances can accept jobs.
     * @see CEState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The current status of the compute environment (for example, <code>CREATING</code> or <code>VALID</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CEStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The current status of the compute environment (for example, <code>CREATING</code> or <code>VALID</code>).
     * @see CEStatus
     */
    public CEStatus status() {
        return CEStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the compute environment (for example, <code>CREATING</code> or <code>VALID</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CEStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The current status of the compute environment (for example, <code>CREATING</code> or <code>VALID</code>).
     * @see CEStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * A short, human-readable string to provide additional details about the current status of the compute environment.
     * </p>
     * 
     * @return A short, human-readable string to provide additional details about the current status of the compute
     *         environment.
     */
    public String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The compute resources defined for the compute environment.
     * </p>
     * 
     * @return The compute resources defined for the compute environment.
     */
    public ComputeResource computeResources() {
        return computeResources;
    }

    /**
     * <p>
     * The service role associated with the compute environment that allows AWS Batch to make calls to AWS API
     * operations on your behalf.
     * </p>
     * 
     * @return The service role associated with the compute environment that allows AWS Batch to make calls to AWS API
     *         operations on your behalf.
     */
    public String serviceRole() {
        return serviceRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((computeEnvironmentName() == null) ? 0 : computeEnvironmentName().hashCode());
        hashCode = 31 * hashCode + ((computeEnvironmentArn() == null) ? 0 : computeEnvironmentArn().hashCode());
        hashCode = 31 * hashCode + ((ecsClusterArn() == null) ? 0 : ecsClusterArn().hashCode());
        hashCode = 31 * hashCode + ((typeString() == null) ? 0 : typeString().hashCode());
        hashCode = 31 * hashCode + ((stateString() == null) ? 0 : stateString().hashCode());
        hashCode = 31 * hashCode + ((statusString() == null) ? 0 : statusString().hashCode());
        hashCode = 31 * hashCode + ((statusReason() == null) ? 0 : statusReason().hashCode());
        hashCode = 31 * hashCode + ((computeResources() == null) ? 0 : computeResources().hashCode());
        hashCode = 31 * hashCode + ((serviceRole() == null) ? 0 : serviceRole().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeEnvironmentDetail)) {
            return false;
        }
        ComputeEnvironmentDetail other = (ComputeEnvironmentDetail) obj;
        if (other.computeEnvironmentName() == null ^ this.computeEnvironmentName() == null) {
            return false;
        }
        if (other.computeEnvironmentName() != null && !other.computeEnvironmentName().equals(this.computeEnvironmentName())) {
            return false;
        }
        if (other.computeEnvironmentArn() == null ^ this.computeEnvironmentArn() == null) {
            return false;
        }
        if (other.computeEnvironmentArn() != null && !other.computeEnvironmentArn().equals(this.computeEnvironmentArn())) {
            return false;
        }
        if (other.ecsClusterArn() == null ^ this.ecsClusterArn() == null) {
            return false;
        }
        if (other.ecsClusterArn() != null && !other.ecsClusterArn().equals(this.ecsClusterArn())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.statusReason() == null ^ this.statusReason() == null) {
            return false;
        }
        if (other.statusReason() != null && !other.statusReason().equals(this.statusReason())) {
            return false;
        }
        if (other.computeResources() == null ^ this.computeResources() == null) {
            return false;
        }
        if (other.computeResources() != null && !other.computeResources().equals(this.computeResources())) {
            return false;
        }
        if (other.serviceRole() == null ^ this.serviceRole() == null) {
            return false;
        }
        if (other.serviceRole() != null && !other.serviceRole().equals(this.serviceRole())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (computeEnvironmentName() != null) {
            sb.append("ComputeEnvironmentName: ").append(computeEnvironmentName()).append(",");
        }
        if (computeEnvironmentArn() != null) {
            sb.append("ComputeEnvironmentArn: ").append(computeEnvironmentArn()).append(",");
        }
        if (ecsClusterArn() != null) {
            sb.append("EcsClusterArn: ").append(ecsClusterArn()).append(",");
        }
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (statusReason() != null) {
            sb.append("StatusReason: ").append(statusReason()).append(",");
        }
        if (computeResources() != null) {
            sb.append("ComputeResources: ").append(computeResources()).append(",");
        }
        if (serviceRole() != null) {
            sb.append("ServiceRole: ").append(serviceRole()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeEnvironmentName":
            return Optional.of(clazz.cast(computeEnvironmentName()));
        case "computeEnvironmentArn":
            return Optional.of(clazz.cast(computeEnvironmentArn()));
        case "ecsClusterArn":
            return Optional.of(clazz.cast(ecsClusterArn()));
        case "type":
            return Optional.of(clazz.cast(typeString()));
        case "state":
            return Optional.of(clazz.cast(stateString()));
        case "status":
            return Optional.of(clazz.cast(statusString()));
        case "statusReason":
            return Optional.of(clazz.cast(statusReason()));
        case "computeResources":
            return Optional.of(clazz.cast(computeResources()));
        case "serviceRole":
            return Optional.of(clazz.cast(serviceRole()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComputeEnvironmentDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ComputeEnvironmentDetail> {
        /**
         * <p>
         * The name of the compute environment.
         * </p>
         * 
         * @param computeEnvironmentName
         *        The name of the compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentName(String computeEnvironmentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the compute environment.
         * </p>
         * 
         * @param computeEnvironmentArn
         *        The Amazon Resource Name (ARN) of the compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentArn(String computeEnvironmentArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used by the compute environment.
         * </p>
         * 
         * @param ecsClusterArn
         *        The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used by the compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusterArn(String ecsClusterArn);

        /**
         * <p>
         * The type of the compute environment.
         * </p>
         * 
         * @param type
         *        The type of the compute environment.
         * @see CEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the compute environment.
         * </p>
         * 
         * @param type
         *        The type of the compute environment.
         * @see CEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEType
         */
        Builder type(CEType type);

        /**
         * <p>
         * The state of the compute environment. The valid values are <code>ENABLED</code> or <code>DISABLED</code>. An
         * <code>ENABLED</code> state indicates that you can register instances with the compute environment and that
         * the associated instances can accept jobs.
         * </p>
         * 
         * @param state
         *        The state of the compute environment. The valid values are <code>ENABLED</code> or
         *        <code>DISABLED</code>. An <code>ENABLED</code> state indicates that you can register instances with
         *        the compute environment and that the associated instances can accept jobs.
         * @see CEState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the compute environment. The valid values are <code>ENABLED</code> or <code>DISABLED</code>. An
         * <code>ENABLED</code> state indicates that you can register instances with the compute environment and that
         * the associated instances can accept jobs.
         * </p>
         * 
         * @param state
         *        The state of the compute environment. The valid values are <code>ENABLED</code> or
         *        <code>DISABLED</code>. An <code>ENABLED</code> state indicates that you can register instances with
         *        the compute environment and that the associated instances can accept jobs.
         * @see CEState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEState
         */
        Builder state(CEState state);

        /**
         * <p>
         * The current status of the compute environment (for example, <code>CREATING</code> or <code>VALID</code>).
         * </p>
         * 
         * @param status
         *        The current status of the compute environment (for example, <code>CREATING</code> or
         *        <code>VALID</code>).
         * @see CEStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the compute environment (for example, <code>CREATING</code> or <code>VALID</code>).
         * </p>
         * 
         * @param status
         *        The current status of the compute environment (for example, <code>CREATING</code> or
         *        <code>VALID</code>).
         * @see CEStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEStatus
         */
        Builder status(CEStatus status);

        /**
         * <p>
         * A short, human-readable string to provide additional details about the current status of the compute
         * environment.
         * </p>
         * 
         * @param statusReason
         *        A short, human-readable string to provide additional details about the current status of the compute
         *        environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The compute resources defined for the compute environment.
         * </p>
         * 
         * @param computeResources
         *        The compute resources defined for the compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeResources(ComputeResource computeResources);

        /**
         * <p>
         * The service role associated with the compute environment that allows AWS Batch to make calls to AWS API
         * operations on your behalf.
         * </p>
         * 
         * @param serviceRole
         *        The service role associated with the compute environment that allows AWS Batch to make calls to AWS
         *        API operations on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);
    }

    static final class BuilderImpl implements Builder {
        private String computeEnvironmentName;

        private String computeEnvironmentArn;

        private String ecsClusterArn;

        private String type;

        private String state;

        private String status;

        private String statusReason;

        private ComputeResource computeResources;

        private String serviceRole;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeEnvironmentDetail model) {
            computeEnvironmentName(model.computeEnvironmentName);
            computeEnvironmentArn(model.computeEnvironmentArn);
            ecsClusterArn(model.ecsClusterArn);
            type(model.type);
            state(model.state);
            status(model.status);
            statusReason(model.statusReason);
            computeResources(model.computeResources);
            serviceRole(model.serviceRole);
        }

        public final String getComputeEnvironmentName() {
            return computeEnvironmentName;
        }

        @Override
        public final Builder computeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        public final void setComputeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
        }

        public final String getComputeEnvironmentArn() {
            return computeEnvironmentArn;
        }

        @Override
        public final Builder computeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
            return this;
        }

        public final void setComputeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
        }

        public final String getEcsClusterArn() {
            return ecsClusterArn;
        }

        @Override
        public final Builder ecsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
            return this;
        }

        public final void setEcsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CEType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CEState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CEStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final ComputeResource.Builder getComputeResources() {
            return computeResources != null ? computeResources.toBuilder() : null;
        }

        @Override
        public final Builder computeResources(ComputeResource computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        public final void setComputeResources(ComputeResource.BuilderImpl computeResources) {
            this.computeResources = computeResources != null ? computeResources.build() : null;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public ComputeEnvironmentDetail build() {
            return new ComputeEnvironmentDetail(this);
        }
    }
}
