/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateComputeEnvironmentRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateComputeEnvironmentRequest.Builder, CreateComputeEnvironmentRequest> {
    private final String computeEnvironmentName;

    private final String type;

    private final String state;

    private final ComputeResource computeResources;

    private final String serviceRole;

    private CreateComputeEnvironmentRequest(BuilderImpl builder) {
        this.computeEnvironmentName = builder.computeEnvironmentName;
        this.type = builder.type;
        this.state = builder.state;
        this.computeResources = builder.computeResources;
        this.serviceRole = builder.serviceRole;
    }

    /**
     * <p>
     * The name for your compute environment. Up to 128 letters (uppercase and lowercase), numbers, and underscores are
     * allowed.
     * </p>
     * 
     * @return The name for your compute environment. Up to 128 letters (uppercase and lowercase), numbers, and
     *         underscores are allowed.
     */
    public String computeEnvironmentName() {
        return computeEnvironmentName;
    }

    /**
     * <p>
     * The type of the compute environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of the compute environment.
     * @see CEType
     */
    public CEType type() {
        return CEType.fromValue(type);
    }

    /**
     * <p>
     * The type of the compute environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of the compute environment.
     * @see CEType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The state of the compute environment. If the state is <code>ENABLED</code>, then the compute environment accepts
     * jobs from a queue and can scale out automatically based on queues.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CEState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the compute environment. If the state is <code>ENABLED</code>, then the compute environment
     *         accepts jobs from a queue and can scale out automatically based on queues.
     * @see CEState
     */
    public CEState state() {
        return CEState.fromValue(state);
    }

    /**
     * <p>
     * The state of the compute environment. If the state is <code>ENABLED</code>, then the compute environment accepts
     * jobs from a queue and can scale out automatically based on queues.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CEState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the compute environment. If the state is <code>ENABLED</code>, then the compute environment
     *         accepts jobs from a queue and can scale out automatically based on queues.
     * @see CEState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * Details of the compute resources managed by the compute environment. This parameter is required for managed
     * compute environments.
     * </p>
     * 
     * @return Details of the compute resources managed by the compute environment. This parameter is required for
     *         managed compute environments.
     */
    public ComputeResource computeResources() {
        return computeResources;
    }

    /**
     * <p>
     * The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on
     * your behalf.
     * </p>
     * 
     * @return The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS
     *         services on your behalf.
     */
    public String serviceRole() {
        return serviceRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((computeEnvironmentName() == null) ? 0 : computeEnvironmentName().hashCode());
        hashCode = 31 * hashCode + ((typeString() == null) ? 0 : typeString().hashCode());
        hashCode = 31 * hashCode + ((stateString() == null) ? 0 : stateString().hashCode());
        hashCode = 31 * hashCode + ((computeResources() == null) ? 0 : computeResources().hashCode());
        hashCode = 31 * hashCode + ((serviceRole() == null) ? 0 : serviceRole().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputeEnvironmentRequest)) {
            return false;
        }
        CreateComputeEnvironmentRequest other = (CreateComputeEnvironmentRequest) obj;
        if (other.computeEnvironmentName() == null ^ this.computeEnvironmentName() == null) {
            return false;
        }
        if (other.computeEnvironmentName() != null && !other.computeEnvironmentName().equals(this.computeEnvironmentName())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.computeResources() == null ^ this.computeResources() == null) {
            return false;
        }
        if (other.computeResources() != null && !other.computeResources().equals(this.computeResources())) {
            return false;
        }
        if (other.serviceRole() == null ^ this.serviceRole() == null) {
            return false;
        }
        if (other.serviceRole() != null && !other.serviceRole().equals(this.serviceRole())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (computeEnvironmentName() != null) {
            sb.append("ComputeEnvironmentName: ").append(computeEnvironmentName()).append(",");
        }
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (computeResources() != null) {
            sb.append("ComputeResources: ").append(computeResources()).append(",");
        }
        if (serviceRole() != null) {
            sb.append("ServiceRole: ").append(serviceRole()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeEnvironmentName":
            return Optional.of(clazz.cast(computeEnvironmentName()));
        case "type":
            return Optional.of(clazz.cast(typeString()));
        case "state":
            return Optional.of(clazz.cast(stateString()));
        case "computeResources":
            return Optional.of(clazz.cast(computeResources()));
        case "serviceRole":
            return Optional.of(clazz.cast(serviceRole()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateComputeEnvironmentRequest> {
        /**
         * <p>
         * The name for your compute environment. Up to 128 letters (uppercase and lowercase), numbers, and underscores
         * are allowed.
         * </p>
         * 
         * @param computeEnvironmentName
         *        The name for your compute environment. Up to 128 letters (uppercase and lowercase), numbers, and
         *        underscores are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentName(String computeEnvironmentName);

        /**
         * <p>
         * The type of the compute environment.
         * </p>
         * 
         * @param type
         *        The type of the compute environment.
         * @see CEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the compute environment.
         * </p>
         * 
         * @param type
         *        The type of the compute environment.
         * @see CEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEType
         */
        Builder type(CEType type);

        /**
         * <p>
         * The state of the compute environment. If the state is <code>ENABLED</code>, then the compute environment
         * accepts jobs from a queue and can scale out automatically based on queues.
         * </p>
         * 
         * @param state
         *        The state of the compute environment. If the state is <code>ENABLED</code>, then the compute
         *        environment accepts jobs from a queue and can scale out automatically based on queues.
         * @see CEState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the compute environment. If the state is <code>ENABLED</code>, then the compute environment
         * accepts jobs from a queue and can scale out automatically based on queues.
         * </p>
         * 
         * @param state
         *        The state of the compute environment. If the state is <code>ENABLED</code>, then the compute
         *        environment accepts jobs from a queue and can scale out automatically based on queues.
         * @see CEState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEState
         */
        Builder state(CEState state);

        /**
         * <p>
         * Details of the compute resources managed by the compute environment. This parameter is required for managed
         * compute environments.
         * </p>
         * 
         * @param computeResources
         *        Details of the compute resources managed by the compute environment. This parameter is required for
         *        managed compute environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeResources(ComputeResource computeResources);

        /**
         * <p>
         * The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services
         * on your behalf.
         * </p>
         * 
         * @param serviceRole
         *        The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS
         *        services on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);
    }

    static final class BuilderImpl implements Builder {
        private String computeEnvironmentName;

        private String type;

        private String state;

        private ComputeResource computeResources;

        private String serviceRole;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputeEnvironmentRequest model) {
            computeEnvironmentName(model.computeEnvironmentName);
            type(model.type);
            state(model.state);
            computeResources(model.computeResources);
            serviceRole(model.serviceRole);
        }

        public final String getComputeEnvironmentName() {
            return computeEnvironmentName;
        }

        @Override
        public final Builder computeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        public final void setComputeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CEType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CEState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final ComputeResource.Builder getComputeResources() {
            return computeResources != null ? computeResources.toBuilder() : null;
        }

        @Override
        public final Builder computeResources(ComputeResource computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        public final void setComputeResources(ComputeResource.BuilderImpl computeResources) {
            this.computeResources = computeResources != null ? computeResources.build() : null;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public CreateComputeEnvironmentRequest build() {
            return new CreateComputeEnvironmentRequest(this);
        }
    }
}
