/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteJobQueueRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteJobQueueRequest.Builder, DeleteJobQueueRequest> {
    private final String jobQueue;

    private DeleteJobQueueRequest(BuilderImpl builder) {
        this.jobQueue = builder.jobQueue;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the queue to delete.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the queue to delete.
     */
    public String jobQueue() {
        return jobQueue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobQueue() == null) ? 0 : jobQueue().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteJobQueueRequest)) {
            return false;
        }
        DeleteJobQueueRequest other = (DeleteJobQueueRequest) obj;
        if (other.jobQueue() == null ^ this.jobQueue() == null) {
            return false;
        }
        if (other.jobQueue() != null && !other.jobQueue().equals(this.jobQueue())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jobQueue() != null) {
            sb.append("JobQueue: ").append(jobQueue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobQueue":
            return Optional.of(clazz.cast(jobQueue()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteJobQueueRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the queue to delete.
         * </p>
         * 
         * @param jobQueue
         *        The short name or full Amazon Resource Name (ARN) of the queue to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);
    }

    static final class BuilderImpl implements Builder {
        private String jobQueue;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteJobQueueRequest model) {
            jobQueue(model.jobQueue);
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        @Override
        public DeleteJobQueueRequest build() {
            return new DeleteJobQueueRequest(this);
        }
    }
}
