/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.JobDefinitionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an AWS Batch job definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class JobDefinition implements StructuredPojo, ToCopyableBuilder<JobDefinition.Builder, JobDefinition> {
    private final String jobDefinitionName;

    private final String jobDefinitionArn;

    private final Integer revision;

    private final String status;

    private final String type;

    private final Map<String, String> parameters;

    private final RetryStrategy retryStrategy;

    private final ContainerProperties containerProperties;

    private JobDefinition(BuilderImpl builder) {
        this.jobDefinitionName = builder.jobDefinitionName;
        this.jobDefinitionArn = builder.jobDefinitionArn;
        this.revision = builder.revision;
        this.status = builder.status;
        this.type = builder.type;
        this.parameters = builder.parameters;
        this.retryStrategy = builder.retryStrategy;
        this.containerProperties = builder.containerProperties;
    }

    /**
     * <p>
     * The name of the job definition.
     * </p>
     * 
     * @return The name of the job definition.
     */
    public String jobDefinitionName() {
        return jobDefinitionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the job definition.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the job definition.
     */
    public String jobDefinitionArn() {
        return jobDefinitionArn;
    }

    /**
     * <p>
     * The revision of the job definition.
     * </p>
     * 
     * @return The revision of the job definition.
     */
    public Integer revision() {
        return revision;
    }

    /**
     * <p>
     * The status of the job definition.
     * </p>
     * 
     * @return The status of the job definition.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The type of job definition.
     * </p>
     * 
     * @return The type of job definition.
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * Default parameters or parameter substitution placeholders that are set in the job definition. Parameters are
     * specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding
     * parameter defaults from the job definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Default parameters or parameter substitution placeholders that are set in the job definition. Parameters
     *         are specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any
     *         corresponding parameter defaults from the job definition.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The retry strategy to use for failed jobs that are submitted with this job definition.
     * </p>
     * 
     * @return The retry strategy to use for failed jobs that are submitted with this job definition.
     */
    public RetryStrategy retryStrategy() {
        return retryStrategy;
    }

    /**
     * <p>
     * An object with various properties specific to container-based jobs.
     * </p>
     * 
     * @return An object with various properties specific to container-based jobs.
     */
    public ContainerProperties containerProperties() {
        return containerProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobDefinitionName() == null) ? 0 : jobDefinitionName().hashCode());
        hashCode = 31 * hashCode + ((jobDefinitionArn() == null) ? 0 : jobDefinitionArn().hashCode());
        hashCode = 31 * hashCode + ((revision() == null) ? 0 : revision().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((retryStrategy() == null) ? 0 : retryStrategy().hashCode());
        hashCode = 31 * hashCode + ((containerProperties() == null) ? 0 : containerProperties().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDefinition)) {
            return false;
        }
        JobDefinition other = (JobDefinition) obj;
        if (other.jobDefinitionName() == null ^ this.jobDefinitionName() == null) {
            return false;
        }
        if (other.jobDefinitionName() != null && !other.jobDefinitionName().equals(this.jobDefinitionName())) {
            return false;
        }
        if (other.jobDefinitionArn() == null ^ this.jobDefinitionArn() == null) {
            return false;
        }
        if (other.jobDefinitionArn() != null && !other.jobDefinitionArn().equals(this.jobDefinitionArn())) {
            return false;
        }
        if (other.revision() == null ^ this.revision() == null) {
            return false;
        }
        if (other.revision() != null && !other.revision().equals(this.revision())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.retryStrategy() == null ^ this.retryStrategy() == null) {
            return false;
        }
        if (other.retryStrategy() != null && !other.retryStrategy().equals(this.retryStrategy())) {
            return false;
        }
        if (other.containerProperties() == null ^ this.containerProperties() == null) {
            return false;
        }
        if (other.containerProperties() != null && !other.containerProperties().equals(this.containerProperties())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jobDefinitionName() != null) {
            sb.append("JobDefinitionName: ").append(jobDefinitionName()).append(",");
        }
        if (jobDefinitionArn() != null) {
            sb.append("JobDefinitionArn: ").append(jobDefinitionArn()).append(",");
        }
        if (revision() != null) {
            sb.append("Revision: ").append(revision()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (retryStrategy() != null) {
            sb.append("RetryStrategy: ").append(retryStrategy()).append(",");
        }
        if (containerProperties() != null) {
            sb.append("ContainerProperties: ").append(containerProperties()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDefinitionName":
            return Optional.of(clazz.cast(jobDefinitionName()));
        case "jobDefinitionArn":
            return Optional.of(clazz.cast(jobDefinitionArn()));
        case "revision":
            return Optional.of(clazz.cast(revision()));
        case "status":
            return Optional.of(clazz.cast(status()));
        case "type":
            return Optional.of(clazz.cast(type()));
        case "parameters":
            return Optional.of(clazz.cast(parameters()));
        case "retryStrategy":
            return Optional.of(clazz.cast(retryStrategy()));
        case "containerProperties":
            return Optional.of(clazz.cast(containerProperties()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, JobDefinition> {
        /**
         * <p>
         * The name of the job definition.
         * </p>
         * 
         * @param jobDefinitionName
         *        The name of the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionName(String jobDefinitionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the job definition.
         * </p>
         * 
         * @param jobDefinitionArn
         *        The Amazon Resource Name (ARN) for the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionArn(String jobDefinitionArn);

        /**
         * <p>
         * The revision of the job definition.
         * </p>
         * 
         * @param revision
         *        The revision of the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(Integer revision);

        /**
         * <p>
         * The status of the job definition.
         * </p>
         * 
         * @param status
         *        The status of the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The type of job definition.
         * </p>
         * 
         * @param type
         *        The type of job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * Default parameters or parameter substitution placeholders that are set in the job definition. Parameters are
         * specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any
         * corresponding parameter defaults from the job definition.
         * </p>
         * 
         * @param parameters
         *        Default parameters or parameter substitution placeholders that are set in the job definition.
         *        Parameters are specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request
         *        override any corresponding parameter defaults from the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The retry strategy to use for failed jobs that are submitted with this job definition.
         * </p>
         * 
         * @param retryStrategy
         *        The retry strategy to use for failed jobs that are submitted with this job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryStrategy(RetryStrategy retryStrategy);

        /**
         * <p>
         * An object with various properties specific to container-based jobs.
         * </p>
         * 
         * @param containerProperties
         *        An object with various properties specific to container-based jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerProperties(ContainerProperties containerProperties);
    }

    static final class BuilderImpl implements Builder {
        private String jobDefinitionName;

        private String jobDefinitionArn;

        private Integer revision;

        private String status;

        private String type;

        private Map<String, String> parameters;

        private RetryStrategy retryStrategy;

        private ContainerProperties containerProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDefinition model) {
            jobDefinitionName(model.jobDefinitionName);
            jobDefinitionArn(model.jobDefinitionArn);
            revision(model.revision);
            status(model.status);
            type(model.type);
            parameters(model.parameters);
            retryStrategy(model.retryStrategy);
            containerProperties(model.containerProperties);
        }

        public final String getJobDefinitionName() {
            return jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final String getJobDefinitionArn() {
            return jobDefinitionArn;
        }

        @Override
        public final Builder jobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        public final void setJobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
        }

        public final Integer getRevision() {
            return revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return retryStrategy != null ? retryStrategy.toBuilder() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        public final ContainerProperties.Builder getContainerProperties() {
            return containerProperties != null ? containerProperties.toBuilder() : null;
        }

        @Override
        public final Builder containerProperties(ContainerProperties containerProperties) {
            this.containerProperties = containerProperties;
            return this;
        }

        public final void setContainerProperties(ContainerProperties.BuilderImpl containerProperties) {
            this.containerProperties = containerProperties != null ? containerProperties.build() : null;
        }

        @Override
        public JobDefinition build() {
            return new JobDefinition(this);
        }
    }
}
