/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListJobsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListJobsResponse.Builder, ListJobsResponse> {
    private final List<JobSummary> jobSummaryList;

    private final String nextToken;

    private ListJobsResponse(BuilderImpl builder) {
        this.jobSummaryList = builder.jobSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of job summaries that match the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of job summaries that match the request.
     */
    public List<JobSummary> jobSummaryList() {
        return jobSummaryList;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListJobs</code> request. When the results of a
     * <code>ListJobs</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of
     * results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListJobs</code> request. When the results
     *         of a <code>ListJobs</code> request exceed <code>maxResults</code>, this value can be used to retrieve the
     *         next page of results. This value is <code>null</code> when there are no more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobSummaryList() == null) ? 0 : jobSummaryList().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResponse)) {
            return false;
        }
        ListJobsResponse other = (ListJobsResponse) obj;
        if (other.jobSummaryList() == null ^ this.jobSummaryList() == null) {
            return false;
        }
        if (other.jobSummaryList() != null && !other.jobSummaryList().equals(this.jobSummaryList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jobSummaryList() != null) {
            sb.append("JobSummaryList: ").append(jobSummaryList()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobSummaryList":
            return Optional.of(clazz.cast(jobSummaryList()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListJobsResponse> {
        /**
         * <p>
         * A list of job summaries that match the request.
         * </p>
         * 
         * @param jobSummaryList
         *        A list of job summaries that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobSummaryList(Collection<JobSummary> jobSummaryList);

        /**
         * <p>
         * A list of job summaries that match the request.
         * </p>
         * 
         * @param jobSummaryList
         *        A list of job summaries that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobSummaryList(JobSummary... jobSummaryList);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListJobs</code> request. When the results of a
         * <code>ListJobs</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next
         * page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListJobs</code> request. When the
         *        results of a <code>ListJobs</code> request exceed <code>maxResults</code>, this value can be used to
         *        retrieve the next page of results. This value is <code>null</code> when there are no more results to
         *        return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<JobSummary> jobSummaryList;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsResponse model) {
            jobSummaryList(model.jobSummaryList);
            nextToken(model.nextToken);
        }

        public final Collection<JobSummary.Builder> getJobSummaryList() {
            return jobSummaryList != null ? jobSummaryList.stream().map(JobSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder jobSummaryList(Collection<JobSummary> jobSummaryList) {
            this.jobSummaryList = JobSummaryListCopier.copy(jobSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaryList(JobSummary... jobSummaryList) {
            jobSummaryList(Arrays.asList(jobSummaryList));
            return this;
        }

        public final void setJobSummaryList(Collection<JobSummary.BuilderImpl> jobSummaryList) {
            this.jobSummaryList = JobSummaryListCopier.copyFromBuilder(jobSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListJobsResponse build() {
            return new ListJobsResponse(this);
        }
    }
}
