/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.MountPointMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on a Docker volume mount point that is used in a job's container properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MountPoint implements StructuredPojo, ToCopyableBuilder<MountPoint.Builder, MountPoint> {
    private final String containerPath;

    private final Boolean readOnly;

    private final String sourceVolume;

    private MountPoint(BuilderImpl builder) {
        this.containerPath = builder.containerPath;
        this.readOnly = builder.readOnly;
        this.sourceVolume = builder.sourceVolume;
    }

    /**
     * <p>
     * The path on the container at which to mount the host volume.
     * </p>
     * 
     * @return The path on the container at which to mount the host volume.
     */
    public String containerPath() {
        return containerPath;
    }

    /**
     * <p>
     * If this value is <code>true</code>, the container has read-only access to the volume; otherwise, the container
     * can write to the volume. The default value is <code>false</code>.
     * </p>
     * 
     * @return If this value is <code>true</code>, the container has read-only access to the volume; otherwise, the
     *         container can write to the volume. The default value is <code>false</code>.
     */
    public Boolean readOnly() {
        return readOnly;
    }

    /**
     * <p>
     * The name of the volume to mount.
     * </p>
     * 
     * @return The name of the volume to mount.
     */
    public String sourceVolume() {
        return sourceVolume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((containerPath() == null) ? 0 : containerPath().hashCode());
        hashCode = 31 * hashCode + ((readOnly() == null) ? 0 : readOnly().hashCode());
        hashCode = 31 * hashCode + ((sourceVolume() == null) ? 0 : sourceVolume().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MountPoint)) {
            return false;
        }
        MountPoint other = (MountPoint) obj;
        if (other.containerPath() == null ^ this.containerPath() == null) {
            return false;
        }
        if (other.containerPath() != null && !other.containerPath().equals(this.containerPath())) {
            return false;
        }
        if (other.readOnly() == null ^ this.readOnly() == null) {
            return false;
        }
        if (other.readOnly() != null && !other.readOnly().equals(this.readOnly())) {
            return false;
        }
        if (other.sourceVolume() == null ^ this.sourceVolume() == null) {
            return false;
        }
        if (other.sourceVolume() != null && !other.sourceVolume().equals(this.sourceVolume())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (containerPath() != null) {
            sb.append("ContainerPath: ").append(containerPath()).append(",");
        }
        if (readOnly() != null) {
            sb.append("ReadOnly: ").append(readOnly()).append(",");
        }
        if (sourceVolume() != null) {
            sb.append("SourceVolume: ").append(sourceVolume()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerPath":
            return Optional.of(clazz.cast(containerPath()));
        case "readOnly":
            return Optional.of(clazz.cast(readOnly()));
        case "sourceVolume":
            return Optional.of(clazz.cast(sourceVolume()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MountPointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MountPoint> {
        /**
         * <p>
         * The path on the container at which to mount the host volume.
         * </p>
         * 
         * @param containerPath
         *        The path on the container at which to mount the host volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerPath(String containerPath);

        /**
         * <p>
         * If this value is <code>true</code>, the container has read-only access to the volume; otherwise, the
         * container can write to the volume. The default value is <code>false</code>.
         * </p>
         * 
         * @param readOnly
         *        If this value is <code>true</code>, the container has read-only access to the volume; otherwise, the
         *        container can write to the volume. The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnly(Boolean readOnly);

        /**
         * <p>
         * The name of the volume to mount.
         * </p>
         * 
         * @param sourceVolume
         *        The name of the volume to mount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVolume(String sourceVolume);
    }

    static final class BuilderImpl implements Builder {
        private String containerPath;

        private Boolean readOnly;

        private String sourceVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(MountPoint model) {
            containerPath(model.containerPath);
            readOnly(model.readOnly);
            sourceVolume(model.sourceVolume);
        }

        public final String getContainerPath() {
            return containerPath;
        }

        @Override
        public final Builder containerPath(String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        public final void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        public final Boolean getReadOnly() {
            return readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        public final String getSourceVolume() {
            return sourceVolume;
        }

        @Override
        public final Builder sourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
            return this;
        }

        public final void setSourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
        }

        @Override
        public MountPoint build() {
            return new MountPoint(this);
        }
    }
}
