/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterJobDefinitionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RegisterJobDefinitionRequest.Builder, RegisterJobDefinitionRequest> {
    private final String jobDefinitionName;

    private final String type;

    private final Map<String, String> parameters;

    private final ContainerProperties containerProperties;

    private final RetryStrategy retryStrategy;

    private RegisterJobDefinitionRequest(BuilderImpl builder) {
        this.jobDefinitionName = builder.jobDefinitionName;
        this.type = builder.type;
        this.parameters = builder.parameters;
        this.containerProperties = builder.containerProperties;
        this.retryStrategy = builder.retryStrategy;
    }

    /**
     * <p>
     * The name of the job definition to register.
     * </p>
     * 
     * @return The name of the job definition to register.
     */
    public String jobDefinitionName() {
        return jobDefinitionName;
    }

    /**
     * <p>
     * The type of job definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link JobDefinitionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of job definition.
     * @see JobDefinitionType
     */
    public JobDefinitionType type() {
        return JobDefinitionType.fromValue(type);
    }

    /**
     * <p>
     * The type of job definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link JobDefinitionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of job definition.
     * @see JobDefinitionType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * Default parameter substitution placeholders to set in the job definition. Parameters are specified as a key-value
     * pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding parameter defaults from
     * the job definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Default parameter substitution placeholders to set in the job definition. Parameters are specified as a
     *         key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding
     *         parameter defaults from the job definition.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * An object with various properties specific for container-based jobs. This parameter is required if the
     * <code>type</code> parameter is <code>container</code>.
     * </p>
     * 
     * @return An object with various properties specific for container-based jobs. This parameter is required if the
     *         <code>type</code> parameter is <code>container</code>.
     */
    public ContainerProperties containerProperties() {
        return containerProperties;
    }

    /**
     * <p>
     * The retry strategy to use for failed jobs that are submitted with this job definition. Any retry strategy that is
     * specified during a <a>SubmitJob</a> operation overrides the retry strategy defined here.
     * </p>
     * 
     * @return The retry strategy to use for failed jobs that are submitted with this job definition. Any retry strategy
     *         that is specified during a <a>SubmitJob</a> operation overrides the retry strategy defined here.
     */
    public RetryStrategy retryStrategy() {
        return retryStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobDefinitionName() == null) ? 0 : jobDefinitionName().hashCode());
        hashCode = 31 * hashCode + ((typeString() == null) ? 0 : typeString().hashCode());
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((containerProperties() == null) ? 0 : containerProperties().hashCode());
        hashCode = 31 * hashCode + ((retryStrategy() == null) ? 0 : retryStrategy().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterJobDefinitionRequest)) {
            return false;
        }
        RegisterJobDefinitionRequest other = (RegisterJobDefinitionRequest) obj;
        if (other.jobDefinitionName() == null ^ this.jobDefinitionName() == null) {
            return false;
        }
        if (other.jobDefinitionName() != null && !other.jobDefinitionName().equals(this.jobDefinitionName())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.containerProperties() == null ^ this.containerProperties() == null) {
            return false;
        }
        if (other.containerProperties() != null && !other.containerProperties().equals(this.containerProperties())) {
            return false;
        }
        if (other.retryStrategy() == null ^ this.retryStrategy() == null) {
            return false;
        }
        if (other.retryStrategy() != null && !other.retryStrategy().equals(this.retryStrategy())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jobDefinitionName() != null) {
            sb.append("JobDefinitionName: ").append(jobDefinitionName()).append(",");
        }
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (containerProperties() != null) {
            sb.append("ContainerProperties: ").append(containerProperties()).append(",");
        }
        if (retryStrategy() != null) {
            sb.append("RetryStrategy: ").append(retryStrategy()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDefinitionName":
            return Optional.of(clazz.cast(jobDefinitionName()));
        case "type":
            return Optional.of(clazz.cast(typeString()));
        case "parameters":
            return Optional.of(clazz.cast(parameters()));
        case "containerProperties":
            return Optional.of(clazz.cast(containerProperties()));
        case "retryStrategy":
            return Optional.of(clazz.cast(retryStrategy()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RegisterJobDefinitionRequest> {
        /**
         * <p>
         * The name of the job definition to register.
         * </p>
         * 
         * @param jobDefinitionName
         *        The name of the job definition to register.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionName(String jobDefinitionName);

        /**
         * <p>
         * The type of job definition.
         * </p>
         * 
         * @param type
         *        The type of job definition.
         * @see JobDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobDefinitionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of job definition.
         * </p>
         * 
         * @param type
         *        The type of job definition.
         * @see JobDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobDefinitionType
         */
        Builder type(JobDefinitionType type);

        /**
         * <p>
         * Default parameter substitution placeholders to set in the job definition. Parameters are specified as a
         * key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding parameter
         * defaults from the job definition.
         * </p>
         * 
         * @param parameters
         *        Default parameter substitution placeholders to set in the job definition. Parameters are specified as
         *        a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding
         *        parameter defaults from the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * An object with various properties specific for container-based jobs. This parameter is required if the
         * <code>type</code> parameter is <code>container</code>.
         * </p>
         * 
         * @param containerProperties
         *        An object with various properties specific for container-based jobs. This parameter is required if the
         *        <code>type</code> parameter is <code>container</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerProperties(ContainerProperties containerProperties);

        /**
         * <p>
         * The retry strategy to use for failed jobs that are submitted with this job definition. Any retry strategy
         * that is specified during a <a>SubmitJob</a> operation overrides the retry strategy defined here.
         * </p>
         * 
         * @param retryStrategy
         *        The retry strategy to use for failed jobs that are submitted with this job definition. Any retry
         *        strategy that is specified during a <a>SubmitJob</a> operation overrides the retry strategy defined
         *        here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryStrategy(RetryStrategy retryStrategy);
    }

    static final class BuilderImpl implements Builder {
        private String jobDefinitionName;

        private String type;

        private Map<String, String> parameters;

        private ContainerProperties containerProperties;

        private RetryStrategy retryStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterJobDefinitionRequest model) {
            jobDefinitionName(model.jobDefinitionName);
            type(model.type);
            parameters(model.parameters);
            containerProperties(model.containerProperties);
            retryStrategy(model.retryStrategy);
        }

        public final String getJobDefinitionName() {
            return jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(JobDefinitionType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final ContainerProperties.Builder getContainerProperties() {
            return containerProperties != null ? containerProperties.toBuilder() : null;
        }

        @Override
        public final Builder containerProperties(ContainerProperties containerProperties) {
            this.containerProperties = containerProperties;
            return this;
        }

        public final void setContainerProperties(ContainerProperties.BuilderImpl containerProperties) {
            this.containerProperties = containerProperties != null ? containerProperties.build() : null;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return retryStrategy != null ? retryStrategy.toBuilder() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        public RegisterJobDefinitionRequest build() {
            return new RegisterJobDefinitionRequest(this);
        }
    }
}
