/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.UlimitMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>ulimit</code> settings to pass to the container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Ulimit implements StructuredPojo, ToCopyableBuilder<Ulimit.Builder, Ulimit> {
    private final Integer hardLimit;

    private final String name;

    private final Integer softLimit;

    private Ulimit(BuilderImpl builder) {
        this.hardLimit = builder.hardLimit;
        this.name = builder.name;
        this.softLimit = builder.softLimit;
    }

    /**
     * <p>
     * The hard limit for the <code>ulimit</code> type.
     * </p>
     * 
     * @return The hard limit for the <code>ulimit</code> type.
     */
    public Integer hardLimit() {
        return hardLimit;
    }

    /**
     * <p>
     * The <code>type</code> of the <code>ulimit</code>.
     * </p>
     * 
     * @return The <code>type</code> of the <code>ulimit</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The soft limit for the <code>ulimit</code> type.
     * </p>
     * 
     * @return The soft limit for the <code>ulimit</code> type.
     */
    public Integer softLimit() {
        return softLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hardLimit() == null) ? 0 : hardLimit().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((softLimit() == null) ? 0 : softLimit().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ulimit)) {
            return false;
        }
        Ulimit other = (Ulimit) obj;
        if (other.hardLimit() == null ^ this.hardLimit() == null) {
            return false;
        }
        if (other.hardLimit() != null && !other.hardLimit().equals(this.hardLimit())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.softLimit() == null ^ this.softLimit() == null) {
            return false;
        }
        if (other.softLimit() != null && !other.softLimit().equals(this.softLimit())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (hardLimit() != null) {
            sb.append("HardLimit: ").append(hardLimit()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (softLimit() != null) {
            sb.append("SoftLimit: ").append(softLimit()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hardLimit":
            return Optional.of(clazz.cast(hardLimit()));
        case "name":
            return Optional.of(clazz.cast(name()));
        case "softLimit":
            return Optional.of(clazz.cast(softLimit()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UlimitMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Ulimit> {
        /**
         * <p>
         * The hard limit for the <code>ulimit</code> type.
         * </p>
         * 
         * @param hardLimit
         *        The hard limit for the <code>ulimit</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hardLimit(Integer hardLimit);

        /**
         * <p>
         * The <code>type</code> of the <code>ulimit</code>.
         * </p>
         * 
         * @param name
         *        The <code>type</code> of the <code>ulimit</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The soft limit for the <code>ulimit</code> type.
         * </p>
         * 
         * @param softLimit
         *        The soft limit for the <code>ulimit</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softLimit(Integer softLimit);
    }

    static final class BuilderImpl implements Builder {
        private Integer hardLimit;

        private String name;

        private Integer softLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(Ulimit model) {
            hardLimit(model.hardLimit);
            name(model.name);
            softLimit(model.softLimit);
        }

        public final Integer getHardLimit() {
            return hardLimit;
        }

        @Override
        public final Builder hardLimit(Integer hardLimit) {
            this.hardLimit = hardLimit;
            return this;
        }

        public final void setHardLimit(Integer hardLimit) {
            this.hardLimit = hardLimit;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getSoftLimit() {
            return softLimit;
        }

        @Override
        public final Builder softLimit(Integer softLimit) {
            this.softLimit = softLimit;
            return this;
        }

        public final void setSoftLimit(Integer softLimit) {
            this.softLimit = softLimit;
        }

        @Override
        public Ulimit build() {
            return new Ulimit(this);
        }
    }
}
