/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateComputeEnvironmentRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateComputeEnvironmentRequest.Builder, UpdateComputeEnvironmentRequest> {
    private final String computeEnvironment;

    private final String state;

    private final ComputeResourceUpdate computeResources;

    private final String serviceRole;

    private UpdateComputeEnvironmentRequest(BuilderImpl builder) {
        this.computeEnvironment = builder.computeEnvironment;
        this.state = builder.state;
        this.computeResources = builder.computeResources;
        this.serviceRole = builder.serviceRole;
    }

    /**
     * <p>
     * The name or full Amazon Resource Name (ARN) of the compute environment to update.
     * </p>
     * 
     * @return The name or full Amazon Resource Name (ARN) of the compute environment to update.
     */
    public String computeEnvironment() {
        return computeEnvironment;
    }

    /**
     * <p>
     * The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept jobs from
     * a queue and scale in or out automatically based on the workload demand of its associated queues.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CEState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept
     *         jobs from a queue and scale in or out automatically based on the workload demand of its associated
     *         queues.
     * @see CEState
     */
    public CEState state() {
        return CEState.fromValue(state);
    }

    /**
     * <p>
     * The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept jobs from
     * a queue and scale in or out automatically based on the workload demand of its associated queues.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CEState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept
     *         jobs from a queue and scale in or out automatically based on the workload demand of its associated
     *         queues.
     * @see CEState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * Details of the compute resources managed by the compute environment. Required for a managed compute environment.
     * </p>
     * 
     * @return Details of the compute resources managed by the compute environment. Required for a managed compute
     *         environment.
     */
    public ComputeResourceUpdate computeResources() {
        return computeResources;
    }

    /**
     * <p>
     * The name or full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to ECS, Auto
     * Scaling, and EC2 on your behalf.
     * </p>
     * 
     * @return The name or full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to ECS,
     *         Auto Scaling, and EC2 on your behalf.
     */
    public String serviceRole() {
        return serviceRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((computeEnvironment() == null) ? 0 : computeEnvironment().hashCode());
        hashCode = 31 * hashCode + ((stateString() == null) ? 0 : stateString().hashCode());
        hashCode = 31 * hashCode + ((computeResources() == null) ? 0 : computeResources().hashCode());
        hashCode = 31 * hashCode + ((serviceRole() == null) ? 0 : serviceRole().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputeEnvironmentRequest)) {
            return false;
        }
        UpdateComputeEnvironmentRequest other = (UpdateComputeEnvironmentRequest) obj;
        if (other.computeEnvironment() == null ^ this.computeEnvironment() == null) {
            return false;
        }
        if (other.computeEnvironment() != null && !other.computeEnvironment().equals(this.computeEnvironment())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.computeResources() == null ^ this.computeResources() == null) {
            return false;
        }
        if (other.computeResources() != null && !other.computeResources().equals(this.computeResources())) {
            return false;
        }
        if (other.serviceRole() == null ^ this.serviceRole() == null) {
            return false;
        }
        if (other.serviceRole() != null && !other.serviceRole().equals(this.serviceRole())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (computeEnvironment() != null) {
            sb.append("ComputeEnvironment: ").append(computeEnvironment()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (computeResources() != null) {
            sb.append("ComputeResources: ").append(computeResources()).append(",");
        }
        if (serviceRole() != null) {
            sb.append("ServiceRole: ").append(serviceRole()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeEnvironment":
            return Optional.of(clazz.cast(computeEnvironment()));
        case "state":
            return Optional.of(clazz.cast(stateString()));
        case "computeResources":
            return Optional.of(clazz.cast(computeResources()));
        case "serviceRole":
            return Optional.of(clazz.cast(serviceRole()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateComputeEnvironmentRequest> {
        /**
         * <p>
         * The name or full Amazon Resource Name (ARN) of the compute environment to update.
         * </p>
         * 
         * @param computeEnvironment
         *        The name or full Amazon Resource Name (ARN) of the compute environment to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironment(String computeEnvironment);

        /**
         * <p>
         * The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept jobs
         * from a queue and scale in or out automatically based on the workload demand of its associated queues.
         * </p>
         * 
         * @param state
         *        The state of the compute environment. Compute environments in the <code>ENABLED</code> state can
         *        accept jobs from a queue and scale in or out automatically based on the workload demand of its
         *        associated queues.
         * @see CEState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept jobs
         * from a queue and scale in or out automatically based on the workload demand of its associated queues.
         * </p>
         * 
         * @param state
         *        The state of the compute environment. Compute environments in the <code>ENABLED</code> state can
         *        accept jobs from a queue and scale in or out automatically based on the workload demand of its
         *        associated queues.
         * @see CEState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEState
         */
        Builder state(CEState state);

        /**
         * <p>
         * Details of the compute resources managed by the compute environment. Required for a managed compute
         * environment.
         * </p>
         * 
         * @param computeResources
         *        Details of the compute resources managed by the compute environment. Required for a managed compute
         *        environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeResources(ComputeResourceUpdate computeResources);

        /**
         * <p>
         * The name or full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to ECS, Auto
         * Scaling, and EC2 on your behalf.
         * </p>
         * 
         * @param serviceRole
         *        The name or full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to
         *        ECS, Auto Scaling, and EC2 on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);
    }

    static final class BuilderImpl implements Builder {
        private String computeEnvironment;

        private String state;

        private ComputeResourceUpdate computeResources;

        private String serviceRole;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputeEnvironmentRequest model) {
            computeEnvironment(model.computeEnvironment);
            state(model.state);
            computeResources(model.computeResources);
            serviceRole(model.serviceRole);
        }

        public final String getComputeEnvironment() {
            return computeEnvironment;
        }

        @Override
        public final Builder computeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
            return this;
        }

        public final void setComputeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CEState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final ComputeResourceUpdate.Builder getComputeResources() {
            return computeResources != null ? computeResources.toBuilder() : null;
        }

        @Override
        public final Builder computeResources(ComputeResourceUpdate computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        public final void setComputeResources(ComputeResourceUpdate.BuilderImpl computeResources) {
            this.computeResources = computeResources != null ? computeResources.build() : null;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public UpdateComputeEnvironmentRequest build() {
            return new UpdateComputeEnvironmentRequest(this);
        }
    }
}
