/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.VolumeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data volume used in a job's container properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Volume implements StructuredPojo, ToCopyableBuilder<Volume.Builder, Volume> {
    private final Host host;

    private final String name;

    private Volume(BuilderImpl builder) {
        this.host = builder.host;
        this.name = builder.name;
    }

    /**
     * <p>
     * The contents of the <code>host</code> parameter determine whether your data volume persists on the host container
     * instance and where it is stored. If the host parameter is empty, then the Docker daemon assigns a host path for
     * your data volume, but the data is not guaranteed to persist after the containers associated with it stop running.
     * </p>
     * 
     * @return The contents of the <code>host</code> parameter determine whether your data volume persists on the host
     *         container instance and where it is stored. If the host parameter is empty, then the Docker daemon assigns
     *         a host path for your data volume, but the data is not guaranteed to persist after the containers
     *         associated with it stop running.
     */
    public Host host() {
        return host;
    }

    /**
     * <p>
     * The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are
     * allowed. This name is referenced in the <code>sourceVolume</code> parameter of container definition
     * <code>mountPoints</code>.
     * </p>
     * 
     * @return The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores
     *         are allowed. This name is referenced in the <code>sourceVolume</code> parameter of container definition
     *         <code>mountPoints</code>.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((host() == null) ? 0 : host().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume) obj;
        if (other.host() == null ^ this.host() == null) {
            return false;
        }
        if (other.host() != null && !other.host().equals(this.host())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (host() != null) {
            sb.append("Host: ").append(host()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "host":
            return Optional.of(clazz.cast(host()));
        case "name":
            return Optional.of(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VolumeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Volume> {
        /**
         * <p>
         * The contents of the <code>host</code> parameter determine whether your data volume persists on the host
         * container instance and where it is stored. If the host parameter is empty, then the Docker daemon assigns a
         * host path for your data volume, but the data is not guaranteed to persist after the containers associated
         * with it stop running.
         * </p>
         * 
         * @param host
         *        The contents of the <code>host</code> parameter determine whether your data volume persists on the
         *        host container instance and where it is stored. If the host parameter is empty, then the Docker daemon
         *        assigns a host path for your data volume, but the data is not guaranteed to persist after the
         *        containers associated with it stop running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(Host host);

        /**
         * <p>
         * The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are
         * allowed. This name is referenced in the <code>sourceVolume</code> parameter of container definition
         * <code>mountPoints</code>.
         * </p>
         * 
         * @param name
         *        The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores
         *        are allowed. This name is referenced in the <code>sourceVolume</code> parameter of container
         *        definition <code>mountPoints</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private Host host;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            host(model.host);
            name(model.name);
        }

        public final Host.Builder getHost() {
            return host != null ? host.toBuilder() : null;
        }

        @Override
        public final Builder host(Host host) {
            this.host = host;
            return this;
        }

        public final void setHost(Host.BuilderImpl host) {
            this.host = host != null ? host.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Volume build() {
            return new Volume(this);
        }
    }
}
