/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.batch.model.KeyValuePair;
import software.amazon.awssdk.services.batch.model.MountPoint;
import software.amazon.awssdk.services.batch.model.MountPointsCopier;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.services.batch.model.Ulimit;
import software.amazon.awssdk.services.batch.model.UlimitsCopier;
import software.amazon.awssdk.services.batch.model.Volume;
import software.amazon.awssdk.services.batch.model.VolumesCopier;
import software.amazon.awssdk.services.batch.transform.ContainerDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ContainerDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, ContainerDetail> {
    private final String image;
    private final Integer vcpus;
    private final Integer memory;
    private final List<String> command;
    private final String jobRoleArn;
    private final List<Volume> volumes;
    private final List<KeyValuePair> environment;
    private final List<MountPoint> mountPoints;
    private final Boolean readonlyRootFilesystem;
    private final List<Ulimit> ulimits;
    private final Boolean privileged;
    private final String user;
    private final Integer exitCode;
    private final String reason;
    private final String containerInstanceArn;
    private final String taskArn;
    private final String logStreamName;

    private ContainerDetail(BuilderImpl builder) {
        this.image = builder.image;
        this.vcpus = builder.vcpus;
        this.memory = builder.memory;
        this.command = builder.command;
        this.jobRoleArn = builder.jobRoleArn;
        this.volumes = builder.volumes;
        this.environment = builder.environment;
        this.mountPoints = builder.mountPoints;
        this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
        this.ulimits = builder.ulimits;
        this.privileged = builder.privileged;
        this.user = builder.user;
        this.exitCode = builder.exitCode;
        this.reason = builder.reason;
        this.containerInstanceArn = builder.containerInstanceArn;
        this.taskArn = builder.taskArn;
        this.logStreamName = builder.logStreamName;
    }

    public String image() {
        return this.image;
    }

    public Integer vcpus() {
        return this.vcpus;
    }

    public Integer memory() {
        return this.memory;
    }

    public List<String> command() {
        return this.command;
    }

    public String jobRoleArn() {
        return this.jobRoleArn;
    }

    public List<Volume> volumes() {
        return this.volumes;
    }

    public List<KeyValuePair> environment() {
        return this.environment;
    }

    public List<MountPoint> mountPoints() {
        return this.mountPoints;
    }

    public Boolean readonlyRootFilesystem() {
        return this.readonlyRootFilesystem;
    }

    public List<Ulimit> ulimits() {
        return this.ulimits;
    }

    public Boolean privileged() {
        return this.privileged;
    }

    public String user() {
        return this.user;
    }

    public Integer exitCode() {
        return this.exitCode;
    }

    public String reason() {
        return this.reason;
    }

    public String containerInstanceArn() {
        return this.containerInstanceArn;
    }

    public String taskArn() {
        return this.taskArn;
    }

    public String logStreamName() {
        return this.logStreamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.image() == null ? 0 : this.image().hashCode());
        hashCode = 31 * hashCode + (this.vcpus() == null ? 0 : this.vcpus().hashCode());
        hashCode = 31 * hashCode + (this.memory() == null ? 0 : this.memory().hashCode());
        hashCode = 31 * hashCode + (this.command() == null ? 0 : this.command().hashCode());
        hashCode = 31 * hashCode + (this.jobRoleArn() == null ? 0 : this.jobRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.volumes() == null ? 0 : this.volumes().hashCode());
        hashCode = 31 * hashCode + (this.environment() == null ? 0 : this.environment().hashCode());
        hashCode = 31 * hashCode + (this.mountPoints() == null ? 0 : this.mountPoints().hashCode());
        hashCode = 31 * hashCode + (this.readonlyRootFilesystem() == null ? 0 : this.readonlyRootFilesystem().hashCode());
        hashCode = 31 * hashCode + (this.ulimits() == null ? 0 : this.ulimits().hashCode());
        hashCode = 31 * hashCode + (this.privileged() == null ? 0 : this.privileged().hashCode());
        hashCode = 31 * hashCode + (this.user() == null ? 0 : this.user().hashCode());
        hashCode = 31 * hashCode + (this.exitCode() == null ? 0 : this.exitCode().hashCode());
        hashCode = 31 * hashCode + (this.reason() == null ? 0 : this.reason().hashCode());
        hashCode = 31 * hashCode + (this.containerInstanceArn() == null ? 0 : this.containerInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.taskArn() == null ? 0 : this.taskArn().hashCode());
        hashCode = 31 * hashCode + (this.logStreamName() == null ? 0 : this.logStreamName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDetail)) {
            return false;
        }
        ContainerDetail other = (ContainerDetail)obj;
        if (other.image() == null ^ this.image() == null) {
            return false;
        }
        if (other.image() != null && !other.image().equals(this.image())) {
            return false;
        }
        if (other.vcpus() == null ^ this.vcpus() == null) {
            return false;
        }
        if (other.vcpus() != null && !other.vcpus().equals(this.vcpus())) {
            return false;
        }
        if (other.memory() == null ^ this.memory() == null) {
            return false;
        }
        if (other.memory() != null && !other.memory().equals(this.memory())) {
            return false;
        }
        if (other.command() == null ^ this.command() == null) {
            return false;
        }
        if (other.command() != null && !other.command().equals(this.command())) {
            return false;
        }
        if (other.jobRoleArn() == null ^ this.jobRoleArn() == null) {
            return false;
        }
        if (other.jobRoleArn() != null && !other.jobRoleArn().equals(this.jobRoleArn())) {
            return false;
        }
        if (other.volumes() == null ^ this.volumes() == null) {
            return false;
        }
        if (other.volumes() != null && !other.volumes().equals(this.volumes())) {
            return false;
        }
        if (other.environment() == null ^ this.environment() == null) {
            return false;
        }
        if (other.environment() != null && !other.environment().equals(this.environment())) {
            return false;
        }
        if (other.mountPoints() == null ^ this.mountPoints() == null) {
            return false;
        }
        if (other.mountPoints() != null && !other.mountPoints().equals(this.mountPoints())) {
            return false;
        }
        if (other.readonlyRootFilesystem() == null ^ this.readonlyRootFilesystem() == null) {
            return false;
        }
        if (other.readonlyRootFilesystem() != null && !other.readonlyRootFilesystem().equals(this.readonlyRootFilesystem())) {
            return false;
        }
        if (other.ulimits() == null ^ this.ulimits() == null) {
            return false;
        }
        if (other.ulimits() != null && !other.ulimits().equals(this.ulimits())) {
            return false;
        }
        if (other.privileged() == null ^ this.privileged() == null) {
            return false;
        }
        if (other.privileged() != null && !other.privileged().equals(this.privileged())) {
            return false;
        }
        if (other.user() == null ^ this.user() == null) {
            return false;
        }
        if (other.user() != null && !other.user().equals(this.user())) {
            return false;
        }
        if (other.exitCode() == null ^ this.exitCode() == null) {
            return false;
        }
        if (other.exitCode() != null && !other.exitCode().equals(this.exitCode())) {
            return false;
        }
        if (other.reason() == null ^ this.reason() == null) {
            return false;
        }
        if (other.reason() != null && !other.reason().equals(this.reason())) {
            return false;
        }
        if (other.containerInstanceArn() == null ^ this.containerInstanceArn() == null) {
            return false;
        }
        if (other.containerInstanceArn() != null && !other.containerInstanceArn().equals(this.containerInstanceArn())) {
            return false;
        }
        if (other.taskArn() == null ^ this.taskArn() == null) {
            return false;
        }
        if (other.taskArn() != null && !other.taskArn().equals(this.taskArn())) {
            return false;
        }
        if (other.logStreamName() == null ^ this.logStreamName() == null) {
            return false;
        }
        return other.logStreamName() == null || other.logStreamName().equals(this.logStreamName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.image() != null) {
            sb.append("Image: ").append(this.image()).append(",");
        }
        if (this.vcpus() != null) {
            sb.append("Vcpus: ").append(this.vcpus()).append(",");
        }
        if (this.memory() != null) {
            sb.append("Memory: ").append(this.memory()).append(",");
        }
        if (this.command() != null) {
            sb.append("Command: ").append(this.command()).append(",");
        }
        if (this.jobRoleArn() != null) {
            sb.append("JobRoleArn: ").append(this.jobRoleArn()).append(",");
        }
        if (this.volumes() != null) {
            sb.append("Volumes: ").append(this.volumes()).append(",");
        }
        if (this.environment() != null) {
            sb.append("Environment: ").append(this.environment()).append(",");
        }
        if (this.mountPoints() != null) {
            sb.append("MountPoints: ").append(this.mountPoints()).append(",");
        }
        if (this.readonlyRootFilesystem() != null) {
            sb.append("ReadonlyRootFilesystem: ").append(this.readonlyRootFilesystem()).append(",");
        }
        if (this.ulimits() != null) {
            sb.append("Ulimits: ").append(this.ulimits()).append(",");
        }
        if (this.privileged() != null) {
            sb.append("Privileged: ").append(this.privileged()).append(",");
        }
        if (this.user() != null) {
            sb.append("User: ").append(this.user()).append(",");
        }
        if (this.exitCode() != null) {
            sb.append("ExitCode: ").append(this.exitCode()).append(",");
        }
        if (this.reason() != null) {
            sb.append("Reason: ").append(this.reason()).append(",");
        }
        if (this.containerInstanceArn() != null) {
            sb.append("ContainerInstanceArn: ").append(this.containerInstanceArn()).append(",");
        }
        if (this.taskArn() != null) {
            sb.append("TaskArn: ").append(this.taskArn()).append(",");
        }
        if (this.logStreamName() != null) {
            sb.append("LogStreamName: ").append(this.logStreamName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "image": {
                return Optional.of(clazz.cast(this.image()));
            }
            case "vcpus": {
                return Optional.of(clazz.cast(this.vcpus()));
            }
            case "memory": {
                return Optional.of(clazz.cast(this.memory()));
            }
            case "command": {
                return Optional.of(clazz.cast(this.command()));
            }
            case "jobRoleArn": {
                return Optional.of(clazz.cast(this.jobRoleArn()));
            }
            case "volumes": {
                return Optional.of(clazz.cast(this.volumes()));
            }
            case "environment": {
                return Optional.of(clazz.cast(this.environment()));
            }
            case "mountPoints": {
                return Optional.of(clazz.cast(this.mountPoints()));
            }
            case "readonlyRootFilesystem": {
                return Optional.of(clazz.cast(this.readonlyRootFilesystem()));
            }
            case "ulimits": {
                return Optional.of(clazz.cast(this.ulimits()));
            }
            case "privileged": {
                return Optional.of(clazz.cast(this.privileged()));
            }
            case "user": {
                return Optional.of(clazz.cast(this.user()));
            }
            case "exitCode": {
                return Optional.of(clazz.cast(this.exitCode()));
            }
            case "reason": {
                return Optional.of(clazz.cast(this.reason()));
            }
            case "containerInstanceArn": {
                return Optional.of(clazz.cast(this.containerInstanceArn()));
            }
            case "taskArn": {
                return Optional.of(clazz.cast(this.taskArn()));
            }
            case "logStreamName": {
                return Optional.of(clazz.cast(this.logStreamName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String image;
        private Integer vcpus;
        private Integer memory;
        private List<String> command;
        private String jobRoleArn;
        private List<Volume> volumes;
        private List<KeyValuePair> environment;
        private List<MountPoint> mountPoints;
        private Boolean readonlyRootFilesystem;
        private List<Ulimit> ulimits;
        private Boolean privileged;
        private String user;
        private Integer exitCode;
        private String reason;
        private String containerInstanceArn;
        private String taskArn;
        private String logStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDetail model) {
            this.image(model.image);
            this.vcpus(model.vcpus);
            this.memory(model.memory);
            this.command(model.command);
            this.jobRoleArn(model.jobRoleArn);
            this.volumes(model.volumes);
            this.environment(model.environment);
            this.mountPoints(model.mountPoints);
            this.readonlyRootFilesystem(model.readonlyRootFilesystem);
            this.ulimits(model.ulimits);
            this.privileged(model.privileged);
            this.user(model.user);
            this.exitCode(model.exitCode);
            this.reason(model.reason);
            this.containerInstanceArn(model.containerInstanceArn);
            this.taskArn(model.taskArn);
            this.logStreamName(model.logStreamName);
        }

        public final String getImage() {
            return this.image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final Integer getVcpus() {
            return this.vcpus;
        }

        @Override
        public final Builder vcpus(Integer vcpus) {
            this.vcpus = vcpus;
            return this;
        }

        public final void setVcpus(Integer vcpus) {
            this.vcpus = vcpus;
        }

        public final Integer getMemory() {
            return this.memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        public final Collection<String> getCommand() {
            return this.command;
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        public final String getJobRoleArn() {
            return this.jobRoleArn;
        }

        @Override
        public final Builder jobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
            return this;
        }

        public final void setJobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
        }

        public final Collection<Volume.Builder> getVolumes() {
            return this.volumes != null ? (Collection)this.volumes.stream().map(Volume::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumesCopier.copyFromBuilder(volumes);
        }

        public final Collection<KeyValuePair.Builder> getEnvironment() {
            return this.environment != null ? (Collection)this.environment.stream().map(KeyValuePair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environment(Collection<KeyValuePair> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(KeyValuePair ... environment) {
            this.environment(Arrays.asList(environment));
            return this;
        }

        public final void setEnvironment(Collection<KeyValuePair.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        public final Collection<MountPoint.Builder> getMountPoints() {
            return this.mountPoints != null ? (Collection)this.mountPoints.stream().map(MountPoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mountPoints(Collection<MountPoint> mountPoints) {
            this.mountPoints = MountPointsCopier.copy(mountPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(MountPoint ... mountPoints) {
            this.mountPoints(Arrays.asList(mountPoints));
            return this;
        }

        public final void setMountPoints(Collection<MountPoint.BuilderImpl> mountPoints) {
            this.mountPoints = MountPointsCopier.copyFromBuilder(mountPoints);
        }

        public final Boolean getReadonlyRootFilesystem() {
            return this.readonlyRootFilesystem;
        }

        @Override
        public final Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        public final void setReadonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
        }

        public final Collection<Ulimit.Builder> getUlimits() {
            return this.ulimits != null ? (Collection)this.ulimits.stream().map(Ulimit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ulimits(Collection<Ulimit> ulimits) {
            this.ulimits = UlimitsCopier.copy(ulimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ulimits(Ulimit ... ulimits) {
            this.ulimits(Arrays.asList(ulimits));
            return this;
        }

        public final void setUlimits(Collection<Ulimit.BuilderImpl> ulimits) {
            this.ulimits = UlimitsCopier.copyFromBuilder(ulimits);
        }

        public final Boolean getPrivileged() {
            return this.privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        public final String getUser() {
            return this.user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        public final Integer getExitCode() {
            return this.exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getContainerInstanceArn() {
            return this.containerInstanceArn;
        }

        @Override
        public final Builder containerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
            return this;
        }

        public final void setContainerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public ContainerDetail build() {
            return new ContainerDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ContainerDetail> {
        public Builder image(String var1);

        public Builder vcpus(Integer var1);

        public Builder memory(Integer var1);

        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);

        public Builder jobRoleArn(String var1);

        public Builder volumes(Collection<Volume> var1);

        public Builder volumes(Volume ... var1);

        public Builder environment(Collection<KeyValuePair> var1);

        public Builder environment(KeyValuePair ... var1);

        public Builder mountPoints(Collection<MountPoint> var1);

        public Builder mountPoints(MountPoint ... var1);

        public Builder readonlyRootFilesystem(Boolean var1);

        public Builder ulimits(Collection<Ulimit> var1);

        public Builder ulimits(Ulimit ... var1);

        public Builder privileged(Boolean var1);

        public Builder user(String var1);

        public Builder exitCode(Integer var1);

        public Builder reason(String var1);

        public Builder containerInstanceArn(String var1);

        public Builder taskArn(String var1);

        public Builder logStreamName(String var1);
    }
}

