/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrder;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrdersCopier;
import software.amazon.awssdk.services.batch.model.JQState;
import software.amazon.awssdk.services.batch.model.JQStatus;
import software.amazon.awssdk.services.batch.transform.JobQueueDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobQueueDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, JobQueueDetail> {
    private final String jobQueueName;
    private final String jobQueueArn;
    private final String state;
    private final String status;
    private final String statusReason;
    private final Integer priority;
    private final List<ComputeEnvironmentOrder> computeEnvironmentOrder;

    private JobQueueDetail(BuilderImpl builder) {
        this.jobQueueName = builder.jobQueueName;
        this.jobQueueArn = builder.jobQueueArn;
        this.state = builder.state;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.priority = builder.priority;
        this.computeEnvironmentOrder = builder.computeEnvironmentOrder;
    }

    public String jobQueueName() {
        return this.jobQueueName;
    }

    public String jobQueueArn() {
        return this.jobQueueArn;
    }

    public JQState state() {
        return JQState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public JQStatus status() {
        return JQStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public Integer priority() {
        return this.priority;
    }

    public List<ComputeEnvironmentOrder> computeEnvironmentOrder() {
        return this.computeEnvironmentOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobQueueName() == null ? 0 : this.jobQueueName().hashCode());
        hashCode = 31 * hashCode + (this.jobQueueArn() == null ? 0 : this.jobQueueArn().hashCode());
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.statusReason() == null ? 0 : this.statusReason().hashCode());
        hashCode = 31 * hashCode + (this.priority() == null ? 0 : this.priority().hashCode());
        hashCode = 31 * hashCode + (this.computeEnvironmentOrder() == null ? 0 : this.computeEnvironmentOrder().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobQueueDetail)) {
            return false;
        }
        JobQueueDetail other = (JobQueueDetail)obj;
        if (other.jobQueueName() == null ^ this.jobQueueName() == null) {
            return false;
        }
        if (other.jobQueueName() != null && !other.jobQueueName().equals(this.jobQueueName())) {
            return false;
        }
        if (other.jobQueueArn() == null ^ this.jobQueueArn() == null) {
            return false;
        }
        if (other.jobQueueArn() != null && !other.jobQueueArn().equals(this.jobQueueArn())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.statusReason() == null ^ this.statusReason() == null) {
            return false;
        }
        if (other.statusReason() != null && !other.statusReason().equals(this.statusReason())) {
            return false;
        }
        if (other.priority() == null ^ this.priority() == null) {
            return false;
        }
        if (other.priority() != null && !other.priority().equals(this.priority())) {
            return false;
        }
        if (other.computeEnvironmentOrder() == null ^ this.computeEnvironmentOrder() == null) {
            return false;
        }
        return other.computeEnvironmentOrder() == null || other.computeEnvironmentOrder().equals(this.computeEnvironmentOrder());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobQueueName() != null) {
            sb.append("JobQueueName: ").append(this.jobQueueName()).append(",");
        }
        if (this.jobQueueArn() != null) {
            sb.append("JobQueueArn: ").append(this.jobQueueArn()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.statusReason() != null) {
            sb.append("StatusReason: ").append(this.statusReason()).append(",");
        }
        if (this.priority() != null) {
            sb.append("Priority: ").append(this.priority()).append(",");
        }
        if (this.computeEnvironmentOrder() != null) {
            sb.append("ComputeEnvironmentOrder: ").append(this.computeEnvironmentOrder()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobQueueName": {
                return Optional.of(clazz.cast(this.jobQueueName()));
            }
            case "jobQueueArn": {
                return Optional.of(clazz.cast(this.jobQueueArn()));
            }
            case "state": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "statusReason": {
                return Optional.of(clazz.cast(this.statusReason()));
            }
            case "priority": {
                return Optional.of(clazz.cast(this.priority()));
            }
            case "computeEnvironmentOrder": {
                return Optional.of(clazz.cast(this.computeEnvironmentOrder()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobQueueDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobQueueName;
        private String jobQueueArn;
        private String state;
        private String status;
        private String statusReason;
        private Integer priority;
        private List<ComputeEnvironmentOrder> computeEnvironmentOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(JobQueueDetail model) {
            this.jobQueueName(model.jobQueueName);
            this.jobQueueArn(model.jobQueueArn);
            this.state(model.state);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.priority(model.priority);
            this.computeEnvironmentOrder(model.computeEnvironmentOrder);
        }

        public final String getJobQueueName() {
            return this.jobQueueName;
        }

        @Override
        public final Builder jobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
            return this;
        }

        public final void setJobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
        }

        public final String getJobQueueArn() {
            return this.jobQueueArn;
        }

        @Override
        public final Builder jobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
            return this;
        }

        public final void setJobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JQState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JQStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<ComputeEnvironmentOrder.Builder> getComputeEnvironmentOrder() {
            return this.computeEnvironmentOrder != null ? (Collection)this.computeEnvironmentOrder.stream().map(ComputeEnvironmentOrder::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironmentOrder(ComputeEnvironmentOrder ... computeEnvironmentOrder) {
            this.computeEnvironmentOrder(Arrays.asList(computeEnvironmentOrder));
            return this;
        }

        public final void setComputeEnvironmentOrder(Collection<ComputeEnvironmentOrder.BuilderImpl> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copyFromBuilder(computeEnvironmentOrder);
        }

        public JobQueueDetail build() {
            return new JobQueueDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobQueueDetail> {
        public Builder jobQueueName(String var1);

        public Builder jobQueueArn(String var1);

        public Builder state(String var1);

        public Builder state(JQState var1);

        public Builder status(String var1);

        public Builder status(JQStatus var1);

        public Builder statusReason(String var1);

        public Builder priority(Integer var1);

        public Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> var1);

        public Builder computeEnvironmentOrder(ComputeEnvironmentOrder ... var1);
    }
}

