/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.ComputeResourceUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the attributes of a compute environment that can be updated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ComputeResourceUpdate implements StructuredPojo,
        ToCopyableBuilder<ComputeResourceUpdate.Builder, ComputeResourceUpdate> {
    private final Integer minvCpus;

    private final Integer maxvCpus;

    private final Integer desiredvCpus;

    private ComputeResourceUpdate(BuilderImpl builder) {
        this.minvCpus = builder.minvCpus;
        this.maxvCpus = builder.maxvCpus;
        this.desiredvCpus = builder.desiredvCpus;
    }

    /**
     * <p>
     * The minimum number of EC2 vCPUs that an environment should maintain.
     * </p>
     * 
     * @return The minimum number of EC2 vCPUs that an environment should maintain.
     */
    public Integer minvCpus() {
        return minvCpus;
    }

    /**
     * <p>
     * The maximum number of EC2 vCPUs that an environment can reach.
     * </p>
     * 
     * @return The maximum number of EC2 vCPUs that an environment can reach.
     */
    public Integer maxvCpus() {
        return maxvCpus;
    }

    /**
     * <p>
     * The desired number of EC2 vCPUS in the compute environment.
     * </p>
     * 
     * @return The desired number of EC2 vCPUS in the compute environment.
     */
    public Integer desiredvCpus() {
        return desiredvCpus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(maxvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(desiredvCpus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeResourceUpdate)) {
            return false;
        }
        ComputeResourceUpdate other = (ComputeResourceUpdate) obj;
        return Objects.equals(minvCpus(), other.minvCpus()) && Objects.equals(maxvCpus(), other.maxvCpus())
                && Objects.equals(desiredvCpus(), other.desiredvCpus());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (minvCpus() != null) {
            sb.append("MinvCpus: ").append(minvCpus()).append(",");
        }
        if (maxvCpus() != null) {
            sb.append("MaxvCpus: ").append(maxvCpus()).append(",");
        }
        if (desiredvCpus() != null) {
            sb.append("DesiredvCpus: ").append(desiredvCpus()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "minvCpus":
            return Optional.of(clazz.cast(minvCpus()));
        case "maxvCpus":
            return Optional.of(clazz.cast(maxvCpus()));
        case "desiredvCpus":
            return Optional.of(clazz.cast(desiredvCpus()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComputeResourceUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ComputeResourceUpdate> {
        /**
         * <p>
         * The minimum number of EC2 vCPUs that an environment should maintain.
         * </p>
         * 
         * @param minvCpus
         *        The minimum number of EC2 vCPUs that an environment should maintain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minvCpus(Integer minvCpus);

        /**
         * <p>
         * The maximum number of EC2 vCPUs that an environment can reach.
         * </p>
         * 
         * @param maxvCpus
         *        The maximum number of EC2 vCPUs that an environment can reach.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxvCpus(Integer maxvCpus);

        /**
         * <p>
         * The desired number of EC2 vCPUS in the compute environment.
         * </p>
         * 
         * @param desiredvCpus
         *        The desired number of EC2 vCPUS in the compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredvCpus(Integer desiredvCpus);
    }

    static final class BuilderImpl implements Builder {
        private Integer minvCpus;

        private Integer maxvCpus;

        private Integer desiredvCpus;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeResourceUpdate model) {
            minvCpus(model.minvCpus);
            maxvCpus(model.maxvCpus);
            desiredvCpus(model.desiredvCpus);
        }

        public final Integer getMinvCpus() {
            return minvCpus;
        }

        @Override
        public final Builder minvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
            return this;
        }

        public final void setMinvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
        }

        public final Integer getMaxvCpus() {
            return maxvCpus;
        }

        @Override
        public final Builder maxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
            return this;
        }

        public final void setMaxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
        }

        public final Integer getDesiredvCpus() {
            return desiredvCpus;
        }

        @Override
        public final Builder desiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
            return this;
        }

        public final void setDesiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
        }

        @Override
        public ComputeResourceUpdate build() {
            return new ComputeResourceUpdate(this);
        }
    }
}
