/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeJobDefinitionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeJobDefinitionsRequest.Builder, DescribeJobDefinitionsRequest> {
    private final List<String> jobDefinitions;

    private final Integer maxResults;

    private final String jobDefinitionName;

    private final String status;

    private final String nextToken;

    private DescribeJobDefinitionsRequest(BuilderImpl builder) {
        this.jobDefinitions = builder.jobDefinitions;
        this.maxResults = builder.maxResults;
        this.jobDefinitionName = builder.jobDefinitionName;
        this.status = builder.status;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A space-separated list of up to 100 job definition names or full Amazon Resource Name (ARN) entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A space-separated list of up to 100 job definition names or full Amazon Resource Name (ARN) entries.
     */
    public List<String> jobDefinitions() {
        return jobDefinitions;
    }

    /**
     * <p>
     * The maximum number of results returned by <code>DescribeJobDefinitions</code> in paginated output. When this
     * parameter is used, <code>DescribeJobDefinitions</code> only returns <code>maxResults</code> results in a single
     * page along with a <code>nextToken</code> response element. The remaining results of the initial request can be
     * seen by sending another <code>DescribeJobDefinitions</code> request with the returned <code>nextToken</code>
     * value. This value can be between 1 and 100. If this parameter is not used, then
     * <code>DescribeJobDefinitions</code> returns up to 100 results and a <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of results returned by <code>DescribeJobDefinitions</code> in paginated output. When
     *         this parameter is used, <code>DescribeJobDefinitions</code> only returns <code>maxResults</code> results
     *         in a single page along with a <code>nextToken</code> response element. The remaining results of the
     *         initial request can be seen by sending another <code>DescribeJobDefinitions</code> request with the
     *         returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not
     *         used, then <code>DescribeJobDefinitions</code> returns up to 100 results and a <code>nextToken</code>
     *         value if applicable.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The name of the job definition to describe.
     * </p>
     * 
     * @return The name of the job definition to describe.
     */
    public String jobDefinitionName() {
        return jobDefinitionName;
    }

    /**
     * <p>
     * The status with which to filter job definitions.
     * </p>
     * 
     * @return The status with which to filter job definitions.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobDefinitions</code> request
     * where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues
     * from the end of the previous results that returned the <code>nextToken</code> value. This value is
     * <code>null</code> when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobDefinitions</code>
     *         request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
     *         Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
     *         This value is <code>null</code> when there are no more results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobDefinitionsRequest)) {
            return false;
        }
        DescribeJobDefinitionsRequest other = (DescribeJobDefinitionsRequest) obj;
        return Objects.equals(jobDefinitions(), other.jobDefinitions()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(jobDefinitionName(), other.jobDefinitionName()) && Objects.equals(status(), other.status())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jobDefinitions() != null) {
            sb.append("JobDefinitions: ").append(jobDefinitions()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (jobDefinitionName() != null) {
            sb.append("JobDefinitionName: ").append(jobDefinitionName()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDefinitions":
            return Optional.of(clazz.cast(jobDefinitions()));
        case "maxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "jobDefinitionName":
            return Optional.of(clazz.cast(jobDefinitionName()));
        case "status":
            return Optional.of(clazz.cast(status()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeJobDefinitionsRequest> {
        /**
         * <p>
         * A space-separated list of up to 100 job definition names or full Amazon Resource Name (ARN) entries.
         * </p>
         * 
         * @param jobDefinitions
         *        A space-separated list of up to 100 job definition names or full Amazon Resource Name (ARN) entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitions(Collection<String> jobDefinitions);

        /**
         * <p>
         * A space-separated list of up to 100 job definition names or full Amazon Resource Name (ARN) entries.
         * </p>
         * 
         * @param jobDefinitions
         *        A space-separated list of up to 100 job definition names or full Amazon Resource Name (ARN) entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitions(String... jobDefinitions);

        /**
         * <p>
         * The maximum number of results returned by <code>DescribeJobDefinitions</code> in paginated output. When this
         * parameter is used, <code>DescribeJobDefinitions</code> only returns <code>maxResults</code> results in a
         * single page along with a <code>nextToken</code> response element. The remaining results of the initial
         * request can be seen by sending another <code>DescribeJobDefinitions</code> request with the returned
         * <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then
         * <code>DescribeJobDefinitions</code> returns up to 100 results and a <code>nextToken</code> value if
         * applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results returned by <code>DescribeJobDefinitions</code> in paginated output.
         *        When this parameter is used, <code>DescribeJobDefinitions</code> only returns <code>maxResults</code>
         *        results in a single page along with a <code>nextToken</code> response element. The remaining results
         *        of the initial request can be seen by sending another <code>DescribeJobDefinitions</code> request with
         *        the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is
         *        not used, then <code>DescribeJobDefinitions</code> returns up to 100 results and a
         *        <code>nextToken</code> value if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The name of the job definition to describe.
         * </p>
         * 
         * @param jobDefinitionName
         *        The name of the job definition to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionName(String jobDefinitionName);

        /**
         * <p>
         * The status with which to filter job definitions.
         * </p>
         * 
         * @param status
         *        The status with which to filter job definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobDefinitions</code>
         * request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         * Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
         * This value is <code>null</code> when there are no more results to return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated
         *        <code>DescribeJobDefinitions</code> request where <code>maxResults</code> was used and the results
         *        exceeded the value of that parameter. Pagination continues from the end of the previous results that
         *        returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more
         *        results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<String> jobDefinitions;

        private Integer maxResults;

        private String jobDefinitionName;

        private String status;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobDefinitionsRequest model) {
            jobDefinitions(model.jobDefinitions);
            maxResults(model.maxResults);
            jobDefinitionName(model.jobDefinitionName);
            status(model.status);
            nextToken(model.nextToken);
        }

        public final Collection<String> getJobDefinitions() {
            return jobDefinitions;
        }

        @Override
        public final Builder jobDefinitions(Collection<String> jobDefinitions) {
            this.jobDefinitions = StringListCopier.copy(jobDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobDefinitions(String... jobDefinitions) {
            jobDefinitions(Arrays.asList(jobDefinitions));
            return this;
        }

        public final void setJobDefinitions(Collection<String> jobDefinitions) {
            this.jobDefinitions = StringListCopier.copy(jobDefinitions);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getJobDefinitionName() {
            return jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeJobDefinitionsRequest build() {
            return new DescribeJobDefinitionsRequest(this);
        }
    }
}
