/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeJobsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeJobsRequest.Builder, DescribeJobsRequest> {
    private final List<String> jobs;

    private DescribeJobsRequest(BuilderImpl builder) {
        this.jobs = builder.jobs;
    }

    /**
     * <p>
     * A space-separated list of up to 100 job IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A space-separated list of up to 100 job IDs.
     */
    public List<String> jobs() {
        return jobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobsRequest)) {
            return false;
        }
        DescribeJobsRequest other = (DescribeJobsRequest) obj;
        return Objects.equals(jobs(), other.jobs());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jobs() != null) {
            sb.append("Jobs: ").append(jobs()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobs":
            return Optional.of(clazz.cast(jobs()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeJobsRequest> {
        /**
         * <p>
         * A space-separated list of up to 100 job IDs.
         * </p>
         * 
         * @param jobs
         *        A space-separated list of up to 100 job IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Collection<String> jobs);

        /**
         * <p>
         * A space-separated list of up to 100 job IDs.
         * </p>
         * 
         * @param jobs
         *        A space-separated list of up to 100 job IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(String... jobs);
    }

    static final class BuilderImpl implements Builder {
        private List<String> jobs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobsRequest model) {
            jobs(model.jobs);
        }

        public final Collection<String> getJobs() {
            return jobs;
        }

        @Override
        public final Builder jobs(Collection<String> jobs) {
            this.jobs = StringListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(String... jobs) {
            jobs(Arrays.asList(jobs));
            return this;
        }

        public final void setJobs(Collection<String> jobs) {
            this.jobs = StringListCopier.copy(jobs);
        }

        @Override
        public DescribeJobsRequest build() {
            return new DescribeJobsRequest(this);
        }
    }
}
