/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.JobDependencyMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an AWS Batch job dependency.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class JobDependency implements StructuredPojo, ToCopyableBuilder<JobDependency.Builder, JobDependency> {
    private final String jobId;

    private JobDependency(BuilderImpl builder) {
        this.jobId = builder.jobId;
    }

    /**
     * <p>
     * The job ID of the AWS Batch job associated with this dependency.
     * </p>
     * 
     * @return The job ID of the AWS Batch job associated with this dependency.
     */
    public String jobId() {
        return jobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDependency)) {
            return false;
        }
        JobDependency other = (JobDependency) obj;
        return Objects.equals(jobId(), other.jobId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jobId() != null) {
            sb.append("JobId: ").append(jobId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.of(clazz.cast(jobId()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobDependencyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, JobDependency> {
        /**
         * <p>
         * The job ID of the AWS Batch job associated with this dependency.
         * </p>
         * 
         * @param jobId
         *        The job ID of the AWS Batch job associated with this dependency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDependency model) {
            jobId(model.jobId);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public JobDependency build() {
            return new JobDependency(this);
        }
    }
}
