/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.JobDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an AWS Batch job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class JobDetail implements StructuredPojo, ToCopyableBuilder<JobDetail.Builder, JobDetail> {
    private final String jobName;

    private final String jobId;

    private final String jobQueue;

    private final String status;

    private final List<AttemptDetail> attempts;

    private final String statusReason;

    private final Long createdAt;

    private final RetryStrategy retryStrategy;

    private final Long startedAt;

    private final Long stoppedAt;

    private final List<JobDependency> dependsOn;

    private final String jobDefinition;

    private final Map<String, String> parameters;

    private final ContainerDetail container;

    private JobDetail(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobId = builder.jobId;
        this.jobQueue = builder.jobQueue;
        this.status = builder.status;
        this.attempts = builder.attempts;
        this.statusReason = builder.statusReason;
        this.createdAt = builder.createdAt;
        this.retryStrategy = builder.retryStrategy;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.dependsOn = builder.dependsOn;
        this.jobDefinition = builder.jobDefinition;
        this.parameters = builder.parameters;
        this.container = builder.container;
    }

    /**
     * <p>
     * The name of the job.
     * </p>
     * 
     * @return The name of the job.
     */
    public String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The ID for the job.
     * </p>
     * 
     * @return The ID for the job.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job queue with which the job is associated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job queue with which the job is associated.
     */
    public String jobQueue() {
        return jobQueue;
    }

    /**
     * <p>
     * The current status for the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The current status for the job.
     * @see JobStatus
     */
    public JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status for the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The current status for the job.
     * @see JobStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * A list of job attempts associated with this job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of job attempts associated with this job.
     */
    public List<AttemptDetail> attempts() {
        return attempts;
    }

    /**
     * <p>
     * A short, human-readable string to provide additional details about the current status of the job.
     * </p>
     * 
     * @return A short, human-readable string to provide additional details about the current status of the job.
     */
    public String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The Unix timestamp for when the job was created (when the task entered the <code>PENDING</code> state).
     * </p>
     * 
     * @return The Unix timestamp for when the job was created (when the task entered the <code>PENDING</code> state).
     */
    public Long createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The retry strategy to use for this job if an attempt fails.
     * </p>
     * 
     * @return The retry strategy to use for this job if an attempt fails.
     */
    public RetryStrategy retryStrategy() {
        return retryStrategy;
    }

    /**
     * <p>
     * The Unix timestamp for when the job was started (when the task transitioned from the <code>PENDING</code> state
     * to the <code>RUNNING</code> state).
     * </p>
     * 
     * @return The Unix timestamp for when the job was started (when the task transitioned from the <code>PENDING</code>
     *         state to the <code>RUNNING</code> state).
     */
    public Long startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The Unix timestamp for when the job was stopped (when the task transitioned from the <code>RUNNING</code> state
     * to the <code>STOPPED</code> state).
     * </p>
     * 
     * @return The Unix timestamp for when the job was stopped (when the task transitioned from the <code>RUNNING</code>
     *         state to the <code>STOPPED</code> state).
     */
    public Long stoppedAt() {
        return stoppedAt;
    }

    /**
     * <p>
     * A list of job names or IDs on which this job depends.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of job names or IDs on which this job depends.
     */
    public List<JobDependency> dependsOn() {
        return dependsOn;
    }

    /**
     * <p>
     * The job definition that is used by this job.
     * </p>
     * 
     * @return The job definition that is used by this job.
     */
    public String jobDefinition() {
        return jobDefinition;
    }

    /**
     * <p>
     * Additional parameters passed to the job that replace parameter substitution placeholders or override any
     * corresponding parameter defaults from the job definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Additional parameters passed to the job that replace parameter substitution placeholders or override any
     *         corresponding parameter defaults from the job definition.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * An object representing the details of the container that is associated with the job.
     * </p>
     * 
     * @return An object representing the details of the container that is associated with the job.
     */
    public ContainerDetail container() {
        return container;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        hashCode = 31 * hashCode + Objects.hashCode(attempts());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(dependsOn());
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(container());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetail)) {
            return false;
        }
        JobDetail other = (JobDetail) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(jobQueue(), other.jobQueue()) && Objects.equals(statusString(), other.statusString())
                && Objects.equals(attempts(), other.attempts()) && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(retryStrategy(), other.retryStrategy())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(stoppedAt(), other.stoppedAt())
                && Objects.equals(dependsOn(), other.dependsOn()) && Objects.equals(jobDefinition(), other.jobDefinition())
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(container(), other.container());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jobName() != null) {
            sb.append("JobName: ").append(jobName()).append(",");
        }
        if (jobId() != null) {
            sb.append("JobId: ").append(jobId()).append(",");
        }
        if (jobQueue() != null) {
            sb.append("JobQueue: ").append(jobQueue()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (attempts() != null) {
            sb.append("Attempts: ").append(attempts()).append(",");
        }
        if (statusReason() != null) {
            sb.append("StatusReason: ").append(statusReason()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (retryStrategy() != null) {
            sb.append("RetryStrategy: ").append(retryStrategy()).append(",");
        }
        if (startedAt() != null) {
            sb.append("StartedAt: ").append(startedAt()).append(",");
        }
        if (stoppedAt() != null) {
            sb.append("StoppedAt: ").append(stoppedAt()).append(",");
        }
        if (dependsOn() != null) {
            sb.append("DependsOn: ").append(dependsOn()).append(",");
        }
        if (jobDefinition() != null) {
            sb.append("JobDefinition: ").append(jobDefinition()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (container() != null) {
            sb.append("Container: ").append(container()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.of(clazz.cast(jobName()));
        case "jobId":
            return Optional.of(clazz.cast(jobId()));
        case "jobQueue":
            return Optional.of(clazz.cast(jobQueue()));
        case "status":
            return Optional.of(clazz.cast(statusString()));
        case "attempts":
            return Optional.of(clazz.cast(attempts()));
        case "statusReason":
            return Optional.of(clazz.cast(statusReason()));
        case "createdAt":
            return Optional.of(clazz.cast(createdAt()));
        case "retryStrategy":
            return Optional.of(clazz.cast(retryStrategy()));
        case "startedAt":
            return Optional.of(clazz.cast(startedAt()));
        case "stoppedAt":
            return Optional.of(clazz.cast(stoppedAt()));
        case "dependsOn":
            return Optional.of(clazz.cast(dependsOn()));
        case "jobDefinition":
            return Optional.of(clazz.cast(jobDefinition()));
        case "parameters":
            return Optional.of(clazz.cast(parameters()));
        case "container":
            return Optional.of(clazz.cast(container()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, JobDetail> {
        /**
         * <p>
         * The name of the job.
         * </p>
         * 
         * @param jobName
         *        The name of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The ID for the job.
         * </p>
         * 
         * @param jobId
         *        The ID for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job queue with which the job is associated.
         * </p>
         * 
         * @param jobQueue
         *        The Amazon Resource Name (ARN) of the job queue with which the job is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        /**
         * <p>
         * The current status for the job.
         * </p>
         * 
         * @param status
         *        The current status for the job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status for the job.
         * </p>
         * 
         * @param status
         *        The current status for the job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);

        /**
         * <p>
         * A list of job attempts associated with this job.
         * </p>
         * 
         * @param attempts
         *        A list of job attempts associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attempts(Collection<AttemptDetail> attempts);

        /**
         * <p>
         * A list of job attempts associated with this job.
         * </p>
         * 
         * @param attempts
         *        A list of job attempts associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attempts(AttemptDetail... attempts);

        /**
         * <p>
         * A short, human-readable string to provide additional details about the current status of the job.
         * </p>
         * 
         * @param statusReason
         *        A short, human-readable string to provide additional details about the current status of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The Unix timestamp for when the job was created (when the task entered the <code>PENDING</code> state).
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp for when the job was created (when the task entered the <code>PENDING</code>
         *        state).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Long createdAt);

        /**
         * <p>
         * The retry strategy to use for this job if an attempt fails.
         * </p>
         * 
         * @param retryStrategy
         *        The retry strategy to use for this job if an attempt fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryStrategy(RetryStrategy retryStrategy);

        /**
         * <p>
         * The retry strategy to use for this job if an attempt fails.
         * </p>
         * This is a convenience that creates an instance of the {@link RetryStrategy.Builder} avoiding the need to
         * create one manually via {@link RetryStrategy#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetryStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #retryStrategy(RetryStrategy)}.
         * 
         * @param retryStrategy
         *        a consumer that will call methods on {@link RetryStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryStrategy(RetryStrategy)
         */
        default Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return retryStrategy(RetryStrategy.builder().apply(retryStrategy).build());
        }

        /**
         * <p>
         * The Unix timestamp for when the job was started (when the task transitioned from the <code>PENDING</code>
         * state to the <code>RUNNING</code> state).
         * </p>
         * 
         * @param startedAt
         *        The Unix timestamp for when the job was started (when the task transitioned from the
         *        <code>PENDING</code> state to the <code>RUNNING</code> state).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Long startedAt);

        /**
         * <p>
         * The Unix timestamp for when the job was stopped (when the task transitioned from the <code>RUNNING</code>
         * state to the <code>STOPPED</code> state).
         * </p>
         * 
         * @param stoppedAt
         *        The Unix timestamp for when the job was stopped (when the task transitioned from the
         *        <code>RUNNING</code> state to the <code>STOPPED</code> state).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedAt(Long stoppedAt);

        /**
         * <p>
         * A list of job names or IDs on which this job depends.
         * </p>
         * 
         * @param dependsOn
         *        A list of job names or IDs on which this job depends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(Collection<JobDependency> dependsOn);

        /**
         * <p>
         * A list of job names or IDs on which this job depends.
         * </p>
         * 
         * @param dependsOn
         *        A list of job names or IDs on which this job depends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(JobDependency... dependsOn);

        /**
         * <p>
         * The job definition that is used by this job.
         * </p>
         * 
         * @param jobDefinition
         *        The job definition that is used by this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinition(String jobDefinition);

        /**
         * <p>
         * Additional parameters passed to the job that replace parameter substitution placeholders or override any
         * corresponding parameter defaults from the job definition.
         * </p>
         * 
         * @param parameters
         *        Additional parameters passed to the job that replace parameter substitution placeholders or override
         *        any corresponding parameter defaults from the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * An object representing the details of the container that is associated with the job.
         * </p>
         * 
         * @param container
         *        An object representing the details of the container that is associated with the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(ContainerDetail container);

        /**
         * <p>
         * An object representing the details of the container that is associated with the job.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerDetail.Builder} avoiding the need to
         * create one manually via {@link ContainerDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #container(ContainerDetail)}.
         * 
         * @param container
         *        a consumer that will call methods on {@link ContainerDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #container(ContainerDetail)
         */
        default Builder container(Consumer<ContainerDetail.Builder> container) {
            return container(ContainerDetail.builder().apply(container).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String jobName;

        private String jobId;

        private String jobQueue;

        private String status;

        private List<AttemptDetail> attempts;

        private String statusReason;

        private Long createdAt;

        private RetryStrategy retryStrategy;

        private Long startedAt;

        private Long stoppedAt;

        private List<JobDependency> dependsOn;

        private String jobDefinition;

        private Map<String, String> parameters;

        private ContainerDetail container;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDetail model) {
            jobName(model.jobName);
            jobId(model.jobId);
            jobQueue(model.jobQueue);
            status(model.status);
            attempts(model.attempts);
            statusReason(model.statusReason);
            createdAt(model.createdAt);
            retryStrategy(model.retryStrategy);
            startedAt(model.startedAt);
            stoppedAt(model.stoppedAt);
            dependsOn(model.dependsOn);
            jobDefinition(model.jobDefinition);
            parameters(model.parameters);
            container(model.container);
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<AttemptDetail.Builder> getAttempts() {
            return attempts != null ? attempts.stream().map(AttemptDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attempts(Collection<AttemptDetail> attempts) {
            this.attempts = AttemptDetailsCopier.copy(attempts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attempts(AttemptDetail... attempts) {
            attempts(Arrays.asList(attempts));
            return this;
        }

        public final void setAttempts(Collection<AttemptDetail.BuilderImpl> attempts) {
            this.attempts = AttemptDetailsCopier.copyFromBuilder(attempts);
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Long getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return retryStrategy != null ? retryStrategy.toBuilder() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        public final Long getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        public final Long getStoppedAt() {
            return stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        public final Collection<JobDependency.Builder> getDependsOn() {
            return dependsOn != null ? dependsOn.stream().map(JobDependency::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dependsOn(Collection<JobDependency> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(JobDependency... dependsOn) {
            dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        public final void setDependsOn(Collection<JobDependency.BuilderImpl> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copyFromBuilder(dependsOn);
        }

        public final String getJobDefinition() {
            return jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final ContainerDetail.Builder getContainer() {
            return container != null ? container.toBuilder() : null;
        }

        @Override
        public final Builder container(ContainerDetail container) {
            this.container = container;
            return this;
        }

        public final void setContainer(ContainerDetail.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        @Override
        public JobDetail build() {
            return new JobDetail(this);
        }
    }
}
