/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.JobQueueDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the details of an AWS Batch job queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class JobQueueDetail implements StructuredPojo, ToCopyableBuilder<JobQueueDetail.Builder, JobQueueDetail> {
    private final String jobQueueName;

    private final String jobQueueArn;

    private final String state;

    private final String status;

    private final String statusReason;

    private final Integer priority;

    private final List<ComputeEnvironmentOrder> computeEnvironmentOrder;

    private JobQueueDetail(BuilderImpl builder) {
        this.jobQueueName = builder.jobQueueName;
        this.jobQueueArn = builder.jobQueueArn;
        this.state = builder.state;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.priority = builder.priority;
        this.computeEnvironmentOrder = builder.computeEnvironmentOrder;
    }

    /**
     * <p>
     * The name of the job queue.
     * </p>
     * 
     * @return The name of the job queue.
     */
    public String jobQueueName() {
        return jobQueueName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job queue.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job queue.
     */
    public String jobQueueArn() {
        return jobQueueArn;
    }

    /**
     * <p>
     * Describes the ability of the queue to accept new jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JQState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return Describes the ability of the queue to accept new jobs.
     * @see JQState
     */
    public JQState state() {
        return JQState.fromValue(state);
    }

    /**
     * <p>
     * Describes the ability of the queue to accept new jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JQState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return Describes the ability of the queue to accept new jobs.
     * @see JQState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JQStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
     * @see JQStatus
     */
    public JQStatus status() {
        return JQStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JQStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
     * @see JQStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * A short, human-readable string to provide additional details about the current status of the job queue.
     * </p>
     * 
     * @return A short, human-readable string to provide additional details about the current status of the job queue.
     */
    public String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The priority of the job queue.
     * </p>
     * 
     * @return The priority of the job queue.
     */
    public Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The compute environments that are attached to the job queue and the order in which job placement is preferred.
     * Compute environments are selected for job placement in ascending order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The compute environments that are attached to the job queue and the order in which job placement is
     *         preferred. Compute environments are selected for job placement in ascending order.
     */
    public List<ComputeEnvironmentOrder> computeEnvironmentOrder() {
        return computeEnvironmentOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobQueueName());
        hashCode = 31 * hashCode + Objects.hashCode(jobQueueArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(computeEnvironmentOrder());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobQueueDetail)) {
            return false;
        }
        JobQueueDetail other = (JobQueueDetail) obj;
        return Objects.equals(jobQueueName(), other.jobQueueName()) && Objects.equals(jobQueueArn(), other.jobQueueArn())
                && Objects.equals(stateString(), other.stateString()) && Objects.equals(statusString(), other.statusString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(priority(), other.priority())
                && Objects.equals(computeEnvironmentOrder(), other.computeEnvironmentOrder());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jobQueueName() != null) {
            sb.append("JobQueueName: ").append(jobQueueName()).append(",");
        }
        if (jobQueueArn() != null) {
            sb.append("JobQueueArn: ").append(jobQueueArn()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (statusReason() != null) {
            sb.append("StatusReason: ").append(statusReason()).append(",");
        }
        if (priority() != null) {
            sb.append("Priority: ").append(priority()).append(",");
        }
        if (computeEnvironmentOrder() != null) {
            sb.append("ComputeEnvironmentOrder: ").append(computeEnvironmentOrder()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobQueueName":
            return Optional.of(clazz.cast(jobQueueName()));
        case "jobQueueArn":
            return Optional.of(clazz.cast(jobQueueArn()));
        case "state":
            return Optional.of(clazz.cast(stateString()));
        case "status":
            return Optional.of(clazz.cast(statusString()));
        case "statusReason":
            return Optional.of(clazz.cast(statusReason()));
        case "priority":
            return Optional.of(clazz.cast(priority()));
        case "computeEnvironmentOrder":
            return Optional.of(clazz.cast(computeEnvironmentOrder()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobQueueDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, JobQueueDetail> {
        /**
         * <p>
         * The name of the job queue.
         * </p>
         * 
         * @param jobQueueName
         *        The name of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueueName(String jobQueueName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job queue.
         * </p>
         * 
         * @param jobQueueArn
         *        The Amazon Resource Name (ARN) of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueueArn(String jobQueueArn);

        /**
         * <p>
         * Describes the ability of the queue to accept new jobs.
         * </p>
         * 
         * @param state
         *        Describes the ability of the queue to accept new jobs.
         * @see JQState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQState
         */
        Builder state(String state);

        /**
         * <p>
         * Describes the ability of the queue to accept new jobs.
         * </p>
         * 
         * @param state
         *        Describes the ability of the queue to accept new jobs.
         * @see JQState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQState
         */
        Builder state(JQState state);

        /**
         * <p>
         * The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
         * </p>
         * 
         * @param status
         *        The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
         * @see JQStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
         * </p>
         * 
         * @param status
         *        The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).
         * @see JQStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQStatus
         */
        Builder status(JQStatus status);

        /**
         * <p>
         * A short, human-readable string to provide additional details about the current status of the job queue.
         * </p>
         * 
         * @param statusReason
         *        A short, human-readable string to provide additional details about the current status of the job
         *        queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The priority of the job queue.
         * </p>
         * 
         * @param priority
         *        The priority of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The compute environments that are attached to the job queue and the order in which job placement is
         * preferred. Compute environments are selected for job placement in ascending order.
         * </p>
         * 
         * @param computeEnvironmentOrder
         *        The compute environments that are attached to the job queue and the order in which job placement is
         *        preferred. Compute environments are selected for job placement in ascending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder);

        /**
         * <p>
         * The compute environments that are attached to the job queue and the order in which job placement is
         * preferred. Compute environments are selected for job placement in ascending order.
         * </p>
         * 
         * @param computeEnvironmentOrder
         *        The compute environments that are attached to the job queue and the order in which job placement is
         *        preferred. Compute environments are selected for job placement in ascending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentOrder(ComputeEnvironmentOrder... computeEnvironmentOrder);
    }

    static final class BuilderImpl implements Builder {
        private String jobQueueName;

        private String jobQueueArn;

        private String state;

        private String status;

        private String statusReason;

        private Integer priority;

        private List<ComputeEnvironmentOrder> computeEnvironmentOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(JobQueueDetail model) {
            jobQueueName(model.jobQueueName);
            jobQueueArn(model.jobQueueArn);
            state(model.state);
            status(model.status);
            statusReason(model.statusReason);
            priority(model.priority);
            computeEnvironmentOrder(model.computeEnvironmentOrder);
        }

        public final String getJobQueueName() {
            return jobQueueName;
        }

        @Override
        public final Builder jobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
            return this;
        }

        public final void setJobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
        }

        public final String getJobQueueArn() {
            return jobQueueArn;
        }

        @Override
        public final Builder jobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
            return this;
        }

        public final void setJobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JQState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JQStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<ComputeEnvironmentOrder.Builder> getComputeEnvironmentOrder() {
            return computeEnvironmentOrder != null ? computeEnvironmentOrder.stream().map(ComputeEnvironmentOrder::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironmentOrder(ComputeEnvironmentOrder... computeEnvironmentOrder) {
            computeEnvironmentOrder(Arrays.asList(computeEnvironmentOrder));
            return this;
        }

        public final void setComputeEnvironmentOrder(Collection<ComputeEnvironmentOrder.BuilderImpl> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copyFromBuilder(computeEnvironmentOrder);
        }

        @Override
        public JobQueueDetail build() {
            return new JobQueueDetail(this);
        }
    }
}
