/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.JobSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing summary details of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class JobSummary implements StructuredPojo, ToCopyableBuilder<JobSummary.Builder, JobSummary> {
    private final String jobId;

    private final String jobName;

    private JobSummary(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
    }

    /**
     * <p>
     * The ID of the job.
     * </p>
     * 
     * @return The ID of the job.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The name of the job.
     * </p>
     * 
     * @return The name of the job.
     */
    public String jobName() {
        return jobName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSummary)) {
            return false;
        }
        JobSummary other = (JobSummary) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobName(), other.jobName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jobId() != null) {
            sb.append("JobId: ").append(jobId()).append(",");
        }
        if (jobName() != null) {
            sb.append("JobName: ").append(jobName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.of(clazz.cast(jobId()));
        case "jobName":
            return Optional.of(clazz.cast(jobName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, JobSummary> {
        /**
         * <p>
         * The ID of the job.
         * </p>
         * 
         * @param jobId
         *        The ID of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The name of the job.
         * </p>
         * 
         * @param jobName
         *        The name of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String jobName;

        private BuilderImpl() {
        }

        private BuilderImpl(JobSummary model) {
            jobId(model.jobId);
            jobName(model.jobName);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public JobSummary build() {
            return new JobSummary(this);
        }
    }
}
