/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateComputeEnvironmentRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateComputeEnvironmentRequest.Builder, UpdateComputeEnvironmentRequest> {
    private final String computeEnvironment;

    private final String state;

    private final ComputeResourceUpdate computeResources;

    private final String serviceRole;

    private UpdateComputeEnvironmentRequest(BuilderImpl builder) {
        this.computeEnvironment = builder.computeEnvironment;
        this.state = builder.state;
        this.computeResources = builder.computeResources;
        this.serviceRole = builder.serviceRole;
    }

    /**
     * <p>
     * The name or full Amazon Resource Name (ARN) of the compute environment to update.
     * </p>
     * 
     * @return The name or full Amazon Resource Name (ARN) of the compute environment to update.
     */
    public String computeEnvironment() {
        return computeEnvironment;
    }

    /**
     * <p>
     * The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept jobs from
     * a queue and scale in or out automatically based on the workload demand of its associated queues.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CEState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept
     *         jobs from a queue and scale in or out automatically based on the workload demand of its associated
     *         queues.
     * @see CEState
     */
    public CEState state() {
        return CEState.fromValue(state);
    }

    /**
     * <p>
     * The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept jobs from
     * a queue and scale in or out automatically based on the workload demand of its associated queues.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CEState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept
     *         jobs from a queue and scale in or out automatically based on the workload demand of its associated
     *         queues.
     * @see CEState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * Details of the compute resources managed by the compute environment. Required for a managed compute environment.
     * </p>
     * 
     * @return Details of the compute resources managed by the compute environment. Required for a managed compute
     *         environment.
     */
    public ComputeResourceUpdate computeResources() {
        return computeResources;
    }

    /**
     * <p>
     * The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on
     * your behalf.
     * </p>
     * <p>
     * If your specified role has a path other than <code>/</code>, then you must either specify the full role ARN (this
     * is recommended) or prefix the role name with the path.
     * </p>
     * <note>
     * <p>
     * Depending on how you created your AWS Batch service role, its ARN may contain the <code>service-role</code> path
     * prefix. When you only specify the name of the service role, AWS Batch assumes that your ARN does not use the
     * <code>service-role</code> path prefix. Because of this, we recommend that you specify the full ARN of your
     * service role when you create compute environments.
     * </p>
     * </note>
     * 
     * @return The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS
     *         services on your behalf.</p>
     *         <p>
     *         If your specified role has a path other than <code>/</code>, then you must either specify the full role
     *         ARN (this is recommended) or prefix the role name with the path.
     *         </p>
     *         <note>
     *         <p>
     *         Depending on how you created your AWS Batch service role, its ARN may contain the
     *         <code>service-role</code> path prefix. When you only specify the name of the service role, AWS Batch
     *         assumes that your ARN does not use the <code>service-role</code> path prefix. Because of this, we
     *         recommend that you specify the full ARN of your service role when you create compute environments.
     *         </p>
     */
    public String serviceRole() {
        return serviceRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computeEnvironment());
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        hashCode = 31 * hashCode + Objects.hashCode(computeResources());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputeEnvironmentRequest)) {
            return false;
        }
        UpdateComputeEnvironmentRequest other = (UpdateComputeEnvironmentRequest) obj;
        return Objects.equals(computeEnvironment(), other.computeEnvironment())
                && Objects.equals(stateString(), other.stateString())
                && Objects.equals(computeResources(), other.computeResources())
                && Objects.equals(serviceRole(), other.serviceRole());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (computeEnvironment() != null) {
            sb.append("ComputeEnvironment: ").append(computeEnvironment()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (computeResources() != null) {
            sb.append("ComputeResources: ").append(computeResources()).append(",");
        }
        if (serviceRole() != null) {
            sb.append("ServiceRole: ").append(serviceRole()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeEnvironment":
            return Optional.of(clazz.cast(computeEnvironment()));
        case "state":
            return Optional.of(clazz.cast(stateString()));
        case "computeResources":
            return Optional.of(clazz.cast(computeResources()));
        case "serviceRole":
            return Optional.of(clazz.cast(serviceRole()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateComputeEnvironmentRequest> {
        /**
         * <p>
         * The name or full Amazon Resource Name (ARN) of the compute environment to update.
         * </p>
         * 
         * @param computeEnvironment
         *        The name or full Amazon Resource Name (ARN) of the compute environment to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironment(String computeEnvironment);

        /**
         * <p>
         * The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept jobs
         * from a queue and scale in or out automatically based on the workload demand of its associated queues.
         * </p>
         * 
         * @param state
         *        The state of the compute environment. Compute environments in the <code>ENABLED</code> state can
         *        accept jobs from a queue and scale in or out automatically based on the workload demand of its
         *        associated queues.
         * @see CEState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept jobs
         * from a queue and scale in or out automatically based on the workload demand of its associated queues.
         * </p>
         * 
         * @param state
         *        The state of the compute environment. Compute environments in the <code>ENABLED</code> state can
         *        accept jobs from a queue and scale in or out automatically based on the workload demand of its
         *        associated queues.
         * @see CEState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEState
         */
        Builder state(CEState state);

        /**
         * <p>
         * Details of the compute resources managed by the compute environment. Required for a managed compute
         * environment.
         * </p>
         * 
         * @param computeResources
         *        Details of the compute resources managed by the compute environment. Required for a managed compute
         *        environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeResources(ComputeResourceUpdate computeResources);

        /**
         * <p>
         * Details of the compute resources managed by the compute environment. Required for a managed compute
         * environment.
         * </p>
         * This is a convenience that creates an instance of the {@link ComputeResourceUpdate.Builder} avoiding the need
         * to create one manually via {@link ComputeResourceUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComputeResourceUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #computeResources(ComputeResourceUpdate)}.
         * 
         * @param computeResources
         *        a consumer that will call methods on {@link ComputeResourceUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeResources(ComputeResourceUpdate)
         */
        default Builder computeResources(Consumer<ComputeResourceUpdate.Builder> computeResources) {
            return computeResources(ComputeResourceUpdate.builder().apply(computeResources).build());
        }

        /**
         * <p>
         * The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services
         * on your behalf.
         * </p>
         * <p>
         * If your specified role has a path other than <code>/</code>, then you must either specify the full role ARN
         * (this is recommended) or prefix the role name with the path.
         * </p>
         * <note>
         * <p>
         * Depending on how you created your AWS Batch service role, its ARN may contain the <code>service-role</code>
         * path prefix. When you only specify the name of the service role, AWS Batch assumes that your ARN does not use
         * the <code>service-role</code> path prefix. Because of this, we recommend that you specify the full ARN of
         * your service role when you create compute environments.
         * </p>
         * </note>
         * 
         * @param serviceRole
         *        The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS
         *        services on your behalf.</p>
         *        <p>
         *        If your specified role has a path other than <code>/</code>, then you must either specify the full
         *        role ARN (this is recommended) or prefix the role name with the path.
         *        </p>
         *        <note>
         *        <p>
         *        Depending on how you created your AWS Batch service role, its ARN may contain the
         *        <code>service-role</code> path prefix. When you only specify the name of the service role, AWS Batch
         *        assumes that your ARN does not use the <code>service-role</code> path prefix. Because of this, we
         *        recommend that you specify the full ARN of your service role when you create compute environments.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);
    }

    static final class BuilderImpl implements Builder {
        private String computeEnvironment;

        private String state;

        private ComputeResourceUpdate computeResources;

        private String serviceRole;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputeEnvironmentRequest model) {
            computeEnvironment(model.computeEnvironment);
            state(model.state);
            computeResources(model.computeResources);
            serviceRole(model.serviceRole);
        }

        public final String getComputeEnvironment() {
            return computeEnvironment;
        }

        @Override
        public final Builder computeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
            return this;
        }

        public final void setComputeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CEState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final ComputeResourceUpdate.Builder getComputeResources() {
            return computeResources != null ? computeResources.toBuilder() : null;
        }

        @Override
        public final Builder computeResources(ComputeResourceUpdate computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        public final void setComputeResources(ComputeResourceUpdate.BuilderImpl computeResources) {
            this.computeResources = computeResources != null ? computeResources.build() : null;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public UpdateComputeEnvironmentRequest build() {
            return new UpdateComputeEnvironmentRequest(this);
        }
    }
}
