/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateJobQueueRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateJobQueueRequest.Builder, UpdateJobQueueRequest> {
    private final String jobQueue;

    private final String state;

    private final Integer priority;

    private final List<ComputeEnvironmentOrder> computeEnvironmentOrder;

    private UpdateJobQueueRequest(BuilderImpl builder) {
        this.jobQueue = builder.jobQueue;
        this.state = builder.state;
        this.priority = builder.priority;
        this.computeEnvironmentOrder = builder.computeEnvironmentOrder;
    }

    /**
     * <p>
     * The name or the Amazon Resource Name (ARN) of the job queue.
     * </p>
     * 
     * @return The name or the Amazon Resource Name (ARN) of the job queue.
     */
    public String jobQueue() {
        return jobQueue;
    }

    /**
     * <p>
     * Describes the queue's ability to accept new jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JQState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return Describes the queue's ability to accept new jobs.
     * @see JQState
     */
    public JQState state() {
        return JQState.fromValue(state);
    }

    /**
     * <p>
     * Describes the queue's ability to accept new jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JQState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return Describes the queue's ability to accept new jobs.
     * @see JQState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The priority of the job queue. Job queues with a higher priority (or a higher integer value for the
     * <code>priority</code> parameter) are evaluated first when associated with same compute environment. Priority is
     * determined in descending order, for example, a job queue with a priority value of <code>10</code> is given
     * scheduling preference over a job queue with a priority value of <code>1</code>.
     * </p>
     * 
     * @return The priority of the job queue. Job queues with a higher priority (or a higher integer value for the
     *         <code>priority</code> parameter) are evaluated first when associated with same compute environment.
     *         Priority is determined in descending order, for example, a job queue with a priority value of
     *         <code>10</code> is given scheduling preference over a job queue with a priority value of <code>1</code>.
     */
    public Integer priority() {
        return priority;
    }

    /**
     * <p>
     * Details the set of compute environments mapped to a job queue and their order relative to each other. This is one
     * of the parameters used by the job scheduler to determine which compute environment should execute a given job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Details the set of compute environments mapped to a job queue and their order relative to each other.
     *         This is one of the parameters used by the job scheduler to determine which compute environment should
     *         execute a given job.
     */
    public List<ComputeEnvironmentOrder> computeEnvironmentOrder() {
        return computeEnvironmentOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(computeEnvironmentOrder());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobQueueRequest)) {
            return false;
        }
        UpdateJobQueueRequest other = (UpdateJobQueueRequest) obj;
        return Objects.equals(jobQueue(), other.jobQueue()) && Objects.equals(stateString(), other.stateString())
                && Objects.equals(priority(), other.priority())
                && Objects.equals(computeEnvironmentOrder(), other.computeEnvironmentOrder());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jobQueue() != null) {
            sb.append("JobQueue: ").append(jobQueue()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (priority() != null) {
            sb.append("Priority: ").append(priority()).append(",");
        }
        if (computeEnvironmentOrder() != null) {
            sb.append("ComputeEnvironmentOrder: ").append(computeEnvironmentOrder()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobQueue":
            return Optional.of(clazz.cast(jobQueue()));
        case "state":
            return Optional.of(clazz.cast(stateString()));
        case "priority":
            return Optional.of(clazz.cast(priority()));
        case "computeEnvironmentOrder":
            return Optional.of(clazz.cast(computeEnvironmentOrder()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateJobQueueRequest> {
        /**
         * <p>
         * The name or the Amazon Resource Name (ARN) of the job queue.
         * </p>
         * 
         * @param jobQueue
         *        The name or the Amazon Resource Name (ARN) of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        /**
         * <p>
         * Describes the queue's ability to accept new jobs.
         * </p>
         * 
         * @param state
         *        Describes the queue's ability to accept new jobs.
         * @see JQState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQState
         */
        Builder state(String state);

        /**
         * <p>
         * Describes the queue's ability to accept new jobs.
         * </p>
         * 
         * @param state
         *        Describes the queue's ability to accept new jobs.
         * @see JQState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQState
         */
        Builder state(JQState state);

        /**
         * <p>
         * The priority of the job queue. Job queues with a higher priority (or a higher integer value for the
         * <code>priority</code> parameter) are evaluated first when associated with same compute environment. Priority
         * is determined in descending order, for example, a job queue with a priority value of <code>10</code> is given
         * scheduling preference over a job queue with a priority value of <code>1</code>.
         * </p>
         * 
         * @param priority
         *        The priority of the job queue. Job queues with a higher priority (or a higher integer value for the
         *        <code>priority</code> parameter) are evaluated first when associated with same compute environment.
         *        Priority is determined in descending order, for example, a job queue with a priority value of
         *        <code>10</code> is given scheduling preference over a job queue with a priority value of
         *        <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * Details the set of compute environments mapped to a job queue and their order relative to each other. This is
         * one of the parameters used by the job scheduler to determine which compute environment should execute a given
         * job.
         * </p>
         * 
         * @param computeEnvironmentOrder
         *        Details the set of compute environments mapped to a job queue and their order relative to each other.
         *        This is one of the parameters used by the job scheduler to determine which compute environment should
         *        execute a given job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder);

        /**
         * <p>
         * Details the set of compute environments mapped to a job queue and their order relative to each other. This is
         * one of the parameters used by the job scheduler to determine which compute environment should execute a given
         * job.
         * </p>
         * 
         * @param computeEnvironmentOrder
         *        Details the set of compute environments mapped to a job queue and their order relative to each other.
         *        This is one of the parameters used by the job scheduler to determine which compute environment should
         *        execute a given job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentOrder(ComputeEnvironmentOrder... computeEnvironmentOrder);
    }

    static final class BuilderImpl implements Builder {
        private String jobQueue;

        private String state;

        private Integer priority;

        private List<ComputeEnvironmentOrder> computeEnvironmentOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobQueueRequest model) {
            jobQueue(model.jobQueue);
            state(model.state);
            priority(model.priority);
            computeEnvironmentOrder(model.computeEnvironmentOrder);
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JQState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<ComputeEnvironmentOrder.Builder> getComputeEnvironmentOrder() {
            return computeEnvironmentOrder != null ? computeEnvironmentOrder.stream().map(ComputeEnvironmentOrder::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironmentOrder(ComputeEnvironmentOrder... computeEnvironmentOrder) {
            computeEnvironmentOrder(Arrays.asList(computeEnvironmentOrder));
            return this;
        }

        public final void setComputeEnvironmentOrder(Collection<ComputeEnvironmentOrder.BuilderImpl> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copyFromBuilder(computeEnvironmentOrder);
        }

        @Override
        public UpdateJobQueueRequest build() {
            return new UpdateJobQueueRequest(this);
        }
    }
}
