/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateJobQueueResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<UpdateJobQueueResponse.Builder, UpdateJobQueueResponse> {
    private final String jobQueueName;

    private final String jobQueueArn;

    private UpdateJobQueueResponse(BuilderImpl builder) {
        this.jobQueueName = builder.jobQueueName;
        this.jobQueueArn = builder.jobQueueArn;
    }

    /**
     * <p>
     * The name of the job queue.
     * </p>
     * 
     * @return The name of the job queue.
     */
    public String jobQueueName() {
        return jobQueueName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job queue.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job queue.
     */
    public String jobQueueArn() {
        return jobQueueArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobQueueName());
        hashCode = 31 * hashCode + Objects.hashCode(jobQueueArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobQueueResponse)) {
            return false;
        }
        UpdateJobQueueResponse other = (UpdateJobQueueResponse) obj;
        return Objects.equals(jobQueueName(), other.jobQueueName()) && Objects.equals(jobQueueArn(), other.jobQueueArn());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jobQueueName() != null) {
            sb.append("JobQueueName: ").append(jobQueueName()).append(",");
        }
        if (jobQueueArn() != null) {
            sb.append("JobQueueArn: ").append(jobQueueArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobQueueName":
            return Optional.of(clazz.cast(jobQueueName()));
        case "jobQueueArn":
            return Optional.of(clazz.cast(jobQueueArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateJobQueueResponse> {
        /**
         * <p>
         * The name of the job queue.
         * </p>
         * 
         * @param jobQueueName
         *        The name of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueueName(String jobQueueName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job queue.
         * </p>
         * 
         * @param jobQueueArn
         *        The Amazon Resource Name (ARN) of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueueArn(String jobQueueArn);
    }

    static final class BuilderImpl implements Builder {
        private String jobQueueName;

        private String jobQueueArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobQueueResponse model) {
            jobQueueName(model.jobQueueName);
            jobQueueArn(model.jobQueueArn);
        }

        public final String getJobQueueName() {
            return jobQueueName;
        }

        @Override
        public final Builder jobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
            return this;
        }

        public final void setJobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
        }

        public final String getJobQueueArn() {
            return jobQueueArn;
        }

        @Override
        public final Builder jobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
            return this;
        }

        public final void setJobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
        }

        @Override
        public UpdateJobQueueResponse build() {
            return new UpdateJobQueueResponse(this);
        }
    }
}
