/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrder;

@SdkInternalApi
public class ComputeEnvironmentOrderMarshaller {
    private static final MarshallingInfo<Integer> ORDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("order").build();
    private static final MarshallingInfo<String> COMPUTEENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("computeEnvironment").build();
    private static final ComputeEnvironmentOrderMarshaller INSTANCE = new ComputeEnvironmentOrderMarshaller();

    public static ComputeEnvironmentOrderMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ComputeEnvironmentOrder computeEnvironmentOrder, ProtocolMarshaller protocolMarshaller) {
        if (computeEnvironmentOrder == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)computeEnvironmentOrder.order(), ORDER_BINDING);
            protocolMarshaller.marshall((Object)computeEnvironmentOrder.computeEnvironment(), COMPUTEENVIRONMENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

