/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.batch.model.CancelJobRequest;
import software.amazon.awssdk.services.batch.model.CancelJobResponse;
import software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentRequest;
import software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentResponse;
import software.amazon.awssdk.services.batch.model.CreateJobQueueRequest;
import software.amazon.awssdk.services.batch.model.CreateJobQueueResponse;
import software.amazon.awssdk.services.batch.model.DeleteComputeEnvironmentRequest;
import software.amazon.awssdk.services.batch.model.DeleteComputeEnvironmentResponse;
import software.amazon.awssdk.services.batch.model.DeleteJobQueueRequest;
import software.amazon.awssdk.services.batch.model.DeleteJobQueueResponse;
import software.amazon.awssdk.services.batch.model.DeregisterJobDefinitionRequest;
import software.amazon.awssdk.services.batch.model.DeregisterJobDefinitionResponse;
import software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest;
import software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsResponse;
import software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsRequest;
import software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsResponse;
import software.amazon.awssdk.services.batch.model.DescribeJobQueuesRequest;
import software.amazon.awssdk.services.batch.model.DescribeJobQueuesResponse;
import software.amazon.awssdk.services.batch.model.DescribeJobsRequest;
import software.amazon.awssdk.services.batch.model.DescribeJobsResponse;
import software.amazon.awssdk.services.batch.model.ListJobsRequest;
import software.amazon.awssdk.services.batch.model.ListJobsResponse;
import software.amazon.awssdk.services.batch.model.RegisterJobDefinitionRequest;
import software.amazon.awssdk.services.batch.model.RegisterJobDefinitionResponse;
import software.amazon.awssdk.services.batch.model.SubmitJobRequest;
import software.amazon.awssdk.services.batch.model.SubmitJobResponse;
import software.amazon.awssdk.services.batch.model.TerminateJobRequest;
import software.amazon.awssdk.services.batch.model.TerminateJobResponse;
import software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentRequest;
import software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentResponse;
import software.amazon.awssdk.services.batch.model.UpdateJobQueueRequest;
import software.amazon.awssdk.services.batch.model.UpdateJobQueueResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing AWS Batch asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * AWS Batch enables you to run batch computing workloads on the AWS Cloud. Batch computing is a common way for
 * developers, scientists, and engineers to access large amounts of compute resources, and AWS Batch removes the
 * undifferentiated heavy lifting of configuring and managing the required infrastructure. AWS Batch will be familiar to
 * users of traditional batch computing software. This service can efficiently provision resources in response to jobs
 * submitted in order to eliminate capacity constraints, reduce compute costs, and deliver results quickly.
 * </p>
 * <p>
 * As a fully managed service, AWS Batch enables developers, scientists, and engineers to run batch computing workloads
 * of any scale. AWS Batch automatically provisions compute resources and optimizes the workload distribution based on
 * the quantity and scale of the workloads. With AWS Batch, there is no need to install or manage batch computing
 * software, which allows you to focus on analyzing results and solving problems. AWS Batch reduces operational
 * complexities, saves time, and reduces costs, which makes it easy for developers, scientists, and engineers to run
 * their batch jobs in the AWS Cloud.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface BatchAsyncClient extends SdkClient, SdkAutoCloseable {
    String SERVICE_NAME = "batch";

    /**
     * Create a {@link BatchAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.core.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from
     * the {@link software.amazon.awssdk.core.auth.DefaultCredentialsProvider}.
     */
    static BatchAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BatchAsyncClient}.
     */
    static BatchAsyncClientBuilder builder() {
        return new DefaultBatchAsyncClientBuilder();
    }

    /**
     * <p>
     * Cancels a job in an AWS Batch job queue. Jobs that are in the <code>SUBMITTED</code>, <code>PENDING</code>, or
     * <code>RUNNABLE</code> state are cancelled. Jobs that have progressed to <code>STARTING</code> or
     * <code>RUNNING</code> are not cancelled (but the API operation still succeeds, even if no job is cancelled); these
     * jobs must be terminated with the <a>TerminateJob</a> operation.
     * </p>
     *
     * @param cancelJobRequest
     * @return A Java Future containing the result of the CancelJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.CancelJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CancelJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelJobResponse> cancelJob(CancelJobRequest cancelJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a job in an AWS Batch job queue. Jobs that are in the <code>SUBMITTED</code>, <code>PENDING</code>, or
     * <code>RUNNABLE</code> state are cancelled. Jobs that have progressed to <code>STARTING</code> or
     * <code>RUNNING</code> are not cancelled (but the API operation still succeeds, even if no job is cancelled); these
     * jobs must be terminated with the <a>TerminateJob</a> operation.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CancelJobRequest.Builder} avoiding the need to
     * create one manually via {@link CancelJobRequest#builder()}
     *
     * @param cancelJobRequest
     *        a {@link Consumer} that will call methods on {@link CancelJobRequest.Builder}.
     * @return A Java Future containing the result of the CancelJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.CancelJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CancelJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelJobResponse> cancelJob(Consumer<CancelJobRequest.Builder> cancelJobRequest) {
        return cancelJob(CancelJobRequest.builder().apply(cancelJobRequest).build());
    }

    /**
     * <p>
     * Creates an AWS Batch compute environment. You can create <code>MANAGED</code> or <code>UNMANAGED</code> compute
     * environments.
     * </p>
     * <p>
     * In a managed compute environment, AWS Batch manages the compute resources within the environment, based on the
     * compute resources that you specify. Instances launched into a managed compute environment use a recent, approved
     * version of the Amazon ECS-optimized AMI. You can choose to use Amazon EC2 On-Demand instances in your managed
     * compute environment, or you can use Amazon EC2 Spot instances that only launch when the Spot bid price is below a
     * specified percentage of the On-Demand price.
     * </p>
     * <p>
     * In an unmanaged compute environment, you can manage your own compute resources. This provides more compute
     * resource configuration options, such as using a custom AMI, but you must ensure that your AMI meets the Amazon
     * ECS container instance AMI specification. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/container_instance_AMIs.html">Container Instance
     * AMIs</a> in the <i>Amazon EC2 Container Service Developer Guide</i>. After you have created your unmanaged
     * compute environment, you can use the <a>DescribeComputeEnvironments</a> operation to find the Amazon ECS cluster
     * that is associated with it and then manually launch your container instances into that Amazon ECS cluster. For
     * more information, see <a
     * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_container_instance.html">Launching an
     * Amazon ECS Container Instance</a> in the <i>Amazon EC2 Container Service Developer Guide</i>.
     * </p>
     *
     * @param createComputeEnvironmentRequest
     * @return A Java Future containing the result of the CreateComputeEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.CreateComputeEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateComputeEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateComputeEnvironmentResponse> createComputeEnvironment(
            CreateComputeEnvironmentRequest createComputeEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS Batch compute environment. You can create <code>MANAGED</code> or <code>UNMANAGED</code> compute
     * environments.
     * </p>
     * <p>
     * In a managed compute environment, AWS Batch manages the compute resources within the environment, based on the
     * compute resources that you specify. Instances launched into a managed compute environment use a recent, approved
     * version of the Amazon ECS-optimized AMI. You can choose to use Amazon EC2 On-Demand instances in your managed
     * compute environment, or you can use Amazon EC2 Spot instances that only launch when the Spot bid price is below a
     * specified percentage of the On-Demand price.
     * </p>
     * <p>
     * In an unmanaged compute environment, you can manage your own compute resources. This provides more compute
     * resource configuration options, such as using a custom AMI, but you must ensure that your AMI meets the Amazon
     * ECS container instance AMI specification. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/container_instance_AMIs.html">Container Instance
     * AMIs</a> in the <i>Amazon EC2 Container Service Developer Guide</i>. After you have created your unmanaged
     * compute environment, you can use the <a>DescribeComputeEnvironments</a> operation to find the Amazon ECS cluster
     * that is associated with it and then manually launch your container instances into that Amazon ECS cluster. For
     * more information, see <a
     * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_container_instance.html">Launching an
     * Amazon ECS Container Instance</a> in the <i>Amazon EC2 Container Service Developer Guide</i>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreateComputeEnvironmentRequest.Builder} avoiding
     * the need to create one manually via {@link CreateComputeEnvironmentRequest#builder()}
     *
     * @param createComputeEnvironmentRequest
     *        a {@link Consumer} that will call methods on {@link CreateComputeEnvironmentRequest.Builder}.
     * @return A Java Future containing the result of the CreateComputeEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.CreateComputeEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateComputeEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateComputeEnvironmentResponse> createComputeEnvironment(
            Consumer<CreateComputeEnvironmentRequest.Builder> createComputeEnvironmentRequest) {
        return createComputeEnvironment(CreateComputeEnvironmentRequest.builder().apply(createComputeEnvironmentRequest).build());
    }

    /**
     * <p>
     * Creates an AWS Batch job queue. When you create a job queue, you associate one or more compute environments to
     * the queue and assign an order of preference for the compute environments.
     * </p>
     * <p>
     * You also set a priority to the job queue that determines the order in which the AWS Batch scheduler places jobs
     * onto its associated compute environments. For example, if a compute environment is associated with more than one
     * job queue, the job queue with a higher priority is given preference for scheduling jobs to that compute
     * environment.
     * </p>
     *
     * @param createJobQueueRequest
     * @return A Java Future containing the result of the CreateJobQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.CreateJobQueue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateJobQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateJobQueueResponse> createJobQueue(CreateJobQueueRequest createJobQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS Batch job queue. When you create a job queue, you associate one or more compute environments to
     * the queue and assign an order of preference for the compute environments.
     * </p>
     * <p>
     * You also set a priority to the job queue that determines the order in which the AWS Batch scheduler places jobs
     * onto its associated compute environments. For example, if a compute environment is associated with more than one
     * job queue, the job queue with a higher priority is given preference for scheduling jobs to that compute
     * environment.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreateJobQueueRequest.Builder} avoiding the need to
     * create one manually via {@link CreateJobQueueRequest#builder()}
     *
     * @param createJobQueueRequest
     *        a {@link Consumer} that will call methods on {@link CreateJobQueueRequest.Builder}.
     * @return A Java Future containing the result of the CreateJobQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.CreateJobQueue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateJobQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateJobQueueResponse> createJobQueue(Consumer<CreateJobQueueRequest.Builder> createJobQueueRequest) {
        return createJobQueue(CreateJobQueueRequest.builder().apply(createJobQueueRequest).build());
    }

    /**
     * <p>
     * Deletes an AWS Batch compute environment.
     * </p>
     * <p>
     * Before you can delete a compute environment, you must set its state to <code>DISABLED</code> with the
     * <a>UpdateComputeEnvironment</a> API operation and disassociate it from any job queues with the
     * <a>UpdateJobQueue</a> API operation.
     * </p>
     *
     * @param deleteComputeEnvironmentRequest
     * @return A Java Future containing the result of the DeleteComputeEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DeleteComputeEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteComputeEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteComputeEnvironmentResponse> deleteComputeEnvironment(
            DeleteComputeEnvironmentRequest deleteComputeEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an AWS Batch compute environment.
     * </p>
     * <p>
     * Before you can delete a compute environment, you must set its state to <code>DISABLED</code> with the
     * <a>UpdateComputeEnvironment</a> API operation and disassociate it from any job queues with the
     * <a>UpdateJobQueue</a> API operation.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteComputeEnvironmentRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteComputeEnvironmentRequest#builder()}
     *
     * @param deleteComputeEnvironmentRequest
     *        a {@link Consumer} that will call methods on {@link DeleteComputeEnvironmentRequest.Builder}.
     * @return A Java Future containing the result of the DeleteComputeEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DeleteComputeEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteComputeEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteComputeEnvironmentResponse> deleteComputeEnvironment(
            Consumer<DeleteComputeEnvironmentRequest.Builder> deleteComputeEnvironmentRequest) {
        return deleteComputeEnvironment(DeleteComputeEnvironmentRequest.builder().apply(deleteComputeEnvironmentRequest).build());
    }

    /**
     * <p>
     * Deletes the specified job queue. You must first disable submissions for a queue with the <a>UpdateJobQueue</a>
     * operation. All jobs in the queue are terminated when you delete a job queue.
     * </p>
     * <p>
     * It is not necessary to disassociate compute environments from a queue before submitting a
     * <code>DeleteJobQueue</code> request.
     * </p>
     *
     * @param deleteJobQueueRequest
     * @return A Java Future containing the result of the DeleteJobQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DeleteJobQueue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteJobQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteJobQueueResponse> deleteJobQueue(DeleteJobQueueRequest deleteJobQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified job queue. You must first disable submissions for a queue with the <a>UpdateJobQueue</a>
     * operation. All jobs in the queue are terminated when you delete a job queue.
     * </p>
     * <p>
     * It is not necessary to disassociate compute environments from a queue before submitting a
     * <code>DeleteJobQueue</code> request.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteJobQueueRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteJobQueueRequest#builder()}
     *
     * @param deleteJobQueueRequest
     *        a {@link Consumer} that will call methods on {@link DeleteJobQueueRequest.Builder}.
     * @return A Java Future containing the result of the DeleteJobQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DeleteJobQueue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteJobQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteJobQueueResponse> deleteJobQueue(Consumer<DeleteJobQueueRequest.Builder> deleteJobQueueRequest) {
        return deleteJobQueue(DeleteJobQueueRequest.builder().apply(deleteJobQueueRequest).build());
    }

    /**
     * <p>
     * Deregisters an AWS Batch job definition.
     * </p>
     *
     * @param deregisterJobDefinitionRequest
     * @return A Java Future containing the result of the DeregisterJobDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DeregisterJobDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeregisterJobDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterJobDefinitionResponse> deregisterJobDefinition(
            DeregisterJobDefinitionRequest deregisterJobDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters an AWS Batch job definition.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeregisterJobDefinitionRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterJobDefinitionRequest#builder()}
     *
     * @param deregisterJobDefinitionRequest
     *        a {@link Consumer} that will call methods on {@link DeregisterJobDefinitionRequest.Builder}.
     * @return A Java Future containing the result of the DeregisterJobDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DeregisterJobDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeregisterJobDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterJobDefinitionResponse> deregisterJobDefinition(
            Consumer<DeregisterJobDefinitionRequest.Builder> deregisterJobDefinitionRequest) {
        return deregisterJobDefinition(DeregisterJobDefinitionRequest.builder().apply(deregisterJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your compute environments.
     * </p>
     * <p>
     * If you are using an unmanaged compute environment, you can use the <code>DescribeComputeEnvironment</code>
     * operation to determine the <code>ecsClusterArn</code> that you should launch your Amazon ECS container instances
     * into.
     * </p>
     *
     * @param describeComputeEnvironmentsRequest
     * @return A Java Future containing the result of the DescribeComputeEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DescribeComputeEnvironments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeComputeEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComputeEnvironmentsResponse> describeComputeEnvironments(
            DescribeComputeEnvironmentsRequest describeComputeEnvironmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your compute environments.
     * </p>
     * <p>
     * If you are using an unmanaged compute environment, you can use the <code>DescribeComputeEnvironment</code>
     * operation to determine the <code>ecsClusterArn</code> that you should launch your Amazon ECS container instances
     * into.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeComputeEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DescribeComputeEnvironments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeComputeEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComputeEnvironmentsResponse> describeComputeEnvironments() {
        return describeComputeEnvironments(DescribeComputeEnvironmentsRequest.builder().build());
    }

    /**
     * <p>
     * Describes one or more of your compute environments.
     * </p>
     * <p>
     * If you are using an unmanaged compute environment, you can use the <code>DescribeComputeEnvironment</code>
     * operation to determine the <code>ecsClusterArn</code> that you should launch your Amazon ECS container instances
     * into.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeComputeEnvironmentsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeComputeEnvironmentsRequest#builder()}
     *
     * @param describeComputeEnvironmentsRequest
     *        a {@link Consumer} that will call methods on {@link DescribeComputeEnvironmentsRequest.Builder}.
     * @return A Java Future containing the result of the DescribeComputeEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DescribeComputeEnvironments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeComputeEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComputeEnvironmentsResponse> describeComputeEnvironments(
            Consumer<DescribeComputeEnvironmentsRequest.Builder> describeComputeEnvironmentsRequest) {
        return describeComputeEnvironments(DescribeComputeEnvironmentsRequest.builder().apply(describeComputeEnvironmentsRequest)
                .build());
    }

    /**
     * <p>
     * Describes a list of job definitions. You can specify a <code>status</code> (such as <code>ACTIVE</code>) to only
     * return job definitions that match that status.
     * </p>
     *
     * @param describeJobDefinitionsRequest
     * @return A Java Future containing the result of the DescribeJobDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DescribeJobDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeJobDefinitionsResponse> describeJobDefinitions(
            DescribeJobDefinitionsRequest describeJobDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a list of job definitions. You can specify a <code>status</code> (such as <code>ACTIVE</code>) to only
     * return job definitions that match that status.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeJobDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DescribeJobDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeJobDefinitionsResponse> describeJobDefinitions() {
        return describeJobDefinitions(DescribeJobDefinitionsRequest.builder().build());
    }

    /**
     * <p>
     * Describes a list of job definitions. You can specify a <code>status</code> (such as <code>ACTIVE</code>) to only
     * return job definitions that match that status.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeJobDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeJobDefinitionsRequest#builder()}
     *
     * @param describeJobDefinitionsRequest
     *        a {@link Consumer} that will call methods on {@link DescribeJobDefinitionsRequest.Builder}.
     * @return A Java Future containing the result of the DescribeJobDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DescribeJobDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeJobDefinitionsResponse> describeJobDefinitions(
            Consumer<DescribeJobDefinitionsRequest.Builder> describeJobDefinitionsRequest) {
        return describeJobDefinitions(DescribeJobDefinitionsRequest.builder().apply(describeJobDefinitionsRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your job queues.
     * </p>
     *
     * @param describeJobQueuesRequest
     * @return A Java Future containing the result of the DescribeJobQueues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DescribeJobQueues
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeJobQueuesResponse> describeJobQueues(DescribeJobQueuesRequest describeJobQueuesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your job queues.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeJobQueues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DescribeJobQueues
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeJobQueuesResponse> describeJobQueues() {
        return describeJobQueues(DescribeJobQueuesRequest.builder().build());
    }

    /**
     * <p>
     * Describes one or more of your job queues.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeJobQueuesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeJobQueuesRequest#builder()}
     *
     * @param describeJobQueuesRequest
     *        a {@link Consumer} that will call methods on {@link DescribeJobQueuesRequest.Builder}.
     * @return A Java Future containing the result of the DescribeJobQueues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DescribeJobQueues
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeJobQueuesResponse> describeJobQueues(
            Consumer<DescribeJobQueuesRequest.Builder> describeJobQueuesRequest) {
        return describeJobQueues(DescribeJobQueuesRequest.builder().apply(describeJobQueuesRequest).build());
    }

    /**
     * <p>
     * Describes a list of AWS Batch jobs.
     * </p>
     *
     * @param describeJobsRequest
     * @return A Java Future containing the result of the DescribeJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DescribeJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeJobsResponse> describeJobs(DescribeJobsRequest describeJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a list of AWS Batch jobs.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DescribeJobsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeJobsRequest#builder()}
     *
     * @param describeJobsRequest
     *        a {@link Consumer} that will call methods on {@link DescribeJobsRequest.Builder}.
     * @return A Java Future containing the result of the DescribeJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.DescribeJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeJobsResponse> describeJobs(Consumer<DescribeJobsRequest.Builder> describeJobsRequest) {
        return describeJobs(DescribeJobsRequest.builder().apply(describeJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of task jobs for a specified job queue. You can filter the results by job status with the
     * <code>jobStatus</code> parameter. If you do not specify a status, only <code>RUNNING</code> jobs are returned.
     * </p>
     *
     * @param listJobsRequest
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest listJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of task jobs for a specified job queue. You can filter the results by job status with the
     * <code>jobStatus</code> parameter. If you do not specify a status, only <code>RUNNING</code> jobs are returned.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     *
     * @param listJobsRequest
     *        a {@link Consumer} that will call methods on {@link ListJobsRequest.Builder}.
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListJobsResponse> listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) {
        return listJobs(ListJobsRequest.builder().apply(listJobsRequest).build());
    }

    /**
     * <p>
     * Registers an AWS Batch job definition.
     * </p>
     *
     * @param registerJobDefinitionRequest
     * @return A Java Future containing the result of the RegisterJobDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.RegisterJobDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/RegisterJobDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterJobDefinitionResponse> registerJobDefinition(
            RegisterJobDefinitionRequest registerJobDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an AWS Batch job definition.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link RegisterJobDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterJobDefinitionRequest#builder()}
     *
     * @param registerJobDefinitionRequest
     *        a {@link Consumer} that will call methods on {@link RegisterJobDefinitionRequest.Builder}.
     * @return A Java Future containing the result of the RegisterJobDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.RegisterJobDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/RegisterJobDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterJobDefinitionResponse> registerJobDefinition(
            Consumer<RegisterJobDefinitionRequest.Builder> registerJobDefinitionRequest) {
        return registerJobDefinition(RegisterJobDefinitionRequest.builder().apply(registerJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Submits an AWS Batch job from a job definition. Parameters specified during <a>SubmitJob</a> override parameters
     * defined in the job definition.
     * </p>
     *
     * @param submitJobRequest
     * @return A Java Future containing the result of the SubmitJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.SubmitJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/SubmitJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SubmitJobResponse> submitJob(SubmitJobRequest submitJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submits an AWS Batch job from a job definition. Parameters specified during <a>SubmitJob</a> override parameters
     * defined in the job definition.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link SubmitJobRequest.Builder} avoiding the need to
     * create one manually via {@link SubmitJobRequest#builder()}
     *
     * @param submitJobRequest
     *        a {@link Consumer} that will call methods on {@link SubmitJobRequest.Builder}.
     * @return A Java Future containing the result of the SubmitJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.SubmitJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/SubmitJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SubmitJobResponse> submitJob(Consumer<SubmitJobRequest.Builder> submitJobRequest) {
        return submitJob(SubmitJobRequest.builder().apply(submitJobRequest).build());
    }

    /**
     * <p>
     * Terminates a job in a job queue. Jobs that are in the <code>STARTING</code> or <code>RUNNING</code> state are
     * terminated, which causes them to transition to <code>FAILED</code>. Jobs that have not progressed to the
     * <code>STARTING</code> state are cancelled.
     * </p>
     *
     * @param terminateJobRequest
     * @return A Java Future containing the result of the TerminateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.TerminateJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/TerminateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TerminateJobResponse> terminateJob(TerminateJobRequest terminateJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates a job in a job queue. Jobs that are in the <code>STARTING</code> or <code>RUNNING</code> state are
     * terminated, which causes them to transition to <code>FAILED</code>. Jobs that have not progressed to the
     * <code>STARTING</code> state are cancelled.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link TerminateJobRequest.Builder} avoiding the need to
     * create one manually via {@link TerminateJobRequest#builder()}
     *
     * @param terminateJobRequest
     *        a {@link Consumer} that will call methods on {@link TerminateJobRequest.Builder}.
     * @return A Java Future containing the result of the TerminateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.TerminateJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/TerminateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TerminateJobResponse> terminateJob(Consumer<TerminateJobRequest.Builder> terminateJobRequest) {
        return terminateJob(TerminateJobRequest.builder().apply(terminateJobRequest).build());
    }

    /**
     * <p>
     * Updates an AWS Batch compute environment.
     * </p>
     *
     * @param updateComputeEnvironmentRequest
     * @return A Java Future containing the result of the UpdateComputeEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.UpdateComputeEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateComputeEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateComputeEnvironmentResponse> updateComputeEnvironment(
            UpdateComputeEnvironmentRequest updateComputeEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an AWS Batch compute environment.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateComputeEnvironmentRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateComputeEnvironmentRequest#builder()}
     *
     * @param updateComputeEnvironmentRequest
     *        a {@link Consumer} that will call methods on {@link UpdateComputeEnvironmentRequest.Builder}.
     * @return A Java Future containing the result of the UpdateComputeEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.UpdateComputeEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateComputeEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateComputeEnvironmentResponse> updateComputeEnvironment(
            Consumer<UpdateComputeEnvironmentRequest.Builder> updateComputeEnvironmentRequest) {
        return updateComputeEnvironment(UpdateComputeEnvironmentRequest.builder().apply(updateComputeEnvironmentRequest).build());
    }

    /**
     * <p>
     * Updates a job queue.
     * </p>
     *
     * @param updateJobQueueRequest
     * @return A Java Future containing the result of the UpdateJobQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.UpdateJobQueue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateJobQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateJobQueueResponse> updateJobQueue(UpdateJobQueueRequest updateJobQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a job queue.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateJobQueueRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateJobQueueRequest#builder()}
     *
     * @param updateJobQueueRequest
     *        a {@link Consumer} that will call methods on {@link UpdateJobQueueRequest.Builder}.
     * @return A Java Future containing the result of the UpdateJobQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientException These errors are usually caused by a client action, such as using an action or
     *         resource on behalf of a user that doesn't have permission to use the action or resource, or specifying an
     *         identifier that is not valid.</li>
     *         <li>ServerException These errors are usually caused by a server issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BatchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BatchAsyncClient.UpdateJobQueue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateJobQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateJobQueueResponse> updateJobQueue(Consumer<UpdateJobQueueRequest.Builder> updateJobQueueRequest) {
        return updateJobQueue(UpdateJobQueueRequest.builder().apply(updateJobQueueRequest).build());
    }
}
