/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.ComputeEnvironmentOrderMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The order in which compute environments are tried for job placement within a queue. Compute environments are tried in
 * ascending order. For example, if two compute environments are associated with a job queue, the compute environment
 * with a lower order integer value is tried for job placement first.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ComputeEnvironmentOrder implements StructuredPojo,
        ToCopyableBuilder<ComputeEnvironmentOrder.Builder, ComputeEnvironmentOrder> {
    private final Integer order;

    private final String computeEnvironment;

    private ComputeEnvironmentOrder(BuilderImpl builder) {
        this.order = builder.order;
        this.computeEnvironment = builder.computeEnvironment;
    }

    /**
     * <p>
     * The order of the compute environment.
     * </p>
     * 
     * @return The order of the compute environment.
     */
    public Integer order() {
        return order;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the compute environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the compute environment.
     */
    public String computeEnvironment() {
        return computeEnvironment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(order());
        hashCode = 31 * hashCode + Objects.hashCode(computeEnvironment());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeEnvironmentOrder)) {
            return false;
        }
        ComputeEnvironmentOrder other = (ComputeEnvironmentOrder) obj;
        return Objects.equals(order(), other.order()) && Objects.equals(computeEnvironment(), other.computeEnvironment());
    }

    @Override
    public String toString() {
        return ToString.builder("ComputeEnvironmentOrder").add("Order", order()).add("ComputeEnvironment", computeEnvironment())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "order":
            return Optional.of(clazz.cast(order()));
        case "computeEnvironment":
            return Optional.of(clazz.cast(computeEnvironment()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComputeEnvironmentOrderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ComputeEnvironmentOrder> {
        /**
         * <p>
         * The order of the compute environment.
         * </p>
         * 
         * @param order
         *        The order of the compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder order(Integer order);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the compute environment.
         * </p>
         * 
         * @param computeEnvironment
         *        The Amazon Resource Name (ARN) of the compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironment(String computeEnvironment);
    }

    static final class BuilderImpl implements Builder {
        private Integer order;

        private String computeEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeEnvironmentOrder model) {
            order(model.order);
            computeEnvironment(model.computeEnvironment);
        }

        public final Integer getOrder() {
            return order;
        }

        @Override
        public final Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public final void setOrder(Integer order) {
            this.order = order;
        }

        public final String getComputeEnvironment() {
            return computeEnvironment;
        }

        @Override
        public final Builder computeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
            return this;
        }

        public final void setComputeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
        }

        @Override
        public ComputeEnvironmentOrder build() {
            return new ComputeEnvironmentOrder(this);
        }
    }
}
