/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteJobQueueRequest extends BatchRequest implements
        ToCopyableBuilder<DeleteJobQueueRequest.Builder, DeleteJobQueueRequest> {
    private final String jobQueue;

    private DeleteJobQueueRequest(BuilderImpl builder) {
        super(builder);
        this.jobQueue = builder.jobQueue;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the queue to delete.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the queue to delete.
     */
    public String jobQueue() {
        return jobQueue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobQueue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteJobQueueRequest)) {
            return false;
        }
        DeleteJobQueueRequest other = (DeleteJobQueueRequest) obj;
        return Objects.equals(jobQueue(), other.jobQueue());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteJobQueueRequest").add("JobQueue", jobQueue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobQueue":
            return Optional.of(clazz.cast(jobQueue()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends BatchRequest.Builder, CopyableBuilder<Builder, DeleteJobQueueRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the queue to delete.
         * </p>
         * 
         * @param jobQueue
         *        The short name or full Amazon Resource Name (ARN) of the queue to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String jobQueue;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteJobQueueRequest model) {
            jobQueue(model.jobQueue);
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteJobQueueRequest build() {
            return new DeleteJobQueueRequest(this);
        }
    }
}
