/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrder;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrdersCopier;
import software.amazon.awssdk.services.batch.model.JQState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateJobQueueRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, CreateJobQueueRequest> {
    private final String jobQueueName;
    private final String state;
    private final Integer priority;
    private final List<ComputeEnvironmentOrder> computeEnvironmentOrder;

    private CreateJobQueueRequest(BuilderImpl builder) {
        super(builder);
        this.jobQueueName = builder.jobQueueName;
        this.state = builder.state;
        this.priority = builder.priority;
        this.computeEnvironmentOrder = builder.computeEnvironmentOrder;
    }

    public String jobQueueName() {
        return this.jobQueueName;
    }

    public JQState state() {
        return JQState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public Integer priority() {
        return this.priority;
    }

    public List<ComputeEnvironmentOrder> computeEnvironmentOrder() {
        return this.computeEnvironmentOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobQueueName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironmentOrder());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobQueueRequest)) {
            return false;
        }
        CreateJobQueueRequest other = (CreateJobQueueRequest)((Object)obj);
        return Objects.equals(this.jobQueueName(), other.jobQueueName()) && Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.computeEnvironmentOrder(), other.computeEnvironmentOrder());
    }

    public String toString() {
        return ToString.builder((String)"CreateJobQueueRequest").add("JobQueueName", (Object)this.jobQueueName()).add("State", (Object)this.stateString()).add("Priority", (Object)this.priority()).add("ComputeEnvironmentOrder", this.computeEnvironmentOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobQueueName": {
                return Optional.of(clazz.cast(this.jobQueueName()));
            }
            case "state": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "priority": {
                return Optional.of(clazz.cast(this.priority()));
            }
            case "computeEnvironmentOrder": {
                return Optional.of(clazz.cast(this.computeEnvironmentOrder()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private String jobQueueName;
        private String state;
        private Integer priority;
        private List<ComputeEnvironmentOrder> computeEnvironmentOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobQueueRequest model) {
            this.jobQueueName(model.jobQueueName);
            this.state(model.state);
            this.priority(model.priority);
            this.computeEnvironmentOrder(model.computeEnvironmentOrder);
        }

        public final String getJobQueueName() {
            return this.jobQueueName;
        }

        @Override
        public final Builder jobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
            return this;
        }

        public final void setJobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JQState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<ComputeEnvironmentOrder.Builder> getComputeEnvironmentOrder() {
            return this.computeEnvironmentOrder != null ? (Collection)this.computeEnvironmentOrder.stream().map(ComputeEnvironmentOrder::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironmentOrder(ComputeEnvironmentOrder ... computeEnvironmentOrder) {
            this.computeEnvironmentOrder(Arrays.asList(computeEnvironmentOrder));
            return this;
        }

        public final void setComputeEnvironmentOrder(Collection<ComputeEnvironmentOrder.BuilderImpl> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copyFromBuilder(computeEnvironmentOrder);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateJobQueueRequest build() {
            return new CreateJobQueueRequest(this);
        }
    }

    public static interface Builder
    extends BatchRequest.Builder,
    CopyableBuilder<Builder, CreateJobQueueRequest> {
        public Builder jobQueueName(String var1);

        public Builder state(String var1);

        public Builder state(JQState var1);

        public Builder priority(Integer var1);

        public Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> var1);

        public Builder computeEnvironmentOrder(ComputeEnvironmentOrder ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

