/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrder;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrdersCopier;
import software.amazon.awssdk.services.batch.model.JQState;
import software.amazon.awssdk.services.batch.model.JQStatus;
import software.amazon.awssdk.services.batch.transform.JobQueueDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobQueueDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, JobQueueDetail> {
    private final String jobQueueName;
    private final String jobQueueArn;
    private final String state;
    private final String status;
    private final String statusReason;
    private final Integer priority;
    private final List<ComputeEnvironmentOrder> computeEnvironmentOrder;

    private JobQueueDetail(BuilderImpl builder) {
        this.jobQueueName = builder.jobQueueName;
        this.jobQueueArn = builder.jobQueueArn;
        this.state = builder.state;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.priority = builder.priority;
        this.computeEnvironmentOrder = builder.computeEnvironmentOrder;
    }

    public String jobQueueName() {
        return this.jobQueueName;
    }

    public String jobQueueArn() {
        return this.jobQueueArn;
    }

    public JQState state() {
        return JQState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public JQStatus status() {
        return JQStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public Integer priority() {
        return this.priority;
    }

    public List<ComputeEnvironmentOrder> computeEnvironmentOrder() {
        return this.computeEnvironmentOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobQueueName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobQueueArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironmentOrder());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobQueueDetail)) {
            return false;
        }
        JobQueueDetail other = (JobQueueDetail)obj;
        return Objects.equals(this.jobQueueName(), other.jobQueueName()) && Objects.equals(this.jobQueueArn(), other.jobQueueArn()) && Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.computeEnvironmentOrder(), other.computeEnvironmentOrder());
    }

    public String toString() {
        return ToString.builder((String)"JobQueueDetail").add("JobQueueName", (Object)this.jobQueueName()).add("JobQueueArn", (Object)this.jobQueueArn()).add("State", (Object)this.stateString()).add("Status", (Object)this.statusString()).add("StatusReason", (Object)this.statusReason()).add("Priority", (Object)this.priority()).add("ComputeEnvironmentOrder", this.computeEnvironmentOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobQueueName": {
                return Optional.of(clazz.cast(this.jobQueueName()));
            }
            case "jobQueueArn": {
                return Optional.of(clazz.cast(this.jobQueueArn()));
            }
            case "state": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "statusReason": {
                return Optional.of(clazz.cast(this.statusReason()));
            }
            case "priority": {
                return Optional.of(clazz.cast(this.priority()));
            }
            case "computeEnvironmentOrder": {
                return Optional.of(clazz.cast(this.computeEnvironmentOrder()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobQueueDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobQueueName;
        private String jobQueueArn;
        private String state;
        private String status;
        private String statusReason;
        private Integer priority;
        private List<ComputeEnvironmentOrder> computeEnvironmentOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(JobQueueDetail model) {
            this.jobQueueName(model.jobQueueName);
            this.jobQueueArn(model.jobQueueArn);
            this.state(model.state);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.priority(model.priority);
            this.computeEnvironmentOrder(model.computeEnvironmentOrder);
        }

        public final String getJobQueueName() {
            return this.jobQueueName;
        }

        @Override
        public final Builder jobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
            return this;
        }

        public final void setJobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
        }

        public final String getJobQueueArn() {
            return this.jobQueueArn;
        }

        @Override
        public final Builder jobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
            return this;
        }

        public final void setJobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JQState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JQStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<ComputeEnvironmentOrder.Builder> getComputeEnvironmentOrder() {
            return this.computeEnvironmentOrder != null ? (Collection)this.computeEnvironmentOrder.stream().map(ComputeEnvironmentOrder::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironmentOrder(ComputeEnvironmentOrder ... computeEnvironmentOrder) {
            this.computeEnvironmentOrder(Arrays.asList(computeEnvironmentOrder));
            return this;
        }

        public final void setComputeEnvironmentOrder(Collection<ComputeEnvironmentOrder.BuilderImpl> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copyFromBuilder(computeEnvironmentOrder);
        }

        public JobQueueDetail build() {
            return new JobQueueDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobQueueDetail> {
        public Builder jobQueueName(String var1);

        public Builder jobQueueArn(String var1);

        public Builder state(String var1);

        public Builder state(JQState var1);

        public Builder status(String var1);

        public Builder status(JQStatus var1);

        public Builder statusReason(String var1);

        public Builder priority(Integer var1);

        public Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> var1);

        public Builder computeEnvironmentOrder(ComputeEnvironmentOrder ... var1);
    }
}

